/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IWorldTickWarpEvent;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.MiscHelper;
import shukaro.warptheory.util.RandomBlockHelper;

public class WarpSnow
extends IWorldTickWarpEvent {
    public WarpSnow(int minWarp) {
        super("biomeSnow", minWarp, world -> 16 + world.field_73012_v.nextInt(16));
    }

    @Override
    public boolean canDo(World world, EntityPlayer player) {
        for (String n : MiscHelper.getWarpTag(player).func_150296_c()) {
            if (!n.startsWith("biome") || n.equals(this.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int triggerEvent(int eventAmount, World world, EntityPlayer player) {
        BlockCoord target = RandomBlockHelper.randomBlock(world, player, 16, block -> MiscHelper.hasNonSolidNeighbor(world, block));
        if (target == null) {
            return 0;
        }
        BlockCoord below = target.copy().offset(0);
        if (target.isAir((IBlockAccess)world) && below.isTopSolid((IBlockAccess)world)) {
            world.func_147449_b(target.x, target.y, target.z, Blocks.field_150431_aC);
            world.func_72908_a((double)target.x, (double)target.y, (double)target.z, "dig.snow", 1.0f, 1.0f);
            return 1;
        }
        if (target.getBlock(world) == Blocks.field_150431_aC) {
            int metadata = target.getMeta(world);
            if (metadata < 7) {
                world.func_72921_c(target.x, target.y, target.z, metadata + 1, 3);
            } else {
                world.func_147449_b(target.x, target.y, target.z, Blocks.field_150433_aE);
            }
            world.func_72908_a((double)target.x, (double)target.y, (double)target.z, "dig.snow", 1.0f, 1.0f);
            return 1;
        }
        BlockCoord above = target.copy().offset(1);
        if (target.getBlock(world) == Blocks.field_150355_j && above.isAir((IBlockAccess)world)) {
            world.func_147449_b(target.x, target.y, target.z, Blocks.field_150432_aD);
            world.func_72908_a((double)target.x, (double)target.y, (double)target.z, "dig.glass", 1.0f, 1.0f);
            return 1;
        }
        Block belowBlock = below.getBlock(world);
        if ((belowBlock == Blocks.field_150432_aD || belowBlock == Blocks.field_150433_aE || belowBlock == Blocks.field_150431_aC) && target.isAir((IBlockAccess)world) && above.isAir((IBlockAccess)world)) {
            EntitySnowman snowGolem = new EntitySnowman(world);
            snowGolem.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 72000));
            RandomBlockHelper.setLocation(world, (Entity)snowGolem, target);
            if (world.func_72838_d((Entity)snowGolem)) {
                world.func_72908_a((double)target.x, (double)target.y, (double)target.z, "dig.snow", 1.0f, 1.0f);
                return 1;
            }
        }
        return 0;
    }
}

