/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IWorldTickWarpEvent;
import shukaro.warptheory.util.MiscHelper;

public class WarpChests
extends IWorldTickWarpEvent {
    public WarpChests(int minWarp) {
        super("chests", minWarp, world -> 15 + world.field_73012_v.nextInt(30));
    }

    @Override
    public int triggerEvent(int eventAmount, World world, EntityPlayer player) {
        int successful = 0;
        ArrayList<IInventory> inventories = MiscHelper.getNearbyTileInventories(player, 8);
        ArrayList<TileEntityChest> chestInventories = new ArrayList<TileEntityChest>();
        for (IInventory i : inventories) {
            if (!(i instanceof TileEntityChest)) continue;
            chestInventories.add((TileEntityChest)i);
        }
        if (chestInventories.size() <= 0) {
            return 0;
        }
        TileEntityChest inv1 = (TileEntityChest)chestInventories.get(world.field_73012_v.nextInt(chestInventories.size()));
        TileEntityChest inv2 = (TileEntityChest)chestInventories.get(world.field_73012_v.nextInt(chestInventories.size()));
        if (world.field_73012_v.nextInt(10) == 0) {
            if (world.field_73012_v.nextBoolean()) {
                world.func_72908_a((double)inv1.field_145851_c, (double)inv1.field_145848_d + 0.5, (double)inv1.field_145849_e, "random.chestopen", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            } else {
                world.func_72908_a((double)inv2.field_145851_c, (double)inv2.field_145848_d + 0.5, (double)inv2.field_145849_e, "random.chestclosed", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            ++successful;
        }
        if (!WarpChests.shuffle(world.field_73012_v, (IInventory)inv1, (IInventory)inv2)) {
            WarpChests.shuffle(world.field_73012_v, (IInventory)inv1, (IInventory)inv2);
        }
        return successful;
    }

    private static boolean shuffle(Random rand, IInventory inv1, IInventory inv2) {
        int firstSlot = rand.nextInt(inv1.func_70302_i_());
        int secondSlot = rand.nextInt(inv2.func_70302_i_());
        ItemStack firstContents = inv1.func_70301_a(firstSlot);
        ItemStack secondContents = inv2.func_70301_a(secondSlot);
        if (inv1.func_94041_b(firstSlot, secondContents) && inv2.func_94041_b(secondSlot, firstContents)) {
            inv1.func_70299_a(firstSlot, secondContents);
            inv2.func_70299_a(secondSlot, firstContents);
        }
        return inv1.func_94041_b(firstSlot, secondContents) && inv2.func_94041_b(secondSlot, firstContents) && (firstContents != null || secondContents != null);
    }

    @Override
    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (e.world.func_82737_E() % 10L != 0L) {
            return;
        }
        super.onTick(e);
    }
}

