/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.thaumcraft.research.frontend.integration.adapters;

import elan.tweaks.thaumcraft.research.frontend.domain.ports.required.AspectPool;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.NotNull;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.tiles.TileResearchTable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u001c\u0010\u0013\u001a\u00020\b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u001b"}, d2={"Lelan/tweaks/thaumcraft/research/frontend/integration/adapters/AspectPoolAdapter;", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/required/AspectPool;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "table", "Lthaumcraft/common/tiles/TileResearchTable;", "(Lnet/minecraft/entity/player/EntityPlayer;Lthaumcraft/common/tiles/TileResearchTable;)V", "isCompound", "", "Lthaumcraft/api/aspects/Aspect;", "(Lthaumcraft/api/aspects/Aspect;)Z", "allDiscovered", "", "()[Lthaumcraft/api/aspects/Aspect;", "amountOf", "", "aspect", "anyComponentMissingFor", "bonusAmountOf", "contains", "aspectAmounts", "", "hasDiscovered", "playerAspectList", "Lthaumcraft/api/aspects/AspectList;", "kotlin.jvm.PlatformType", "totalAmountOf", "ThaumcraftResearchTweaks"})
@SourceDebugExtension(value={"SMAP\nAspectPoolAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspectPoolAdapter.kt\nelan/tweaks/thaumcraft/research/frontend/integration/adapters/AspectPoolAdapter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,40:1\n167#2,3:41\n*S KotlinDebug\n*F\n+ 1 AspectPoolAdapter.kt\nelan/tweaks/thaumcraft/research/frontend/integration/adapters/AspectPoolAdapter\n*L\n29#1:41,3\n*E\n"})
public final class AspectPoolAdapter
implements AspectPool {
    @NotNull
    private final EntityPlayer player;
    @NotNull
    private final TileResearchTable table;

    public AspectPoolAdapter(@NotNull EntityPlayer player, @NotNull TileResearchTable table) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.player = player;
        this.table = table;
    }

    @Override
    public boolean hasDiscovered(@NotNull Aspect aspect) {
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        return Thaumcraft.proxy.getPlayerKnowledge().hasDiscoveredAspect(this.player.func_70005_c_(), aspect);
    }

    @Override
    @NotNull
    public Aspect[] allDiscovered() {
        Aspect[] aspectArray = this.playerAspectList().getAspects();
        Intrinsics.checkNotNullExpressionValue((Object)aspectArray, (String)"playerAspectList().getAspects()");
        return aspectArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean anyComponentMissingFor(@NotNull Aspect aspect) {
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        Aspect[] aspectArray = aspect.getComponents();
        if (aspectArray == null) {
            return false;
        }
        Aspect[] components = aspectArray;
        if (!this.isCompound(aspect)) return false;
        if (components.length != 2) return false;
        Aspect aspect2 = components[0];
        Intrinsics.checkNotNullExpressionValue((Object)aspect2, (String)"components[0]");
        if (this.totalAmountOf(aspect2) > 0) return false;
        Aspect aspect3 = components[1];
        Intrinsics.checkNotNullExpressionValue((Object)aspect3, (String)"components[1]");
        if (this.totalAmountOf(aspect3) > 0) return false;
        return true;
    }

    private final boolean isCompound(Aspect $this$isCompound) {
        return !$this$isCompound.isPrimal();
    }

    @Override
    public boolean contains(@NotNull Map<Aspect, Integer> aspectAmounts) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(aspectAmounts, (String)"aspectAmounts");
            Map<Aspect, Integer> $this$all$iv = aspectAmounts;
            boolean $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator<Map.Entry<Aspect, Integer>> iterator = $this$all$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Aspect, Integer> element$iv;
                    Map.Entry<Aspect, Integer> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    Aspect aspect = entry.getKey();
                    int requiredAmount = ((Number)entry.getValue()).intValue();
                    if (this.totalAmountOf(aspect) >= requiredAmount) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public int totalAmountOf(@NotNull Aspect aspect) {
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        return this.amountOf(aspect) + this.bonusAmountOf(aspect);
    }

    @Override
    public int amountOf(@NotNull Aspect aspect) {
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        return this.playerAspectList().getAmount(aspect);
    }

    private final AspectList playerAspectList() {
        return Thaumcraft.proxy.getPlayerKnowledge().getAspectsDiscovered(this.player.func_70005_c_());
    }

    @Override
    public int bonusAmountOf(@NotNull Aspect aspect) {
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        return this.table.bonusAspects.getAmount(aspect);
    }

    @Override
    public boolean missing(@NotNull Map<Aspect, Integer> aspectAmounts) {
        return AspectPool.DefaultImpls.missing(this, aspectAmounts);
    }
}

