/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak;

import codechicken.lib.math.MathHelper;
import java.awt.Dimension;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class ClientUtils {
    public static final String TOOLTIP_LINESPACE = "\u00a7h";
    private static final GuiHook gui = new GuiHook();

    public static void drawRectTextured(double xmin, double xmax, double ymin, double ymax, double umin, double umax, double vmin, double vmax, double zLevel) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(xmin, ymax, zLevel, umin * (double)f, vmax * (double)f);
        tessellator.func_78374_a(xmax, ymax, zLevel, umax * (double)f, vmax * (double)f);
        tessellator.func_78374_a(xmax, ymin, zLevel, umax * (double)f, vmin * (double)f);
        tessellator.func_78374_a(xmin, ymin, zLevel, umin * (double)f, vmin * (double)f);
        tessellator.func_78381_a();
    }

    public static Dimension displaySize() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        return new Dimension(res.func_78326_a(), res.func_78328_b());
    }

    public static void drawMultilineTip(FontRenderer font, int x, int y, List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2929);
        RenderHelper.func_74518_a();
        int w = 0;
        int h = -2;
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            Dimension d = new Dimension(font.func_78256_a(s), list.get(i).endsWith(TOOLTIP_LINESPACE) && i + 1 < list.size() ? 12 : 10);
            w = Math.max(w, d.width);
            h += d.height;
        }
        if (x < 8) {
            x = 8;
        } else if (x > ClientUtils.displaySize().width - w - 8 && (x -= 24 + w) < 8) {
            x = 8;
        }
        y = (int)MathHelper.clip((double)y, (double)8.0, (double)(ClientUtils.displaySize().height - 8 - h));
        gui.incZLevel(300.0f);
        ClientUtils.drawTooltipBox(x - 4, y - 4, w + 7, h + 7);
        for (String s : list) {
            font.func_78261_a(s, x, y, -1);
            y += s.endsWith(TOOLTIP_LINESPACE) ? 12 : 10;
        }
        gui.incZLevel(-300.0f);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
    }

    public static void drawTooltipBox(int x, int y, int w, int h) {
        int bg = -267386864;
        ClientUtils.drawGradientRect(x + 1, y, w - 1, 1, bg, bg);
        ClientUtils.drawGradientRect(x + 1, y + h, w - 1, 1, bg, bg);
        ClientUtils.drawGradientRect(x + 1, y + 1, w - 1, h - 1, bg, bg);
        ClientUtils.drawGradientRect(x, y + 1, 1, h - 1, bg, bg);
        ClientUtils.drawGradientRect(x + w, y + 1, 1, h - 1, bg, bg);
        int grad1 = 0x505000FF;
        int grad2 = 1344798847;
        ClientUtils.drawGradientRect(x + 1, y + 2, 1, h - 3, grad1, grad2);
        ClientUtils.drawGradientRect(x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        ClientUtils.drawGradientRect(x + 1, y + 1, w - 1, 1, grad1, grad1);
        ClientUtils.drawGradientRect(x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }

    public static void drawGradientRect(int x, int y, int w, int h, int colour1, int colour2) {
        gui.func_73733_a(x, y, x + w, y + h, colour1, colour2);
    }

    public static class GuiHook
    extends Gui {
        public void setZLevel(float f) {
            this.field_73735_i = f;
        }

        public float getZLevel() {
            return this.field_73735_i;
        }

        public void incZLevel(float f) {
            this.field_73735_i += f;
        }

        public void func_73733_a(int par1, int par2, int par3, int par4, int par5, int par6) {
            super.func_73733_a(par1, par2, par3, par4, par5, par6);
        }
    }
}

