/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.entity;

import com.kuba6000.mobsinfo.api.MobDrop;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.armor.TinkerArmor;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.ToolCore;
import tconstruct.world.entity.BlueSlime;
import tconstruct.world.entity.SlimeBase;

public class KingBlueSlime
extends SlimeBase
implements IBossDisplayData {
    public KingBlueSlime(World world) {
        super(world);
        this.field_70728_aV = 500;
        this.func_110163_bv();
    }

    @Override
    protected String getSlimeParticle() {
        return "blueslime";
    }

    @Override
    protected SlimeBase createInstance(World world) {
        return new KingBlueSlime(world);
    }

    @Override
    protected void initializeSlime() {
        this.field_70129_M = 0.0f;
        this.slimeJumpDelay = this.field_70146_Z.nextInt(120) + 40;
        this.setSlimeSize(8);
    }

    @Override
    protected float getMaxHealthForSize() {
        return 100.0f;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() <= 0.0f) {
            for (int c = 15 + this.field_70146_Z.nextInt(6); c > 0; --c) {
                BlueSlime entityslime = new BlueSlime(this.field_70170_p);
                entityslime.setSlimeSize(1);
                double r = this.field_70146_Z.nextDouble() * Math.PI;
                double x = Math.cos(r);
                double z = Math.sin(r);
                entityslime.func_70012_b(this.field_70165_t - 1.0 + x, this.field_70163_u + 0.5, this.field_70161_v - 1.0 + z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                entityslime.field_70159_w = x;
                entityslime.field_70181_x = -0.5 - this.field_70146_Z.nextDouble();
                entityslime.field_70179_y = z;
                this.field_70170_p.func_72838_d((Entity)entityslime);
            }
        }
        this.field_70128_L = true;
    }

    @Override
    protected void func_70628_a(boolean par1, int par2) {
        super.func_70628_a(par1, par2);
        ToolCore tool = this.getValidTool();
        ItemStack headStack = new ItemStack(tool.getHeadItem(), 1, 17);
        ItemStack handleStack = new ItemStack(tool.getHandleItem(), 1, 17);
        ItemStack accessoryStack = tool.getAccessoryItem() != null ? new ItemStack(tool.getAccessoryItem(), 1, 17) : null;
        ItemStack extraStack = tool.getExtraItem() != null ? new ItemStack(tool.getExtraItem(), 1, 17) : null;
        String loc = "tool." + tool.getToolName().toLowerCase() + ".kingslime";
        String name = StatCollector.func_94522_b((String)loc) ? StatCollector.func_74838_a((String)loc) : StatCollector.func_74838_a((String)"tool.kingslimeprefix") + " " + tool.getLocalizedToolName();
        ItemStack toolStack = ToolBuilder.instance.buildTool(headStack, handleStack, accessoryStack, extraStack, name);
        if (toolStack != null) {
            NBTTagCompound tags = toolStack.func_77978_p().func_74775_l("InfiTool");
            tags.func_74768_a("Attack", 5 + tool.getDamageVsEntity(null));
            tags.func_74768_a("TotalDurability", 2500);
            tags.func_74768_a("BaseDurability", 2500);
            tags.func_74768_a("MiningSpeed", 1400);
            this.func_70099_a(toolStack, 0.0f);
            if (this.field_70146_Z.nextInt(5) == 0) {
                ItemStack dropStack = new ItemStack(TinkerArmor.heartCanister, 1, 1);
                this.func_70099_a(dropStack, 0.0f);
            }
        }
    }

    @Override
    @Optional.Method(modid="mobsinfo")
    public void provideDropsInformation(@Nonnull ArrayList<MobDrop> drops) {
        super.provideDropsInformation(drops);
        double chance = 1.0 / (double)TConstructRegistry.tools.size();
        int validtools = 0;
        for (ToolCore tool : TConstructRegistry.tools) {
            String loc;
            String name;
            ItemStack extraStack;
            ItemStack accessoryStack;
            ItemStack handleStack;
            ItemStack headStack = new ItemStack(tool.getHeadItem(), 1, 17);
            ItemStack toolStack = ToolBuilder.instance.buildTool(headStack, handleStack = new ItemStack(tool.getHandleItem(), 1, 17), accessoryStack = tool.getAccessoryItem() != null ? new ItemStack(tool.getAccessoryItem(), 1, 17) : null, extraStack = tool.getExtraItem() != null ? new ItemStack(tool.getExtraItem(), 1, 17) : null, name = StatCollector.func_94522_b((String)(loc = "tool." + tool.getToolName().toLowerCase() + ".kingslime")) ? StatCollector.func_74838_a((String)loc) : StatCollector.func_74838_a((String)"tool.kingslimeprefix") + " " + tool.getLocalizedToolName());
            if (toolStack == null) continue;
            NBTTagCompound tags = toolStack.func_77978_p().func_74775_l("InfiTool");
            tags.func_74768_a("Attack", 5 + tool.getDamageVsEntity(null));
            tags.func_74768_a("TotalDurability", 2500);
            tags.func_74768_a("BaseDurability", 2500);
            tags.func_74768_a("MiningSpeed", 1400);
            ++validtools;
            drops.add(MobDrop.create((ItemStack)toolStack).withChance(chance));
        }
        drops.add(MobDrop.create((ItemStack)new ItemStack(TinkerArmor.heartCanister, 1, 1)).withChance(chance / 5.0 * (double)validtools));
    }

    ToolCore getValidTool() {
        return TConstructRegistry.tools.get(this.field_70146_Z.nextInt(TConstructRegistry.tools.size()));
    }
}

