/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.world.TinkerWorld;
import tconstruct.world.model.OreberryRender;

public class OreberryBush
extends BlockLeavesBase
implements IPlantable {
    Random random;
    public IIcon[] fastIcons;
    public IIcon[] fancyIcons;
    public String[] textureNames;
    public String[] oreTypes;
    public int itemMeat;
    private final int subitems;

    public OreberryBush(String[] textureNames, int meta, int sub, String[] oreTypes) {
        super(Material.field_151584_j, false);
        this.textureNames = textureNames;
        this.itemMeat = meta;
        this.subitems = sub;
        this.oreTypes = oreTypes;
        this.func_149675_a(true);
        this.random = new Random();
        this.func_149711_c(0.3f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(TConstructRegistry.blockTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.fastIcons = new IIcon[this.textureNames.length];
        this.fancyIcons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.fastIcons.length; ++i) {
            if ("".equals(this.textureNames[i])) continue;
            this.fastIcons[i] = iconRegister.func_94245_a("tinker:crops/" + this.textureNames[i] + "_fast");
            this.fancyIcons[i] = iconRegister.func_94245_a("tinker:crops/" + this.textureNames[i] + "_fancy");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return (Blocks.field_150362_t.func_149662_c() ? this.fastIcons : this.fancyIcons)[metadata % 4 + (metadata < 12 ? 0 : 4)];
    }

    public int func_149692_a(int metadata) {
        return metadata % 4;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z);
        if (l < 4) {
            return AxisAlignedBB.func_72330_a((double)((double)x + 0.25), (double)y, (double)((double)z + 0.25), (double)((double)x + 0.75), (double)((double)y + 0.5), (double)((double)z + 0.75));
        }
        if (l < 8) {
            return AxisAlignedBB.func_72330_a((double)((double)x + 0.125), (double)y, (double)((double)z + 0.125), (double)((double)x + 0.875), (double)((double)y + 0.75), (double)((double)z + 0.875));
        }
        return AxisAlignedBB.func_72330_a((double)((double)x + 0.0625), (double)y, (double)((double)z + 0.0625), (double)((double)x + 0.9375), (double)((double)y + 0.9375), (double)((double)z + 0.9375));
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z);
        if (l < 4) {
            return AxisAlignedBB.func_72330_a((double)((double)x + 0.25), (double)y, (double)((double)z + 0.25), (double)((double)x + 0.75), (double)((double)y + 0.5), (double)((double)z + 0.75));
        }
        if (l < 8) {
            return AxisAlignedBB.func_72330_a((double)((double)x + 0.125), (double)y, (double)((double)z + 0.125), (double)((double)x + 0.875), (double)((double)y + 0.75), (double)((double)z + 0.875));
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0));
    }

    public void func_149719_a(IBlockAccess iblockaccess, int x, int y, int z) {
        float maxY;
        float maxX;
        float maxZ;
        float minX;
        float minZ;
        int md = iblockaccess.func_72805_g(x, y, z);
        float minY = 0.0f;
        if (md < 4) {
            minZ = 0.25f;
            minX = 0.25f;
            maxZ = 0.75f;
            maxX = 0.75f;
            maxY = 0.5f;
        } else if (md < 8) {
            minZ = 0.125f;
            minX = 0.125f;
            maxZ = 0.875f;
            maxX = 0.875f;
            maxY = 0.75f;
        } else {
            minZ = 0.0f;
            minX = 0.0f;
            maxZ = 1.0f;
            maxX = 1.0f;
            maxY = 1.0f;
        }
        this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        this.harvest(world, x, y, z, player);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        return this.harvest(world, x, y, z, player);
    }

    public boolean harvest(World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 12) {
            if (world.field_72995_K) {
                return true;
            }
            world.func_147465_d(x, y, z, (Block)this, meta - 4, 3);
            AbilityHelper.spawnItemAtPlayer(player, new ItemStack(TinkerWorld.oreBerries, this.random.nextInt(3) + 1, meta % 4 + this.itemMeat));
        }
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return OreberryRender.model;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        Block block = blockAccess.func_147439_a(x, y, z);
        if (block == this && blockAccess.func_72805_g(x, y, z) < 8) {
            return true;
        }
        if (Blocks.field_150362_t.func_149662_c() && block == this || block.func_149662_c()) {
            if (side == 0) {
                return false;
            }
            return this.field_149756_F < 1.0;
        }
        return true;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random1) {
        int meta;
        if (world.field_72995_K) {
            return;
        }
        if (random1.nextInt(20) == 0 && world.func_72883_k(x, y, z) < 10 && (meta = world.func_72805_g(x, y, z)) < 12) {
            world.func_147465_d(x, y, z, (Block)this, meta + 4, 3);
        }
    }

    public boolean canSustainPlant(World world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        if (plant instanceof OreberryBush) {
            return world.func_72805_g(x, y, z) > 7;
        }
        return super.canSustainPlant((IBlockAccess)world, x, y, z, direction, plant);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        if (world.func_72883_k(x, y, z) < 13) {
            return super.func_149742_c(world, x, y, z);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 8; var4 < 8 + this.subitems; ++var4) {
            par3List.add(new ItemStack(par1, 1, var4));
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Cave;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) - 4;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!(entity instanceof EntityItem)) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }
}

