/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import mantle.common.network.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import tconstruct.TConstruct;
import tconstruct.library.crafting.StencilBuilder;
import tconstruct.tools.inventory.PatternShaperContainer;
import tconstruct.tools.logic.StencilTableLogic;

public class PatternTablePacket
extends AbstractPacket {
    int x;
    int y;
    int z;
    ItemStack contents;

    public PatternTablePacket() {
    }

    public PatternTablePacket(int x, int y, int z, ItemStack contents) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.contents = contents;
    }

    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.contents);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.contents = ByteBufUtils.readItemStack((ByteBuf)buffer);
    }

    public void handleClientSide(EntityPlayer player) {
    }

    public void handleServerSide(EntityPlayer player) {
        if (player.field_71070_bA instanceof PatternShaperContainer) {
            PatternShaperContainer container = (PatternShaperContainer)player.field_71070_bA;
            StencilTableLogic logic = container.logic;
            if (logic != null && logic.field_145851_c == this.x && logic.field_145848_d == this.y && logic.field_145849_e == this.z) {
                if (this.contents == null) {
                    logic.setSelectedPattern(null);
                } else {
                    ItemStack stackBlank = logic.func_70301_a(0);
                    if (stackBlank != null && stackBlank.field_77994_a > 0 && StencilBuilder.isBlank(stackBlank)) {
                        boolean warning = true;
                        for (ItemStack stack : StencilBuilder.instance.stencils.values()) {
                            if (stack == null || !this.contents.func_77969_a(stack)) continue;
                            this.contents = stack.func_77946_l();
                            warning = false;
                            break;
                        }
                        if (warning) {
                            TConstruct.logger.warn("Possible packet-cheating with PatternTable for player " + player.func_70005_c_());
                        } else {
                            logic.setSelectedPattern(this.contents);
                        }
                    }
                }
            }
        }
    }
}

