/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools;

import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.IMobExtraInfoProvider;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobRecipe;
import com.kuba6000.mobsinfo.loader.extras.Translations;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.TConstruct;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.entity.ProjectileBase;
import tconstruct.library.event.PartBuilderEvent;
import tconstruct.library.event.ToolBuildEvent;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.FletchlingLeafMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.tools.TinkerTools;
import tconstruct.util.ItemHelper;
import tconstruct.util.config.PHConstruct;
import tconstruct.util.network.MovementUpdatePacket;

@Optional.Interface(iface="com.kuba6000.mobsinfo.api.IMobExtraInfoProvider", modid="mobsinfo")
public class TinkerToolEvents
implements IMobExtraInfoProvider {
    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting == null || event.player == null || event.player.field_70170_p == null || event.craftMatrix == null) {
            return;
        }
        Item item = event.crafting.func_77973_b();
        if (!event.player.field_70170_p.field_72995_K) {
            if (item == Item.func_150898_a((Block)TinkerTools.toolStationWood)) {
                if (!PHConstruct.beginnerBook) {
                    return;
                }
                TPlayerStats stats = TPlayerStats.get(event.player);
                if (!stats.materialManual) {
                    stats.materialManual = true;
                    AbilityHelper.spawnItemAtPlayer(event.player, new ItemStack(TinkerTools.manualBook, 1, 1));
                }
            }
            if (item == Item.func_150898_a((Block)TinkerTools.craftingSlabWood) && event.crafting.func_77960_j() == 4) {
                for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                    ItemStack stack = event.craftMatrix.func_70301_a(i);
                    if (stack == null || stack.func_77973_b() != Item.func_150898_a((Block)TinkerTools.toolStationWood) || stack.func_77960_j() != 5) continue;
                    event.crafting.func_77982_d(stack.func_77978_p());
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void buildTool(ToolBuildEvent event) {
        if (event.handleStack.func_77973_b() == Items.field_151103_aS) {
            event.handleStack = new ItemStack(TinkerTools.toolRod, 1, 5);
            return;
        }
        ArrayList sticks = OreDictionary.getOres((String)"stickWood");
        for (ItemStack stick : sticks) {
            if (!OreDictionary.itemMatches((ItemStack)stick, (ItemStack)event.handleStack, (boolean)false)) continue;
            event.handleStack = new ItemStack(TinkerTools.toolRod, 1, 0);
            return;
        }
    }

    @SubscribeEvent
    public void craftTool(ToolCraftEvent.NormalTool event) {
        int accessory;
        int handle;
        int head;
        NBTTagCompound toolTag = event.toolTag.func_74775_l("InfiTool");
        if (PHConstruct.denyMattock && event.tool == TinkerTools.mattock && !this.allowCrafting(head = toolTag.func_74762_e("Head"), handle = toolTag.func_74762_e("Handle"), accessory = toolTag.func_74762_e("Accessory"))) {
            event.setResult(Event.Result.DENY);
            return;
        }
        this.handlePaper(toolTag, event.tool);
        this.handleThaumium(toolTag, event.tool);
        if (event.tool == TinkerTools.battlesign) {
            int modifiers = toolTag.func_74762_e("Modifiers");
            toolTag.func_74768_a("Modifiers", ++modifiers);
        }
    }

    private void handlePaper(NBTTagCompound toolTag, ToolCore tool) {
        int modifiers = toolTag.func_74762_e("Modifiers");
        if (toolTag.func_74762_e("Head") == 9) {
            ++modifiers;
        }
        if (toolTag.func_74762_e("Handle") == 9) {
            ++modifiers;
        }
        if (toolTag.func_74762_e("Accessory") == 9) {
            ++modifiers;
        }
        if (toolTag.func_74762_e("Extra") == 9) {
            ++modifiers;
        }
        if (tool.getPartAmount() == 2 && toolTag.func_74762_e("Head") == 9) {
            ++modifiers;
        }
        toolTag.func_74768_a("Modifiers", modifiers);
    }

    private void handleThaumium(NBTTagCompound toolTag, ToolCore tool) {
        int thaum = 0;
        if (toolTag.func_74762_e("Head") == 31) {
            ++thaum;
        }
        if (toolTag.func_74762_e("Handle") == 31) {
            ++thaum;
        }
        if (toolTag.func_74762_e("Accessory") == 31) {
            ++thaum;
        }
        if (toolTag.func_74762_e("Extra") == 31) {
            ++thaum;
        }
        int bonusModifiers = (int)Math.ceil((double)thaum / 2.0);
        if (tool.getPartAmount() == 2) {
            bonusModifiers = thaum;
        }
        int modifiers = toolTag.func_74762_e("Modifiers");
        toolTag.func_74768_a("Modifiers", modifiers += bonusModifiers);
    }

    private boolean allowCrafting(int head, int handle, int accessory) {
        int[] nonMetals;
        for (int nonMetal : nonMetals = new int[]{0, 1, 3, 4, 5, 6, 7, 8, 9, 17}) {
            if (head != nonMetal && handle != nonMetal && accessory != nonMetal) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void craftPart(PartBuilderEvent.NormalPart event) {
        ItemStack result;
        if (event.pattern.func_77973_b() == TinkerTools.woodPattern && event.pattern.func_77960_j() == 23 && (result = TinkerToolEvents.craftBowString(event.material)) != null) {
            event.overrideResult(new ItemStack[]{result, null});
        }
        if (event.pattern.func_77973_b() == TinkerTools.woodPattern && event.pattern.func_77960_j() == 24 && (result = TinkerToolEvents.craftFletching(event.material)) != null) {
            event.overrideResult(new ItemStack[]{result, null});
        }
    }

    public static ItemStack craftBowString(ItemStack stack) {
        if (stack.field_77994_a < 3) {
            return null;
        }
        BowstringMaterial mat = (BowstringMaterial)TConstructRegistry.getCustomMaterial(stack, BowstringMaterial.class);
        if (mat != null) {
            return mat.craftingItem.func_77946_l();
        }
        return null;
    }

    public static ItemStack craftFletching(ItemStack stack) {
        FletchingMaterial mat = (FletchingMaterial)TConstructRegistry.getCustomMaterial(stack, FletchingMaterial.class);
        if (mat == null) {
            mat = (FletchingMaterial)TConstructRegistry.getCustomMaterial(stack, FletchlingLeafMaterial.class);
        }
        if (mat != null) {
            return mat.craftingItem.func_77946_l();
        }
        return null;
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (event.entityLiving instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.entityLiving).func_71045_bC()) != null && stack.func_77973_b() == TinkerTools.battlesign) {
            if (!stack.func_77942_o() || stack.func_77978_p().func_74775_l("InfiTool").func_74767_n("Broken")) {
                return;
            }
            DamageSource source = event.source;
            if (!(source.func_76363_c() || source.func_82725_o() || source.func_94541_c())) {
                if (source.func_76352_a()) {
                    Entity projectile = source.func_76364_f();
                    if (projectile == null) {
                        return;
                    }
                    Vec3 motion = Vec3.func_72443_a((double)projectile.field_70159_w, (double)projectile.field_70181_x, (double)projectile.field_70179_y);
                    Vec3 look = player.func_70040_Z();
                    double strength = -look.func_72430_b(motion.func_72432_b());
                    if (strength < 0.1) {
                        return;
                    }
                    event.setCanceled(true);
                    double speed = projectile.field_70159_w * projectile.field_70159_w + projectile.field_70181_x * projectile.field_70181_x + projectile.field_70179_y * projectile.field_70179_y;
                    speed = Math.sqrt(speed);
                    speed = (speed + 2.0) * strength;
                    projectile.field_70159_w = look.field_72450_a * speed;
                    projectile.field_70181_x = look.field_72448_b * speed;
                    projectile.field_70179_y = look.field_72449_c * speed;
                    projectile.field_70177_z = (float)(Math.atan2(projectile.field_70159_w, projectile.field_70179_y) * 180.0 / Math.PI);
                    projectile.field_70125_A = (float)(Math.atan2(projectile.field_70181_x, speed) * 180.0 / Math.PI);
                    TConstruct.packetPipeline.sendToAll(new MovementUpdatePacket(projectile));
                    if (projectile instanceof EntityArrow) {
                        ((EntityArrow)projectile).field_70250_c = player;
                        projectile.field_70159_w /= (double)-0.1f;
                        projectile.field_70181_x /= (double)-0.1f;
                        projectile.field_70179_y /= (double)-0.1f;
                        if (projectile instanceof ProjectileBase) {
                            ((ProjectileBase)projectile).defused = false;
                        }
                    }
                } else {
                    Entity attacker = source.func_76346_g();
                    if (attacker != null) {
                        attacker.func_70097_a(DamageSource.func_92087_a((Entity)player), event.ammount);
                    }
                }
                AbilityHelper.damageTool(stack, (int)Math.ceil(event.ammount / 2.0f), (EntityLivingBase)player, false);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        int beheading;
        ItemStack stack;
        if (event.entityLiving == null) {
            return;
        }
        if (event.recentlyHit) {
            EntityPlayer player;
            EntitySkeleton enemy;
            if (event.entityLiving instanceof EntitySkeleton) {
                enemy = (EntitySkeleton)event.entityLiving;
                if (event.source.field_76373_n.equals("player") && (stack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                    beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                    if (stack.func_77973_b() == TinkerTools.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && TConstruct.random.nextInt(100) < beheading * 10) {
                        ItemHelper.addDrops(event, new ItemStack(Items.field_151144_bL, 1, enemy.func_82202_m()));
                    }
                }
                if (enemy.func_82202_m() == 1 && TConstruct.random.nextInt(Math.max(1, 5 - event.lootingLevel)) == 0) {
                    ItemHelper.addDrops(event, new ItemStack(TinkerTools.materials, 1, 8));
                }
            }
            if (event.entityLiving.getClass() == EntityZombie.class) {
                enemy = (EntityZombie)event.entityLiving;
                if (event.source.field_76373_n.equals("player")) {
                    player = (EntityPlayer)event.source.func_76346_g();
                    stack = player.func_71045_bC();
                    if (stack != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                        beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                        if (stack != null && stack.func_77942_o() && stack.func_77973_b() == TinkerTools.cleaver) {
                            beheading += 2;
                        }
                        if (beheading > 0 && TConstruct.random.nextInt(100) < beheading * 10) {
                            ItemHelper.addDrops(event, new ItemStack(Items.field_151144_bL, 1, 2));
                        }
                    }
                    if (stack != null && stack.func_77942_o() && stack.func_77973_b() == TinkerTools.cleaver && TConstruct.random.nextInt(100) < 10) {
                        ItemHelper.addDrops(event, new ItemStack(Items.field_151144_bL, 1, 2));
                    }
                }
            }
            if (event.entityLiving.getClass() == EntityCreeper.class) {
                enemy = (EntityCreeper)event.entityLiving;
                if (event.source.field_76373_n.equals("player") && (stack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                    beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                    if (stack.func_77973_b() == TinkerTools.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && TConstruct.random.nextInt(100) < beheading * 5) {
                        ItemHelper.addDrops(event, new ItemStack(Items.field_151144_bL, 1, 4));
                    }
                }
            }
        }
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer source;
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (PHConstruct.dropPlayerHeads) {
                ItemStack dropStack = new ItemStack(Items.field_151144_bL, 1, 3);
                NBTTagCompound nametag = new NBTTagCompound();
                nametag.func_74778_a("SkullOwner", player.getDisplayName());
                dropStack.func_77982_d(nametag);
                ItemHelper.addDrops(event, dropStack);
            } else if (event.source.field_76373_n.equals("player") && (stack = (source = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                if (stack.func_77973_b() == TinkerTools.cleaver) {
                    beheading += 2;
                }
                if (beheading > 0 && TConstruct.random.nextInt(100) < beheading * 50) {
                    ItemStack dropStack = new ItemStack(Items.field_151144_bL, 1, 3);
                    NBTTagCompound nametag = new NBTTagCompound();
                    nametag.func_74778_a("SkullOwner", player.getDisplayName());
                    dropStack.func_77982_d(nametag);
                    ItemHelper.addDrops(event, dropStack);
                }
            }
        }
    }

    @Optional.Method(modid="mobsinfo")
    public void provideExtraDropsInformation(@Nonnull String entityString, @Nonnull ArrayList<MobDrop> drops, @Nonnull MobRecipe recipe) {
        MobDrop drop2;
        MobDrop drop;
        if (recipe.entity instanceof EntitySkeleton) {
            drop = new MobDrop(new ItemStack(Items.field_151144_bL, 1, ((EntitySkeleton)recipe.entity).func_82202_m()), MobDrop.DropType.Normal, 0, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.add(new BeheadingModifier(10.0, 20.0));
            drops.add(drop);
            if (((EntitySkeleton)recipe.entity).func_82202_m() == 1) {
                drop2 = new MobDrop(new ItemStack(TinkerTools.materials, 1, 8), MobDrop.DropType.Normal, 2000, null, null, true, false);
                drops.add(drop2);
            }
        }
        if (recipe.entity.getClass() == EntityZombie.class) {
            drop = new MobDrop(new ItemStack(Items.field_151144_bL, 1, 2), MobDrop.DropType.Normal, 0, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.add(new BeheadingModifier(10.0, 20.0));
            drops.add(drop);
            drop2 = new MobDrop(new ItemStack(TinkerTools.materials, 1, 2), MobDrop.DropType.Normal, 0, null, null, true, false);
            drop2.variableChance = true;
            drop2.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(10.0), new IChanceModifier.DropsOnlyUsing((Item)TinkerTools.cleaver)));
            drops.add(drop2);
        }
        if (recipe.entity.getClass() == EntityCreeper.class) {
            drop = new MobDrop(new ItemStack(Items.field_151144_bL, 1, 4), MobDrop.DropType.Normal, 0, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.add(new BeheadingModifier(5.0, 10.0));
            drops.add(drop);
        }
    }

    @SubscribeEvent
    public void registerOre(OreDictionary.OreRegisterEvent evt) {
        if (evt.Name.equals("crystalQuartz")) {
            TinkerTools.modAttack.addStackToMatchList(evt.Ore, 2);
        } else if (evt.Name.equals("crystalCertusQuartz")) {
            TinkerTools.modAttack.addStackToMatchList(evt.Ore, 24);
        }
    }

    @SubscribeEvent
    public void damageToolsOnDeath(PlayerDropsEvent event) {
        if (!PHConstruct.deathPenality) {
            return;
        }
        EnumDifficulty difficulty = event.entityPlayer.field_70170_p.field_73013_u;
        if (difficulty == EnumDifficulty.PEACEFUL || difficulty == EnumDifficulty.EASY) {
            return;
        }
        int punishment = 20;
        if (difficulty == EnumDifficulty.HARD) {
            punishment = 10;
        }
        int derp = 1;
        if (event.entityPlayer.field_70173_aa < 6000) {
            derp = TPlayerStats.get((EntityPlayer)event.entityPlayer).derpLevel;
            if (derp <= 0) {
                derp = 1;
            }
            punishment *= derp;
        }
        boolean damaged = false;
        for (EntityItem drop : event.drops) {
            if (!(drop.func_92059_d().func_77973_b() instanceof ToolCore) || !drop.func_92059_d().func_77942_o()) continue;
            NBTTagCompound tags = drop.func_92059_d().func_77978_p().func_74775_l("InfiTool");
            int dur = tags.func_74762_e("TotalDurability");
            AbilityHelper.damageTool(drop.func_92059_d(), dur /= punishment, (EntityLivingBase)event.entityPlayer, true);
            damaged = true;
        }
        if (damaged) {
            ++derp;
        }
        TPlayerStats.get((EntityPlayer)event.entityPlayer).derpLevel = derp + 1;
    }

    private static class BeheadingModifier
    implements IChanceModifier {
        double m1;
        double m2;

        BeheadingModifier() {
        }

        BeheadingModifier(double m1, double m2) {
            this.m1 = m1;
            this.m2 = m2;
        }

        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        public void applyTooltip(List<String> currentTooltip) {
            currentTooltip.addAll(Arrays.asList(Translations.BASE_CHANCE.get(new Object[]{0.0}), StatCollector.func_74837_a((String)"tconstruct.mobsinfocompat.tinkers_construct_beheading", (Object[])new Object[]{this.m1}), StatCollector.func_74837_a((String)"tconstruct.mobsinfocompat.tinkers_construct_beheading_1", (Object[])new Object[]{this.m2})));
        }

        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (!(attacker instanceof EntityPlayer)) {
                return 0.0;
            }
            ItemStack stack = ((EntityPlayer)attacker).func_71045_bC();
            if (stack != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                int beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                if (stack.func_77973_b() == TinkerTools.cleaver) {
                    beheading += 2;
                }
                return this.m1 * (double)beheading;
            }
            return 0.0;
        }

        public void writeToByteBuf(ByteBuf byteBuf) {
            byteBuf.writeDouble(this.m1);
            byteBuf.writeDouble(this.m2);
        }

        public void readFromByteBuf(ByteBuf byteBuf) {
            this.m1 = byteBuf.readDouble();
            this.m2 = byteBuf.readDouble();
        }
    }
}

