/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.gtnh;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTUtility;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModRecipes {
    private static final String MOD_ID_CB = "CarpentersBlocks";
    private static final String FLUID_NAME_refinedglue = "refinedglue";
    private static final String ORE_boltGold = "boltGold";
    private static final String ORE_chestWood = "chestWood";
    private static final String ORE_circuitGood = "circuitGood";
    private static final String ORE_craftingToolSaw = "craftingToolSaw";
    private static final String ORE_craftingToolScrewdriver = "craftingToolScrewdriver";
    private static final String ORE_drawerBasic = "drawerBasic";
    private static final String ORE_fenceWood = "fenceWood";
    private static final String ORE_plateAluminium = "plateAluminium";
    private static final String ORE_plateBronze = "plateBronze";
    private static final String ORE_plateDiamond = "plateDiamond";
    private static final String ORE_plateDenseObsidian = "plateDenseObsidian";
    private static final String ORE_plateEnderEye = "plateEnderEye";
    private static final String ORE_plateEmerald = "plateEmerald";
    private static final String ORE_plateGold = "plateGold";
    private static final String ORE_plateIron = "plateIron";
    private static final String ORE_plateObsidian = "plateObsidian";
    private static final String ORE_plateRedstone = "plateRedstone";
    private static final String ORE_plateRubber = "plateRubber";
    private static final String ORE_plateRuby = "plateRuby";
    private static final String ORE_plateStainlessSteel = "plateStainlessSteel";
    private static final String ORE_plateSteel = "plateSteel";
    private static final String ORE_plateTantalum = "plateTantalum";
    private static final String ORE_plateTanzanite = "plateTanzanite";
    private static final String ORE_plateTitanium = "plateTitanium";
    private static final String ORE_screwSteel = "screwSteel";
    private static final String ORE_slabWood = "slabWood";
    private static final String ORE_stickDiamond = "stickDiamond";
    private static final String ORE_stickEmerald = "stickEmerald";
    private static final String ORE_stickGold = "stickGold";
    private static final String ORE_stickIron = "stickIron";
    private static final String ORE_stickObsidian = "stickObsidian";
    private static final String ORE_stickRubber = "stickRubber";
    private static final String ORE_stickRuby = "stickRuby";
    private static final String ORE_stickTanzanite = "stickTanzanite";
    private static final String ORE_stickWood = "stickWood";
    private static final String ORE_stoneConcrete = "stoneConcrete";
    private static final String NAME_blockCarpentersBlock = "blockCarpentersBlock";
    private static final ImmutableList<ItemStack> slabWood8WList;
    private static final ImmutableList<ItemStack> slabWood7WList;
    private static final ImmutableList<ItemStack> slabWood5WList;
    private static final ImmutableList<ItemStack> slabWood4WList;
    private static final ItemStack chest1;
    private static final ItemStack chest2;
    private static final ItemStack chest4;
    private static final ItemStack chest5;
    private static final ItemStack integratedCircuit1;
    private static final ItemStack integratedCircuit2;
    private static final ItemStack integratedCircuit4;
    private static final ItemStack integratedCircuit12;
    private static final ItemStack integratedCircuit14;
    private static final ItemStack carpentersBlock8;
    private static final ItemStack carpentersBlock7;
    private static final ItemStack carpentersBlock5;
    private static final ItemStack carpentersBlock4;
    private static final ItemStack carpentersBlock1;
    private static final ItemStack stick4;
    private static final ItemStack comparatorGate;
    private static final ItemStack redAlloyWire;
    private static final ItemStack upgradeLock;
    private static final ItemStack piston;
    private static final ItemStack upgradeTemplate;
    private static final ImmutableList<ItemStack> drawerBasicW;

    private ModRecipes() {
        throw new IllegalStateException("Utility class");
    }

    public static void init() {
        ModRecipes.fullDrawers1Recipes();
        ModRecipes.fullDrawers2Recipes();
        ModRecipes.fullDrawers4Recipes();
        ModRecipes.halfDrawers2Recipes();
        ModRecipes.halfDrawers4Recipes();
        ModRecipes.trimRecipes();
        ModRecipes.compDrawersRecipes();
        ModRecipes.controllerRecipes();
        ModRecipes.controllerSlaveRecipes();
        ModRecipes.framingTableRecipes();
        ModRecipes.upgradeTemplateRecipes();
        ModRecipes.storageUpgradeRecipes();
        ModRecipes.statusUpgradeRecipes();
        ModRecipes.redstoneUpgradeRecipes();
        ModRecipes.voidUpgradeRecipes();
        ModRecipes.lockUpgradeRecipes();
        ModRecipes.shroudKeyUpgradeRecipes();
        ModRecipes.personalKeyUpgradeRecipes();
        ModRecipes.packingTapeRecipes();
    }

    private static void fullDrawers1Recipes() {
        if (!StorageDrawers.config.isBlockEnabled("fulldrawers1")) {
            return;
        }
        int recipeOutput = StorageDrawers.config.getBlockRecipeOutput("fulldrawers1");
        ItemStack fullDrawer1 = new ItemStack((Block)ModBlocks.fullDrawers1, recipeOutput, 0);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(fullDrawer1, new Object[]{"sss", "scs", "sss", Character.valueOf('s'), ORE_slabWood, Character.valueOf('c'), ORE_chestWood}));
        for (ItemStack slabWood8W : slabWood8WList) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{slabWood8W, chest1, integratedCircuit1}).itemOutputs(new ItemStack[]{fullDrawer1}).duration(200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        if (!StorageDrawers.config.cache.enableFramedDrawers) {
            return;
        }
        ItemStack fullCustom1 = new ItemStack((Block)ModBlocks.fullCustom1, recipeOutput, 0);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(fullCustom1, new Object[]{"bbb", "bcb", "bbb", Character.valueOf('b'), carpentersBlock1, Character.valueOf('c'), ORE_chestWood}));
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{carpentersBlock8, chest1, integratedCircuit1}).itemOutputs(new ItemStack[]{fullCustom1}).duration(200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }

    private static void fullDrawers2Recipes() {
        if (!StorageDrawers.config.isBlockEnabled("fulldrawers2")) {
            return;
        }
        int recipeOutput = StorageDrawers.config.getBlockRecipeOutput("fulldrawers2");
        ItemStack fullDrawers2 = new ItemStack((Block)ModBlocks.fullDrawers2, recipeOutput, 0);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(fullDrawers2, new Object[]{"scs", "sss", "scs", Character.valueOf('s'), ORE_slabWood, Character.valueOf('c'), ORE_chestWood}));
        for (ItemStack slabWood7W : slabWood7WList) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{slabWood7W, chest2, integratedCircuit2}).itemOutputs(new ItemStack[]{fullDrawers2}).duration(200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        if (!StorageDrawers.config.cache.enableFramedDrawers) {
            return;
        }
        ItemStack fullCustom2 = new ItemStack((Block)ModBlocks.fullCustom2, recipeOutput, 0);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(fullCustom2, new Object[]{"bcb", "bbb", "bcb", Character.valueOf('b'), carpentersBlock1, Character.valueOf('c'), ORE_chestWood}));
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{carpentersBlock7, chest2, integratedCircuit2}).itemOutputs(new ItemStack[]{fullCustom2}).duration(200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }

    private static void fullDrawers4Recipes() {
        if (!StorageDrawers.config.isBlockEnabled("fulldrawers4")) {
            return;
        }
        int recipeOutput = StorageDrawers.config.getBlockRecipeOutput("fulldrawers4");
        ItemStack fullDrawers4 = new ItemStack((Block)ModBlocks.fullDrawers4, recipeOutput, 0);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(fullDrawers4, new Object[]{"csc", "sss", "csc", Character.valueOf('s'), ORE_slabWood, Character.valueOf('c'), ORE_chestWood}));
        for (ItemStack slabWood5W : slabWood5WList) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{slabWood5W, chest4, integratedCircuit4}).itemOutputs(new ItemStack[]{fullDrawers4}).duration(200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        if (!StorageDrawers.config.cache.enableFramedDrawers) {
            return;
        }
        ItemStack fullCustom4 = new ItemStack((Block)ModBlocks.fullCustom4, recipeOutput, 0);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(fullCustom4, new Object[]{"cbc", "bbb", "cbc", Character.valueOf('b'), carpentersBlock1, Character.valueOf('c'), ORE_chestWood}));
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{carpentersBlock5, chest4, integratedCircuit4}).itemOutputs(new ItemStack[]{fullCustom4}).duration(200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }

    private static void halfDrawers2Recipes() {
        if (!StorageDrawers.config.isBlockEnabled("halfdrawers2")) {
            return;
        }
        int recipeOutput = StorageDrawers.config.getBlockRecipeOutput("halfdrawers2");
        ItemStack halfDrawers2 = new ItemStack((Block)ModBlocks.halfDrawers2, recipeOutput, 0);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(halfDrawers2, new Object[]{"sss", "csc", "sss", Character.valueOf('s'), ORE_slabWood, Character.valueOf('c'), ORE_chestWood}));
        for (ItemStack slabWood7W : slabWood7WList) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{slabWood7W, chest2, integratedCircuit12}).itemOutputs(new ItemStack[]{halfDrawers2}).duration(200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        if (!StorageDrawers.config.cache.enableFramedDrawers) {
            return;
        }
        ItemStack halfCustom2 = new ItemStack((Block)ModBlocks.halfCustom2, recipeOutput, 0);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(halfCustom2, new Object[]{"bbb", "cbc", "bbb", Character.valueOf('b'), carpentersBlock1, Character.valueOf('c'), ORE_chestWood}));
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{carpentersBlock7, chest2, integratedCircuit12}).itemOutputs(new ItemStack[]{halfCustom2}).duration(200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }

    private static void halfDrawers4Recipes() {
        if (!StorageDrawers.config.isBlockEnabled("halfdrawers4")) {
            return;
        }
        int recipeOutput = StorageDrawers.config.getBlockRecipeOutput("halfdrawers4");
        ItemStack halfDrawers4 = new ItemStack((Block)ModBlocks.halfDrawers4, recipeOutput, 0);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(halfDrawers4, new Object[]{"csc", "scs", "csc", Character.valueOf('s'), ORE_slabWood, Character.valueOf('c'), ORE_chestWood}));
        for (ItemStack slabWood4W : slabWood4WList) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{slabWood4W, chest5, integratedCircuit14}).itemOutputs(new ItemStack[]{halfDrawers4}).duration(200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        if (!StorageDrawers.config.cache.enableFramedDrawers) {
            return;
        }
        ItemStack halfCustom4 = new ItemStack((Block)ModBlocks.halfCustom4, recipeOutput, 0);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(halfCustom4, new Object[]{"cbc", "bcb", "cbc", Character.valueOf('b'), carpentersBlock1, Character.valueOf('c'), ORE_chestWood}));
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{carpentersBlock4, chest5, integratedCircuit14}).itemOutputs(new ItemStack[]{halfCustom4}).duration(200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }

    private static void trimRecipes() {
        if (!StorageDrawers.config.isBlockEnabled("trim")) {
            return;
        }
        int recipeOutput = StorageDrawers.config.getBlockRecipeOutput("trim");
        ItemStack trim = new ItemStack((Block)ModBlocks.trim, recipeOutput, 0);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(trim, new Object[]{"tst", "sss", "tst", Character.valueOf('t'), ORE_stickWood, Character.valueOf('s'), ORE_slabWood}));
        for (ItemStack slabWood5W : slabWood5WList) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{slabWood5W, stick4, integratedCircuit1}).itemOutputs(new ItemStack[]{trim}).duration(200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        if (!StorageDrawers.config.cache.enableFramedDrawers) {
            return;
        }
        ItemStack trimCustom = new ItemStack((Block)ModBlocks.trimCustom, recipeOutput, 0);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(trimCustom, new Object[]{"tbt", "bbb", "tbt", Character.valueOf('b'), carpentersBlock1, Character.valueOf('t'), ORE_stickWood}));
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{carpentersBlock5, stick4, integratedCircuit1}).itemOutputs(new ItemStack[]{trimCustom}).duration(200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }

    private static void compDrawersRecipes() {
        if (!StorageDrawers.config.isBlockEnabled("compdrawers")) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.compDrawers, 1), new Object[]{new String[]{"sss", "pdp", "oio"}, Character.valueOf('s'), ORE_stoneConcrete, Character.valueOf('p'), piston, Character.valueOf('d'), ORE_drawerBasic, Character.valueOf('o'), ORE_plateObsidian, Character.valueOf('i'), ORE_plateIron}));
    }

    private static void controllerRecipes() {
        if (!StorageDrawers.config.isBlockEnabled("controller")) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.controller), new Object[]{new String[]{"scs", "gbg", "odo"}, Character.valueOf('s'), ORE_plateStainlessSteel, Character.valueOf('c'), ORE_circuitGood, Character.valueOf('g'), comparatorGate, Character.valueOf('b'), ORE_drawerBasic, Character.valueOf('o'), ORE_plateObsidian, Character.valueOf('d'), ORE_plateDiamond}));
    }

    private static void controllerSlaveRecipes() {
        if (!StorageDrawers.config.isBlockEnabled("controllerSlave")) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.controllerSlave), new Object[]{"scs", "gbg", "oeo", Character.valueOf('s'), ORE_plateStainlessSteel, Character.valueOf('c'), ORE_circuitGood, Character.valueOf('g'), comparatorGate, Character.valueOf('b'), ORE_drawerBasic, Character.valueOf('o'), ORE_plateObsidian, Character.valueOf('e'), ORE_plateEnderEye}));
    }

    private static void framingTableRecipes() {
        if (!StorageDrawers.config.cache.enableFramedDrawers) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.framingTable), new Object[]{"ttt", "fsf", "fdf", Character.valueOf('t'), ModBlocks.trim, Character.valueOf('f'), ORE_fenceWood, Character.valueOf('s'), ORE_stickWood, Character.valueOf('d'), ORE_craftingToolScrewdriver}));
    }

    private static void upgradeTemplateRecipes() {
        if (!(StorageDrawers.config.cache.enableIndicatorUpgrades || StorageDrawers.config.cache.enableLockUpgrades || StorageDrawers.config.cache.enablePersonalUpgrades || StorageDrawers.config.cache.enableRedstoneUpgrades || StorageDrawers.config.cache.enableShroudUpgrades || StorageDrawers.config.cache.enableSortingUpgrades || StorageDrawers.config.cache.enableStorageUpgrades || StorageDrawers.config.cache.enableVoidUpgrades)) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(upgradeTemplate, new Object[]{new String[]{"sps", "sds", " t "}, Character.valueOf('s'), ORE_screwSteel, Character.valueOf('p'), piston, Character.valueOf('d'), ORE_drawerBasic, Character.valueOf('t'), ORE_craftingToolScrewdriver}));
        for (ItemStack drawer : drawerBasicW) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{drawer, piston}).itemOutputs(new ItemStack[]{upgradeTemplate}).duration(1200).eut(16).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
    }

    private static void storageUpgradeRecipes() {
        if (!StorageDrawers.config.cache.enableStorageUpgrades) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgrade, 1, 2), new Object[]{new String[]{"pup", "upu", "psp"}, Character.valueOf('p'), ORE_plateIron, Character.valueOf('s'), ORE_stickIron, Character.valueOf('u'), upgradeTemplate}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgrade, 1, 3), new Object[]{new String[]{"pup", "utu", "psp"}, Character.valueOf('p'), ORE_plateGold, Character.valueOf('s'), ORE_stickGold, Character.valueOf('u'), upgradeTemplate, Character.valueOf('t'), ORE_plateBronze}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgrade, 1, 4), new Object[]{new String[]{"pup", "utu", "psp"}, Character.valueOf('p'), ORE_plateObsidian, Character.valueOf('s'), ORE_stickObsidian, Character.valueOf('u'), upgradeTemplate, Character.valueOf('t'), ORE_plateSteel}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgrade, 1, 5), new Object[]{new String[]{"pup", "utu", "psp"}, Character.valueOf('p'), ORE_plateDiamond, Character.valueOf('s'), ORE_stickDiamond, Character.valueOf('u'), upgradeTemplate, Character.valueOf('t'), ORE_plateAluminium}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgrade, 1, 6), new Object[]{new String[]{"pup", "utu", "psp"}, Character.valueOf('p'), ORE_plateEmerald, Character.valueOf('s'), ORE_stickEmerald, Character.valueOf('u'), upgradeTemplate, Character.valueOf('t'), ORE_plateTantalum}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgrade, 1, 7), new Object[]{new String[]{"pup", "utu", "psp"}, Character.valueOf('p'), ORE_plateRuby, Character.valueOf('s'), ORE_stickRuby, Character.valueOf('u'), upgradeTemplate, Character.valueOf('t'), ORE_plateStainlessSteel}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgrade, 1, 8), new Object[]{new String[]{"pup", "utu", "psp"}, Character.valueOf('p'), ORE_plateTanzanite, Character.valueOf('s'), ORE_stickTanzanite, Character.valueOf('u'), upgradeTemplate, Character.valueOf('t'), ORE_plateTitanium}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeDowngrade, 1, 0), new Object[]{new String[]{"pup", "utu", "psp"}, Character.valueOf('p'), ORE_plateRubber, Character.valueOf('s'), ORE_stickRubber, Character.valueOf('u'), upgradeTemplate, Character.valueOf('t'), new ItemStack(Blocks.field_150425_aM)}));
    }

    private static void statusUpgradeRecipes() {
        if (!StorageDrawers.config.cache.enableIndicatorUpgrades) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeStatus, 1, 1), new Object[]{"twt", "wuw", "rwr", Character.valueOf('t'), new ItemStack(Blocks.field_150429_aA), Character.valueOf('w'), redAlloyWire, Character.valueOf('u'), upgradeTemplate, Character.valueOf('r'), ORE_plateRedstone}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeStatus, 1, 2), new Object[]{"gwg", "wuw", "rwr", Character.valueOf('g'), comparatorGate, Character.valueOf('w'), redAlloyWire, Character.valueOf('u'), upgradeTemplate, Character.valueOf('r'), ORE_plateRedstone}));
    }

    private static void redstoneUpgradeRecipes() {
        if (!StorageDrawers.config.cache.enableRedstoneUpgrades) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeRedstone, 1, 0), new Object[]{"rsr", "sus", "rwr", Character.valueOf('r'), ORE_plateRedstone, Character.valueOf('s'), ORE_stickWood, Character.valueOf('u'), upgradeTemplate, Character.valueOf('w'), redAlloyWire}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeRedstone, 1, 1), new Object[]{"rrr", "sus", "sws", Character.valueOf('r'), ORE_plateRedstone, Character.valueOf('s'), ORE_stickWood, Character.valueOf('u'), upgradeTemplate, Character.valueOf('w'), redAlloyWire}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeRedstone, 1, 2), new Object[]{"sws", "sus", "rrr", Character.valueOf('r'), ORE_plateRedstone, Character.valueOf('s'), ORE_stickWood, Character.valueOf('u'), upgradeTemplate, Character.valueOf('w'), redAlloyWire}));
    }

    private static void voidUpgradeRecipes() {
        if (!StorageDrawers.config.cache.enableVoidUpgrades) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeVoid), new Object[]{"sws", "ouo", "sws", Character.valueOf('s'), ORE_stickWood, Character.valueOf('w'), redAlloyWire, Character.valueOf('o'), ORE_plateDenseObsidian, Character.valueOf('u'), upgradeTemplate}));
    }

    private static void lockUpgradeRecipes() {
        if (!StorageDrawers.config.cache.enableLockUpgrades) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeLock), new Object[]{" bs", "uso", "gt ", Character.valueOf('b'), ORE_boltGold, Character.valueOf('s'), ORE_plateSteel, Character.valueOf('u'), upgradeTemplate, Character.valueOf('o'), ORE_stickGold, Character.valueOf('g'), ORE_plateGold, Character.valueOf('t'), ORE_craftingToolSaw}));
    }

    private static void shroudKeyUpgradeRecipes() {
        if (!StorageDrawers.config.cache.enableShroudUpgrades) {
            return;
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{upgradeLock, new ItemStack(Items.field_151061_bv)}).itemOutputs(new ItemStack[]{new ItemStack((Item)ModItems.shroudKey)}).duration(100).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }

    private static void personalKeyUpgradeRecipes() {
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return;
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{upgradeLock, new ItemStack(Items.field_151057_cb)}).itemOutputs(new ItemStack[]{new ItemStack((Item)ModItems.personalKey)}).duration(100).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }

    private static void packingTapeRecipes() {
        if (!StorageDrawers.config.cache.enableTape) {
            return;
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{new ItemStack(Items.field_151121_aF), integratedCircuit1}).fluidInputs(new FluidStack[]{FluidRegistry.getFluidStack((String)"glue", (int)144)}).itemOutputs(new ItemStack[]{new ItemStack((Item)ModItems.tape)}).duration(200).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{new ItemStack(Items.field_151121_aF), integratedCircuit1}).fluidInputs(new FluidStack[]{Materials.Glue.getFluid(144L)}).itemOutputs(new ItemStack[]{new ItemStack((Item)ModItems.tape)}).duration(200).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }

    private static ItemStack makeItemStack(String itemName, int meta, int stackSize, String nbtString) {
        ItemStack rStack = GameRegistry.makeItemStack((String)itemName, (int)meta, (int)stackSize, (String)nbtString);
        rStack.field_77994_a = stackSize;
        return rStack;
    }

    static {
        chest1 = new ItemStack((Block)Blocks.field_150486_ae, 1);
        chest2 = new ItemStack((Block)Blocks.field_150486_ae, 2);
        chest4 = new ItemStack((Block)Blocks.field_150486_ae, 4);
        chest5 = new ItemStack((Block)Blocks.field_150486_ae, 5);
        integratedCircuit1 = GTUtility.getIntegratedCircuit((int)1);
        integratedCircuit2 = GTUtility.getIntegratedCircuit((int)2);
        integratedCircuit4 = GTUtility.getIntegratedCircuit((int)4);
        integratedCircuit12 = GTUtility.getIntegratedCircuit((int)12);
        integratedCircuit14 = GTUtility.getIntegratedCircuit((int)14);
        carpentersBlock8 = GameRegistry.findItemStack((String)MOD_ID_CB, (String)NAME_blockCarpentersBlock, (int)8);
        carpentersBlock7 = GameRegistry.findItemStack((String)MOD_ID_CB, (String)NAME_blockCarpentersBlock, (int)7);
        carpentersBlock5 = GameRegistry.findItemStack((String)MOD_ID_CB, (String)NAME_blockCarpentersBlock, (int)5);
        carpentersBlock4 = GameRegistry.findItemStack((String)MOD_ID_CB, (String)NAME_blockCarpentersBlock, (int)4);
        carpentersBlock1 = GameRegistry.findItemStack((String)MOD_ID_CB, (String)NAME_blockCarpentersBlock, (int)1);
        stick4 = new ItemStack(Items.field_151055_y, 4);
        comparatorGate = ModRecipes.makeItemStack("ProjRed|Integration:projectred.integration.gate", 26, 1, null);
        redAlloyWire = ModRecipes.makeItemStack("ProjRed|Transmission:projectred.transmission.wire", 0, 1, null);
        upgradeLock = new ItemStack((Item)ModItems.upgradeLock);
        piston = new ItemStack((Block)Blocks.field_150331_J, 1);
        upgradeTemplate = new ItemStack(ModItems.upgradeTemplate);
        ImmutableList.Builder slabWoodRegistryNameListBuilder = new ImmutableList.Builder();
        ImmutableList.Builder slabWood8WListBuilder = new ImmutableList.Builder();
        ImmutableList.Builder slabWood7WListBuilder = new ImmutableList.Builder();
        ImmutableList.Builder slabWood5WListBuilder = new ImmutableList.Builder();
        ImmutableList.Builder slabWood4WListBuilder = new ImmutableList.Builder();
        for (ItemStack slabWood : OreDictionary.getOres((String)ORE_slabWood)) {
            slabWoodRegistryNameListBuilder.add((Object)GameRegistry.findUniqueIdentifierFor((Item)slabWood.func_77973_b()).toString());
        }
        for (String slabName : slabWoodRegistryNameListBuilder.build()) {
            slabWood8WListBuilder.add((Object)ModRecipes.makeItemStack(slabName, Short.MAX_VALUE, 8, null));
            slabWood7WListBuilder.add((Object)ModRecipes.makeItemStack(slabName, Short.MAX_VALUE, 7, null));
            slabWood5WListBuilder.add((Object)ModRecipes.makeItemStack(slabName, Short.MAX_VALUE, 5, null));
            slabWood4WListBuilder.add((Object)ModRecipes.makeItemStack(slabName, Short.MAX_VALUE, 4, null));
        }
        slabWood8WList = slabWood8WListBuilder.build();
        slabWood7WList = slabWood7WListBuilder.build();
        slabWood5WList = slabWood5WListBuilder.build();
        slabWood4WList = slabWood4WListBuilder.build();
        ImmutableList.Builder drawerBasic1RegistryNameListBuilder = new ImmutableList.Builder();
        ImmutableList.Builder drawerBasicRefs = new ImmutableList.Builder();
        for (ItemStack drawerBasicStack : OreDictionary.getOres((String)ORE_drawerBasic)) {
            GameRegistry.UniqueIdentifier drawerID = GameRegistry.findUniqueIdentifierFor((Item)drawerBasicStack.func_77973_b());
            if (!drawerID.name.matches("fullDrawers1.*")) continue;
            drawerBasicRefs.add((Object)drawerID.toString());
        }
        for (String drawerName : drawerBasicRefs.build()) {
            ItemStack drawerStack = ModRecipes.makeItemStack(drawerName, Short.MAX_VALUE, 1, null);
            if (!(drawerStack.func_77973_b() instanceof ItemDrawers)) continue;
            drawerBasic1RegistryNameListBuilder.add((Object)drawerStack);
        }
        drawerBasicW = drawerBasic1RegistryNameListBuilder.build();
    }
}

