/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.ae2;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IPriorityGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.ISmartGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ILockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class DrawerMEInventory
implements IMEInventory<IAEItemStack> {
    final IDrawerGroup group;

    public DrawerMEInventory(IDrawerGroup drawerGroup) {
        this.group = drawerGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
        IDrawer drawer;
        ItemStack itemProto;
        int slot;
        int i;
        long itemsLeft = input.getStackSize();
        if (this.group instanceof ISmartGroup) {
            ArrayList<IDrawer> clearSet = null;
            if (type == Actionable.SIMULATE) {
                clearSet = new ArrayList<IDrawer>();
            }
            try {
                for (int slot2 : ((ISmartGroup)((Object)this.group)).enumerateDrawersForInsertion(input.getItemStack(), false)) {
                    IDrawer drawer2 = this.group.getDrawer(slot2);
                    ItemStack itemProto2 = drawer2.getStoredItemPrototype();
                    if (itemProto2 == null) {
                        drawer2 = drawer2.setStoredItemRedir(input.getItemStack(), 0);
                        if (clearSet != null) {
                            clearSet.add(drawer2);
                        }
                    }
                    if (drawer2.canItemBeStored(input.getItemStack())) {
                        itemsLeft = this.injectItemsIntoDrawer(drawer2, itemsLeft, type);
                    }
                    if (drawer2 instanceof IVoidable && ((IVoidable)((Object)drawer2)).isVoid()) {
                        itemsLeft = 0L;
                    }
                    if (itemsLeft != 0L) continue;
                    IAEItemStack iAEItemStack = null;
                    return iAEItemStack;
                }
            }
            finally {
                if (clearSet != null) {
                    for (IDrawer drawer3 : clearSet) {
                        drawer3.setStoredItemRedir(null, 0);
                    }
                }
            }
        }
        int[] order = null;
        if (this.group instanceof IPriorityGroup) {
            order = ((IPriorityGroup)((Object)this.group)).getAccessibleDrawerSlots();
        }
        int n = this.group.getDrawerCount();
        for (i = 0; i < n; ++i) {
            int n2 = slot = order != null ? order[i] : i;
            if (!this.group.isDrawerEnabled(slot) || (itemProto = (drawer = this.group.getDrawer(slot)).getStoredItemPrototype()) == null || !drawer.canItemBeStored(input.getItemStack())) continue;
            itemsLeft = this.injectItemsIntoDrawer(drawer, itemsLeft, type);
            if (drawer instanceof IVoidable && ((IVoidable)((Object)drawer)).isVoid()) {
                itemsLeft = 0L;
            }
            if (itemsLeft != 0L) continue;
            return null;
        }
        n = this.group.getDrawerCount();
        for (i = 0; i < n; ++i) {
            int n3 = slot = order != null ? order[i] : i;
            if (!this.group.isDrawerEnabled(slot) || this.group instanceof ILockable && ((ILockable)((Object)this.group)).isLocked(LockAttribute.LOCK_EMPTY) || (itemProto = (drawer = this.group.getDrawer(slot)).getStoredItemPrototype()) == null && drawer instanceof ILockable && ((ILockable)((Object)drawer)).isLocked(LockAttribute.LOCK_EMPTY) || itemProto != null || !drawer.canItemBeStored(itemProto = input.getItemStack())) continue;
            drawer = drawer.setStoredItemRedir(itemProto, 0);
            itemsLeft = this.injectItemsIntoDrawer(drawer, itemsLeft, type);
            if (drawer instanceof IVoidable && ((IVoidable)((Object)drawer)).isVoid()) {
                itemsLeft = 0L;
            }
            if (itemsLeft != 0L) continue;
            return null;
        }
        if (itemsLeft > 0L) {
            IAEItemStack overflow = AEApi.instance().storage().createItemStack(input.getItemStack());
            overflow.setStackSize(itemsLeft);
            return overflow;
        }
        return input;
    }

    private long injectItemsIntoDrawer(IDrawer drawer, long itemCount, Actionable type) {
        IFractionalDrawer fracDrawer;
        int capacity = drawer.getMaxCapacity();
        int storedItems = drawer.getStoredItemCount();
        int storableItems = capacity - storedItems;
        if (drawer instanceof IFractionalDrawer && !(fracDrawer = (IFractionalDrawer)drawer).isSmallestUnit() && fracDrawer.getStoredItemRemainder() > 0) {
            --storableItems;
        }
        if (storableItems == 0) {
            return itemCount;
        }
        long remainder = Math.max(itemCount - (long)storableItems, 0L);
        storedItems = (int)((long)storedItems + Math.min(itemCount, (long)storableItems));
        if (type == Actionable.MODULATE) {
            drawer.setStoredItemCount(storedItems);
        }
        return remainder;
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        long itemsLeft = request.getStackSize();
        if (this.group instanceof ISmartGroup) {
            for (int slot : ((ISmartGroup)((Object)this.group)).enumerateDrawersForExtraction(request.getItemStack(), true)) {
                if (itemsLeft == 0L) break;
                IDrawer drawer = this.group.getDrawer(slot);
                int itemCount = drawer.getStoredItemCount();
                if (itemsLeft > (long)itemCount) {
                    if (mode == Actionable.MODULATE) {
                        drawer.setStoredItemCount(0);
                    }
                    itemsLeft -= (long)itemCount;
                    continue;
                }
                if (mode == Actionable.MODULATE) {
                    drawer.setStoredItemCount(itemCount - (int)itemsLeft);
                }
                itemsLeft = 0L;
                break;
            }
        } else {
            int[] order = null;
            if (this.group instanceof IPriorityGroup) {
                order = ((IPriorityGroup)((Object)this.group)).getAccessibleDrawerSlots();
            }
            int n = this.group.getDrawerCount();
            for (int i = 0; i < n; ++i) {
                IDrawer drawer;
                int slot;
                int n2 = slot = order != null ? order[i] : i;
                if (!this.group.isDrawerEnabled(slot) || !(drawer = this.group.getDrawer(slot)).canItemBeExtracted(request.getItemStack())) continue;
                int itemCount = drawer.getStoredItemCount();
                if (itemsLeft > (long)itemCount) {
                    if (mode == Actionable.MODULATE) {
                        drawer.setStoredItemCount(0);
                    }
                    itemsLeft -= (long)itemCount;
                    continue;
                }
                if (mode == Actionable.MODULATE) {
                    drawer.setStoredItemCount(itemCount - (int)itemsLeft);
                }
                itemsLeft = 0L;
                break;
            }
        }
        if (itemsLeft < request.getStackSize()) {
            ItemStack fulfillment = request.getItemStack().func_77946_l();
            fulfillment.field_77994_a = (int)((long)fulfillment.field_77994_a - itemsLeft);
            return AEApi.instance().storage().createItemStack(fulfillment);
        }
        return null;
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out, int iteration) {
        int[] order = null;
        if (this.group instanceof IPriorityGroup) {
            order = ((IPriorityGroup)((Object)this.group)).getAccessibleDrawerSlots();
        }
        int n = this.group.getDrawerCount();
        for (int i = 0; i < n; ++i) {
            IDrawer drawer;
            int slot;
            int n2 = slot = order != null ? order[i] : i;
            if (!this.group.isDrawerEnabled(slot) || (drawer = this.group.getDrawer(slot)).isEmpty()) continue;
            out.add((IAEStack)AEApi.instance().storage().createItemStack(drawer.getStoredItemCopy()));
        }
        return out;
    }

    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }
}

