/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.settings;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.compat.Compat;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.FileHelper;
import vswe.stevesfactory.network.PacketHandler;
import vswe.stevesfactory.settings.SettingsScreen;

public final class Settings {
    private static final String NAME = "StevesFactoryManagerInside";
    private static final int VERSION = 1;
    private static boolean autoCloseGroup;
    private static boolean largeOpenHitBox;
    private static boolean largeOpenHitBoxMenu;
    private static boolean quickGroupOpen;
    private static boolean commandTypes;
    private static boolean autoSide;
    private static boolean autoBlacklist;
    private static boolean enlargeInterfaces;
    private static boolean priorityMoveFirst;

    @SideOnly(value=Side.CLIENT)
    public static void openMenu(TileEntityManager manager) {
        manager.specialRenderer = new SettingsScreen(manager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void load() {
        DataReader dr = FileHelper.read(NAME);
        if (dr != null) {
            try {
                int version = dr.readByte();
                autoCloseGroup = dr.readBoolean();
                largeOpenHitBox = dr.readBoolean();
                largeOpenHitBoxMenu = dr.readBoolean();
                quickGroupOpen = dr.readBoolean();
                commandTypes = dr.readBoolean();
                autoSide = dr.readBoolean();
                autoBlacklist = dr.readBoolean();
                enlargeInterfaces = dr.readBoolean();
                if (version < 1) return;
                priorityMoveFirst = dr.readBoolean();
                return;
            }
            catch (Exception ignored) {
                Settings.loadDefault();
                return;
            }
            finally {
                dr.close();
            }
        } else {
            Settings.loadDefault();
        }
    }

    private static void loadDefault() {
        autoCloseGroup = false;
        largeOpenHitBox = Compat.HAS_ADDONS;
        largeOpenHitBoxMenu = Compat.HAS_ADDONS;
        quickGroupOpen = false;
        commandTypes = false;
        autoSide = Compat.HAS_ADDONS;
        autoBlacklist = Compat.HAS_ADDONS;
        enlargeInterfaces = false;
    }

    private static void save() {
        DataWriter dw = FileHelper.getWriter(NAME);
        if (dw != null) {
            dw.writeByte(1);
            dw.writeBoolean(autoCloseGroup);
            dw.writeBoolean(largeOpenHitBox);
            dw.writeBoolean(largeOpenHitBoxMenu);
            dw.writeBoolean(quickGroupOpen);
            dw.writeBoolean(commandTypes);
            dw.writeBoolean(autoSide);
            dw.writeBoolean(autoBlacklist);
            dw.writeBoolean(enlargeInterfaces);
            dw.writeBoolean(priorityMoveFirst);
            FileHelper.close(dw);
        }
    }

    public static boolean isAutoCloseGroup() {
        return autoCloseGroup;
    }

    public static void setAutoCloseGroup(boolean autoCloseGroup) {
        Settings.autoCloseGroup = autoCloseGroup;
        Settings.save();
    }

    public static boolean isLargeOpenHitBox() {
        return largeOpenHitBox;
    }

    public static void setLargeOpenHitBox(boolean largeOpenHitBox) {
        Settings.largeOpenHitBox = largeOpenHitBox;
        Settings.save();
    }

    public static boolean isLargeOpenHitBoxMenu() {
        return largeOpenHitBoxMenu;
    }

    public static void setLargeOpenHitBoxMenu(boolean largeOpenHitBoxMenu) {
        Settings.largeOpenHitBoxMenu = largeOpenHitBoxMenu;
        Settings.save();
    }

    public static boolean isQuickGroupOpen() {
        return quickGroupOpen;
    }

    public static void setQuickGroupOpen(boolean quickGroupOpen) {
        Settings.quickGroupOpen = quickGroupOpen;
        Settings.save();
    }

    public static boolean isCommandTypes() {
        return commandTypes;
    }

    public static void setCommandTypes(boolean commandTypes) {
        Settings.commandTypes = commandTypes;
        Settings.save();
    }

    public static boolean isAutoSide() {
        return autoSide;
    }

    public static void setAutoSide(boolean autoSide) {
        Settings.autoSide = autoSide;
        Settings.save();
    }

    public static boolean isAutoBlacklist() {
        return autoBlacklist;
    }

    public static void setAutoBlacklist(boolean autoBlacklist) {
        Settings.autoBlacklist = autoBlacklist;
        Settings.save();
    }

    public static boolean isLimitless(TileEntityManager manager) {
        return (manager.func_145831_w().func_72805_g(manager.field_145851_c, manager.field_145848_d, manager.field_145849_e) & 1) != 0;
    }

    public static void setLimitless(TileEntityManager manager, boolean limitless) {
        if (manager.func_145831_w().field_72995_K) {
            DataWriter dw = PacketHandler.getWriterForServerActionPacket();
            dw.writeBoolean(limitless);
            PacketHandler.sendDataToServer(dw);
        } else {
            int meta = manager.func_145831_w().func_72805_g(manager.field_145851_c, manager.field_145848_d, manager.field_145849_e);
            meta = limitless ? (meta |= 1) : (meta &= 0xFFFFFFFE);
            manager.func_145831_w().func_72921_c(manager.field_145851_c, manager.field_145848_d, manager.field_145849_e, meta, 3);
        }
    }

    public static boolean isEnlargeInterfaces() {
        return enlargeInterfaces;
    }

    public static void setEnlargeInterfaces(boolean enlargeInterfaces) {
        Settings.enlargeInterfaces = enlargeInterfaces;
        Settings.save();
    }

    public static boolean isPriorityMoveFirst() {
        return priorityMoveFirst;
    }

    public static void setPriorityMoveFirst(boolean priorityMoveFirst) {
        Settings.priorityMoveFirst = priorityMoveFirst;
    }

    private Settings() {
    }
}

