/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.TileEntities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import vswe.stevescarts.Containers.ContainerBase;
import vswe.stevescarts.Containers.ContainerDistributor;
import vswe.stevescarts.Helpers.DistributorSetting;
import vswe.stevescarts.Helpers.DistributorSide;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.Tank;
import vswe.stevescarts.Interfaces.GuiBase;
import vswe.stevescarts.Interfaces.GuiDistributor;
import vswe.stevescarts.PacketHandler;
import vswe.stevescarts.TileEntities.TileEntityBase;
import vswe.stevescarts.TileEntities.TileEntityCargo;
import vswe.stevescarts.TileEntities.TileEntityLiquid;
import vswe.stevescarts.TileEntities.TileEntityManager;

public class TileEntityDistributor
extends TileEntityBase
implements IInventory,
ISidedInventory,
IFluidHandler {
    private ArrayList<DistributorSide> sides = new ArrayList();
    private boolean dirty = true;
    private boolean dirty2 = true;
    private TileEntityManager[] inventories;
    public boolean hasTop;
    public boolean hasBot;

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiBase getGui(InventoryPlayer inv) {
        return new GuiDistributor(inv, this);
    }

    @Override
    public ContainerBase getContainer(InventoryPlayer inv) {
        return new ContainerDistributor((IInventory)inv, this);
    }

    public ArrayList<DistributorSide> getSides() {
        return this.sides;
    }

    public TileEntityDistributor() {
        this.sides.add(new DistributorSide(0, Localization.GUI.DISTRIBUTOR.SIDE_ORANGE, ForgeDirection.UP));
        this.sides.add(new DistributorSide(1, Localization.GUI.DISTRIBUTOR.SIDE_PURPLE, ForgeDirection.DOWN));
        this.sides.add(new DistributorSide(2, Localization.GUI.DISTRIBUTOR.SIDE_YELLOW, ForgeDirection.NORTH));
        this.sides.add(new DistributorSide(3, Localization.GUI.DISTRIBUTOR.SIDE_GREEN, ForgeDirection.WEST));
        this.sides.add(new DistributorSide(4, Localization.GUI.DISTRIBUTOR.SIDE_BLUE, ForgeDirection.SOUTH));
        this.sides.add(new DistributorSide(5, Localization.GUI.DISTRIBUTOR.SIDE_RED, ForgeDirection.EAST));
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        for (DistributorSide side : this.getSides()) {
            side.setData(nbttagcompound.func_74762_e("Side" + side.getId()));
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        for (DistributorSide side : this.getSides()) {
            nbttagcompound.func_74768_a("Side" + side.getId(), side.getData());
        }
    }

    public void func_145845_h() {
        this.dirty = true;
        this.dirty2 = true;
    }

    protected void sendPacket(int id) {
        this.sendPacket(id, new byte[0]);
    }

    protected void sendPacket(int id, byte data) {
        this.sendPacket(id, new byte[]{data});
    }

    public void sendPacket(int id, byte[] data) {
        PacketHandler.sendPacket(id, data);
    }

    @Override
    public void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0 || id == 1) {
            byte settingId = data[0];
            byte sideId = data[1];
            if (settingId >= 0 && settingId < DistributorSetting.settings.size() && sideId >= 0 && sideId < this.getSides().size()) {
                if (id == 0) {
                    this.getSides().get(sideId).set(settingId);
                } else {
                    this.getSides().get(sideId).reset(settingId);
                }
            }
        }
    }

    @Override
    public void initGuiData(Container con, ICrafting crafting) {
    }

    @Override
    public void checkGuiData(Container con, ICrafting crafting) {
        ContainerDistributor condist = (ContainerDistributor)con;
        for (int i = 0; i < this.getSides().size(); ++i) {
            DistributorSide side = this.getSides().get(i);
            if (side.getLowShortData() != condist.cachedValues.get(i * 2).shortValue()) {
                this.updateGuiData(con, crafting, i * 2, side.getLowShortData());
                condist.cachedValues.set(i * 2, side.getLowShortData());
            }
            if (side.getHighShortData() == condist.cachedValues.get(i * 2 + 1).shortValue()) continue;
            this.updateGuiData(con, crafting, i * 2 + 1, side.getHighShortData());
            condist.cachedValues.set(i * 2 + 1, side.getHighShortData());
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        int sideId = id / 2;
        boolean isHigh = id % 2 == 1;
        DistributorSide side = this.getSides().get(sideId);
        if (isHigh) {
            side.setHighShortData(data);
        } else {
            side.setLowShortData(data);
        }
    }

    public TileEntityManager[] getInventories() {
        if (this.dirty) {
            this.generateInventories();
            this.dirty = false;
        }
        return this.inventories;
    }

    private void generateInventories() {
        TileEntityManager bot = this.generateManager(-1);
        TileEntityManager top = this.generateManager(1);
        this.hasTop = top != null;
        this.hasBot = bot != null;
        this.inventories = this.populateManagers(top, bot, this.hasTop, this.hasBot);
    }

    private TileEntityManager[] populateManagers(TileEntityManager topElement, TileEntityManager botElement, boolean hasTopElement, boolean hasBotElement) {
        if (!hasTopElement && !hasBotElement) {
            return new TileEntityManager[0];
        }
        if (!hasBotElement) {
            return new TileEntityManager[]{topElement};
        }
        if (!hasTopElement) {
            return new TileEntityManager[]{botElement};
        }
        return new TileEntityManager[]{botElement, topElement};
    }

    private TileEntityManager generateManager(int y) {
        TileEntity TE = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + y, this.field_145849_e);
        if (TE != null && TE instanceof TileEntityManager) {
            return (TileEntityManager)TE;
        }
        return null;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    private int translateSlotId(int slot) {
        return slot % 60;
    }

    private TileEntityManager getManagerFromSlotId(int slot) {
        TileEntityManager[] invs = this.getInventories();
        int id = slot / 60;
        if (!this.hasTop || !this.hasBot) {
            id = 0;
        }
        if (id < 0 || id >= invs.length) {
            return null;
        }
        return invs[id];
    }

    public int func_70302_i_() {
        return 120;
    }

    public ItemStack func_70301_a(int slot) {
        TileEntityManager manager = this.getManagerFromSlotId(slot);
        if (manager != null) {
            return manager.func_70301_a(this.translateSlotId(slot));
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int count) {
        TileEntityManager manager = this.getManagerFromSlotId(slot);
        if (manager != null) {
            return manager.func_70298_a(this.translateSlotId(slot), count);
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        TileEntityManager manager = this.getManagerFromSlotId(slot);
        if (manager != null) {
            manager.func_70299_a(this.translateSlotId(slot), itemstack);
        }
    }

    public String func_145825_b() {
        return "container.cargodistributor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70305_f() {
    }

    public void func_70295_k_() {
    }

    public ItemStack func_70304_b(int slot) {
        TileEntityManager manager = this.getManagerFromSlotId(slot);
        if (manager != null) {
            return manager.func_70304_b(this.translateSlotId(slot));
        }
        return null;
    }

    private boolean isChunkValid(DistributorSide side, TileEntityManager manager, int chunkId, boolean top) {
        for (DistributorSetting setting : DistributorSetting.settings) {
            if (!setting.isEnabled(this) || !side.isSet(setting.getId()) || !setting.isValid(manager, chunkId, top)) continue;
            return true;
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        IFluidTank[] tanks = this.getTanks(from);
        int amount = 0;
        for (IFluidTank tank : tanks) {
            amount += tank.fill(resource, doFill);
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(from, null, maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource, resource == null ? 0 : resource.amount, doDrain);
    }

    private FluidStack drain(ForgeDirection from, FluidStack resource, int maxDrain, boolean doDrain) {
        IFluidTank[] tanks;
        FluidStack ret = resource;
        if (ret != null) {
            ret = ret.copy();
            ret.amount = 0;
        }
        for (IFluidTank tank : tanks = this.getTanks(from)) {
            FluidStack temp = null;
            temp = tank.drain(maxDrain, doDrain);
            if (temp == null || ret != null && !ret.isFluidEqual(temp)) continue;
            if (ret == null) {
                ret = temp;
            } else {
                ret.amount += temp.amount;
            }
            if ((maxDrain -= temp.amount) <= 0) break;
        }
        if (ret != null && ret.amount == 0) {
            return null;
        }
        return ret;
    }

    private IFluidTank[] getTanks(ForgeDirection direction) {
        TileEntityManager[] invs = this.getInventories();
        if (invs.length > 0) {
            for (DistributorSide side : this.getSides()) {
                if (side.getSide() != direction) continue;
                ArrayList<IFluidTank> tanks = new ArrayList<IFluidTank>();
                if (this.hasTop && this.hasBot) {
                    this.populateTanks(tanks, side, invs[0], false);
                    this.populateTanks(tanks, side, invs[1], true);
                } else if (this.hasTop) {
                    this.populateTanks(tanks, side, invs[0], true);
                } else if (this.hasBot) {
                    this.populateTanks(tanks, side, invs[0], false);
                }
                return tanks.toArray(new IFluidTank[tanks.size()]);
            }
        }
        return new IFluidTank[0];
    }

    private void populateTanks(ArrayList<IFluidTank> tanks, DistributorSide side, TileEntityManager manager, boolean top) {
        if (manager != null && manager instanceof TileEntityLiquid) {
            TileEntityLiquid fluid = (TileEntityLiquid)manager;
            Tank[] managerTanks = fluid.getTanks();
            for (int i = 0; i < 4; ++i) {
                if (!this.isChunkValid(side, manager, i, top) || tanks.contains(managerTanks[i])) continue;
                tanks.add(managerTanks[i]);
            }
        }
    }

    private void populateSlots(ArrayList<Integer> slotchunks, DistributorSide side, TileEntityManager manager, boolean top) {
        if (manager != null && manager instanceof TileEntityCargo) {
            for (int i = 0; i < 4; ++i) {
                int chunkid;
                if (!this.isChunkValid(side, manager, i, top) || slotchunks.contains(chunkid = i + (top ? 4 : 0))) continue;
                slotchunks.add(chunkid);
            }
        }
    }

    public int[] func_94128_d(int direction) {
        TileEntityManager[] invs = this.getInventories();
        if (invs.length > 0) {
            for (DistributorSide side : this.getSides()) {
                if (side.getIntSide() != direction) continue;
                ArrayList<Integer> slotchunks = new ArrayList<Integer>();
                if (this.hasTop && this.hasBot) {
                    this.populateSlots(slotchunks, side, invs[0], false);
                    this.populateSlots(slotchunks, side, invs[1], true);
                } else if (this.hasTop) {
                    this.populateSlots(slotchunks, side, invs[0], true);
                } else if (this.hasBot) {
                    this.populateSlots(slotchunks, side, invs[0], false);
                }
                int[] ret = new int[slotchunks.size() * 15];
                int id = 0;
                for (int chunkid : slotchunks) {
                    for (int i = 0; i < 15; ++i) {
                        ret[id] = chunkid * 15 + i;
                        ++id;
                    }
                }
                return ret;
            }
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return true;
    }

    public boolean func_94041_b(int slotId, ItemStack item) {
        return true;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        IFluidTank[] tanks = this.getTanks(from);
        FluidTankInfo[] infos = new FluidTankInfo[tanks.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FluidTankInfo(tanks[i].getFluid(), tanks[i].getCapacity());
        }
        return infos;
    }
}

