/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.components;

import appeng.api.networking.security.IActionHost;
import appeng.api.storage.data.IAEFluidStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import stevesaddons.helpers.AEHelper;
import stevesaddons.tileentities.TileEntityAENode;
import vswe.stevesfactory.components.StackTankHolder;

public class AEFluidBufferElement
extends StackTankHolder {
    private IAEFluidStack fluid;
    private TileEntityAENode node;
    private int sizeLeft;

    public AEFluidBufferElement(IAEFluidStack fluid, TileEntityAENode node) {
        super(null, null, null);
        this.fluid = fluid;
        this.node = node;
        this.sizeLeft = (int)fluid.getStackSize();
    }

    public FluidStack getFluidStack() {
        return this.fluid.getFluidStack();
    }

    public IFluidHandler getTank() {
        return this.node.getTank();
    }

    public ForgeDirection getSide() {
        return ForgeDirection.UNKNOWN;
    }

    public void reduceAmount(int val) {
        AEHelper.extract(this.node.getNode(), (IAEFluidStack)this.fluid.copy().setStackSize((long)val), (IActionHost)this.node);
    }

    public int getSizeLeft() {
        return (int)Math.min(this.fluid.getStackSize(), (long)this.sizeLeft);
    }

    public StackTankHolder getSplitElement(int elementAmount, int id, boolean fair) {
        int amountLeft;
        AEFluidBufferElement element = new AEFluidBufferElement(this.fluid, this.node);
        int oldAmount = this.getSizeLeft();
        int amount = oldAmount / elementAmount;
        if (!fair && id < (amountLeft = oldAmount % elementAmount)) {
            ++amount;
        }
        element.sizeLeft = amount;
        return element;
    }
}

