/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import squeek.applecore.api.food.FoodValues;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.ModSpiceOfLife;
import squeek.spiceoflife.helpers.FoodHelper;

public final class FoodLists {
    private static List<ItemStack> allFoods;

    public static void setUp() {
        if (ModConfig.DEV_LOGGING_ENABLED) {
            ModSpiceOfLife.Log.info("Starting populating food list.");
        }
        Stream<Item> stream = StreamSupport.stream(Item.field_150901_e.spliterator(), false);
        allFoods = stream.map(ItemStack::new).filter(FoodHelper::isFood).sorted(Comparator.comparing(ItemStack::func_82833_r)).collect(Collectors.toList());
        allFoods.forEach(i -> {
            FoodValues fv = FoodHelper.getFoodValues(i);
            if (ModConfig.DEV_LOGGING_ENABLED) {
                ModSpiceOfLife.Log.info(i.func_82833_r() + ", " + fv.hunger + ", " + fv.saturationModifier);
            }
        });
        if (ModConfig.DEV_LOGGING_ENABLED) {
            ModSpiceOfLife.Log.info("Done populating food list.");
        }
    }

    public static List<ItemStack> getAllFoods() {
        return new ArrayList<ItemStack>(allFoods);
    }
}

