/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.enderman;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.enderman.Entity_SpecialEnderman;

public class EntityCursedEnderman
extends Entity_SpecialEnderman {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "enderman/cursed.png"), new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "enderman/cursed_eyes.png")};

    public EntityCursedEnderman(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        ++this.field_70728_aV;
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 20.0);
    }

    @Override
    protected void onTypeAttack(Entity target) {
        if (target instanceof EntityLivingBase) {
            int time;
            switch (target.field_70170_p.field_73013_u) {
                case PEACEFUL: {
                    return;
                }
                case EASY: {
                    time = 20;
                    break;
                }
                case NORMAL: {
                    time = 50;
                    break;
                }
                default: {
                    time = 120;
                }
            }
            EffectHelper.stackEffect((EntityLivingBase)target, Potion.field_76437_t, time *= 20, 0, 4);
            EffectHelper.stackEffect((EntityLivingBase)target, Potion.field_76419_f, time, 0, 4);
        }
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            Item drop = null;
            switch (this.field_70146_Z.nextInt(5)) {
                case 0: {
                    drop = Items.field_151016_H;
                    break;
                }
                case 1: {
                    drop = Items.field_151102_aT;
                    break;
                }
                case 2: {
                    drop = Items.field_151070_bp;
                    break;
                }
                case 3: {
                    drop = Items.field_151071_bq;
                    break;
                }
                case 4: {
                    drop = Items.field_151060_bw;
                }
            }
            if (drop != null) {
                this.func_145779_a(drop, 1);
            }
        }
    }
}

