/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.data.ClaimedChunk;
import serverutils.data.ClaimedChunks;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.net.MessageToServer;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.MessageNavigatorUpdateKnown;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageNavigatorValidateKnown
extends MessageToServer {
    private LongSet knownPositions;

    public MessageNavigatorValidateKnown() {
    }

    public MessageNavigatorValidateKnown(LongSet knownPositions) {
        this.knownPositions = knownPositions;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.CLAIMS;
    }

    @Override
    public void writeData(DataOut data) {
        LongIterator longIterator = this.knownPositions.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            data.writeLong(pos);
        }
    }

    @Override
    public void readData(DataIn data) {
        this.knownPositions = new LongOpenHashSet();
        while (data.isReadable()) {
            this.knownPositions.add(data.readLong());
        }
    }

    @Override
    public void onMessage(EntityPlayerMP player) {
        if (this.knownPositions.isEmpty()) {
            return;
        }
        if (ClaimedChunks.isActive() && PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.journeymap.enable")) {
            LongOpenHashSet toRemove = new LongOpenHashSet();
            ChunkDimPos mut = new ChunkDimPos();
            LongIterator longIterator = this.knownPositions.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                ClaimedChunk chunk = ClaimedChunks.instance.getChunk(mut.set(pos, player.field_71093_bK));
                if (chunk != null) continue;
                toRemove.add(pos);
            }
            if (toRemove.isEmpty()) {
                return;
            }
            new MessageNavigatorUpdateKnown((LongSet)toRemove).sendTo(player);
        }
    }
}

