/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import serverutils.client.gui.ClientClaimedChunks;
import serverutils.data.ClaimedChunk;
import serverutils.data.ClaimedChunks;
import serverutils.integration.navigator.NavigatorIntegration;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.Universe;
import serverutils.lib.io.Bits;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageNavigatorUpdate
extends MessageToClient {
    public Short2ObjectMap<ClientClaimedChunks.Team> teams;

    public MessageNavigatorUpdate() {
    }

    public MessageNavigatorUpdate(int minX, int maxX, int minZ, int maxZ, EntityPlayer player) {
        ForgePlayer p = Universe.get().getPlayer((ICommandSender)player);
        boolean canSeeChunkInfo = PermissionAPI.hasPermission(player, "serverutilities.other_player.claims.see_info");
        boolean canSeeOtherJourneymap = PermissionAPI.hasPermission(player, "serverutilities.journeymap.other");
        this.teams = new Short2ObjectOpenHashMap();
        ChunkDimPos pos = new ChunkDimPos();
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                ForgeTeam chunkTeam;
                ClaimedChunk chunk = ClaimedChunks.instance.getChunk(pos.set(chunkX, chunkZ, player.field_71093_bK));
                if (chunk == null || !(chunkTeam = chunk.getTeam()).isValid() || !canSeeOtherJourneymap && !p.team.equalsTeam(chunkTeam)) continue;
                ClientClaimedChunks.Team team = (ClientClaimedChunks.Team)this.teams.get(chunkTeam.getUID());
                boolean member = chunkTeam.isMember(p);
                int flags = 0;
                if (team == null) {
                    team = new ClientClaimedChunks.Team(chunkTeam.getUID());
                    team.color = chunkTeam.getColor();
                    team.nameComponent = chunkTeam.getTitle();
                    team.isAlly = chunkTeam.isAlly(p);
                    team.isMember = member;
                    this.teams.put(chunkTeam.getUID(), (Object)team);
                }
                if ((canSeeChunkInfo || member) && chunk.isLoaded()) {
                    flags = Bits.setFlag(flags, 1, true);
                }
                team.chunkPos.put((Object)chunk.getPos(), (Object)new ClientClaimedChunks.ChunkData(team, flags));
            }
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.CLAIMS;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeCollection(this.teams.values(), ClientClaimedChunks.Team.SERIALIZER);
    }

    @Override
    public void readData(DataIn data) {
        this.teams = new Short2ObjectOpenHashMap();
        for (ClientClaimedChunks.Team team : data.readCollection(ClientClaimedChunks.Team.DESERIALIZER)) {
            this.teams.put(team.uid, (Object)team);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        NavigatorIntegration.updateMap(this);
    }
}

