/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import serverutils.ServerUtilitiesCommon;
import serverutils.lib.data.Action;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.gui.misc.GuiActionList;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.net.MessageMyTeamAction;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageMyTeamGuiResponse
extends MessageToClient {
    private IChatComponent title;
    private Collection<Action.Inst> actions;

    public MessageMyTeamGuiResponse() {
    }

    public MessageMyTeamGuiResponse(ForgePlayer player) {
        this.title = player.team.getTitle();
        this.actions = new ArrayList<Action.Inst>();
        NBTTagCompound emptyData = new NBTTagCompound();
        for (Action action : ServerUtilitiesCommon.TEAM_GUI_ACTIONS.values()) {
            Action.Type type = action.getType(player, emptyData);
            if (!type.isVisible()) continue;
            this.actions.add(new Action.Inst(action, type));
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.MY_TEAM;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeTextComponent(this.title);
        data.writeCollection(this.actions, Action.Inst.SERIALIZER);
    }

    @Override
    public void readData(DataIn data) {
        this.title = data.readTextComponent();
        this.actions = data.readCollection(Action.Inst.DESERIALIZER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new GuiActionList(this.title.func_150254_d(), this.actions, id -> new MessageMyTeamAction((ResourceLocation)id, new NBTTagCompound()).sendToServer()).openGui();
    }
}

