/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.icon;

import com.google.common.base.Objects;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import serverutils.lib.client.IPixelBuffer;
import serverutils.lib.client.PixelBuffer;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.icon.Color4I;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.IconProperties;

public class ImageIcon
extends Icon {
    public static final ResourceLocation MISSING_IMAGE = new ResourceLocation("serverutilities", "textures/gui/missing_image.png");
    public final ResourceLocation texture;
    public double minU;
    public double minV;
    public double maxU;
    public double maxV;
    public double tileSize;
    public Color4I color;

    public ImageIcon(ResourceLocation tex) {
        this.texture = tex;
        this.minU = 0.0;
        this.minV = 0.0;
        this.maxU = 1.0;
        this.maxV = 1.0;
        this.tileSize = 0.0;
        this.color = Color4I.WHITE;
    }

    @Override
    public ImageIcon copy() {
        ImageIcon icon = new ImageIcon(this.texture);
        icon.minU = this.minU;
        icon.minV = this.minV;
        icon.maxU = this.maxU;
        icon.maxV = this.maxV;
        icon.tileSize = this.tileSize;
        return icon;
    }

    @Override
    protected void setProperties(IconProperties properties) {
        super.setProperties(properties);
        this.minU = properties.getDouble("u0", this.minU);
        this.minV = properties.getDouble("v0", this.minV);
        this.maxU = properties.getDouble("u1", this.maxU);
        this.maxV = properties.getDouble("v1", this.maxV);
        this.tileSize = properties.getDouble("tile_size", this.tileSize);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTexture() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h) {
        this.bindTexture();
        if (this.tileSize <= 0.0) {
            GuiHelper.drawTexturedRect(x, y, w, h, this.color, this.minU, this.minV, this.maxU, this.maxV);
        } else {
            int r = this.color.redi();
            int g = this.color.greeni();
            int b = this.color.bluei();
            int a = this.color.alphai();
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78370_a(r, g, b, a);
            tessellator.func_78385_a((double)x / this.tileSize, (double)(y + h) / this.tileSize);
            tessellator.func_78377_a((double)x, (double)(y + h), 0.0);
            tessellator.func_78370_a(r, g, b, a);
            tessellator.func_78385_a((double)(x + w) / this.tileSize, (double)(y + h) / this.tileSize);
            tessellator.func_78377_a((double)(x + w), (double)(y + h), 0.0);
            tessellator.func_78370_a(r, g, b, a);
            tessellator.func_78385_a((double)(x + w) / this.tileSize, (double)y / this.tileSize);
            tessellator.func_78377_a((double)(x + w), (double)y, 0.0);
            tessellator.func_78370_a(r, g, b, a);
            tessellator.func_78385_a((double)x / this.tileSize, (double)y / this.tileSize);
            tessellator.func_78377_a((double)x, (double)y, 0.0);
            tessellator.func_78381_a();
        }
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.texture, this.minU, this.minV, this.maxU, this.maxV});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImageIcon) {
            ImageIcon img = (ImageIcon)o;
            return this.texture.equals((Object)img.texture) && this.minU == img.minU && this.minV == img.minV && this.maxU == img.maxU && this.maxV == img.maxV;
        }
        return false;
    }

    public String toString() {
        return this.texture.toString();
    }

    @Override
    public ImageIcon withColor(Color4I color) {
        ImageIcon icon = this.copy();
        icon.color = color;
        return icon;
    }

    @Override
    public ImageIcon withTint(Color4I c) {
        return this.withColor(this.color.withTint(c));
    }

    @Override
    public ImageIcon withUV(double u0, double v0, double u1, double v1) {
        ImageIcon icon = this.copy();
        icon.minU = u0;
        icon.minV = v0;
        icon.maxU = u1;
        icon.maxV = v1;
        return icon;
    }

    @Override
    public boolean hasPixelBuffer() {
        return true;
    }

    @Override
    @Nullable
    public IPixelBuffer createPixelBuffer() {
        try {
            return PixelBuffer.from(Minecraft.func_71410_x().func_110442_L().func_110536_a(this.texture).func_110527_b());
        }
        catch (Exception ex) {
            return null;
        }
    }
}

