/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import serverutils.lib.config.ConfigNull;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.IRankConfigHandler;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.config.RankConfigValueInfo;
import serverutils.lib.util.ServerUtils;

public enum DefaultRankConfigHandler implements IRankConfigHandler
{
    INSTANCE;

    private static final Map<String, RankConfigValueInfo> MAP;
    private static Collection<RankConfigValueInfo> VALUES;

    @Override
    public void registerRankConfig(RankConfigValueInfo info) {
        Preconditions.checkNotNull((Object)info, (Object)"RankConfigValueInfo can't be null!");
        Preconditions.checkArgument((!MAP.containsKey(info.node) ? 1 : 0) != 0, (Object)("Duplicate rank config ID found: " + info.node));
        MAP.put(info.node, info);
    }

    @Override
    public Collection<RankConfigValueInfo> getRegisteredConfigs() {
        return VALUES;
    }

    @Override
    public ConfigValue getConfigValue(MinecraftServer server, GameProfile profile, String node) {
        RankConfigValueInfo info = RankConfigAPI.getHandler().getInfo(node);
        if (info != null) {
            return ServerUtils.isOP(server, profile) ? info.defaultOPValue : info.defaultValue;
        }
        return ConfigNull.INSTANCE;
    }

    @Override
    @Nullable
    public RankConfigValueInfo getInfo(String node) {
        Preconditions.checkNotNull((Object)node, (Object)"Config node can't be null!");
        return MAP.get(node);
    }

    static {
        MAP = new HashMap<String, RankConfigValueInfo>();
        VALUES = Collections.unmodifiableCollection(MAP.values());
    }
}

