/*
 * Decompiled with CFR 0.152.
 */
package serverutils.aurora.mc;

import cpw.mods.fml.common.ModContainer;
import serverutils.aurora.AuroraConfig;
import serverutils.aurora.PageType;
import serverutils.aurora.page.HTTPWebPage;
import serverutils.aurora.tag.Tag;

public class ModPage
extends HTTPWebPage {
    private final ModContainer mod;

    public ModPage(ModContainer m) {
        this.mod = m;
    }

    @Override
    public String getTitle() {
        return "Minecraft";
    }

    @Override
    public String getDescription() {
        return "Mod List";
    }

    @Override
    public PageType getPageType() {
        return AuroraConfig.pages.modlist_page;
    }

    @Override
    public void body(Tag body) {
        body.h1(this.mod.getName()).text(" ").span(this.mod.getDisplayVersion(), "other");
        body.h3("Mod ID: ").span(this.mod.getModId());
        if (!this.mod.getMetadata().description.isEmpty()) {
            body.h3("").paired("i", this.mod.getMetadata().description);
        }
        if (!this.mod.getMetadata().url.isEmpty()) {
            body.h3("").a(this.mod.getMetadata().url, this.mod.getMetadata().url);
        }
        if (!this.mod.getMetadata().authorList.isEmpty()) {
            if (this.mod.getMetadata().authorList.size() == 1) {
                body.h3("Author: ").span((String)this.mod.getMetadata().authorList.get(0), "other");
            } else {
                body.h3("Authors:").style("margin-bottom", "0");
                Tag ul = body.ul().style("margin-top", "0");
                for (String s : this.mod.getMetadata().authorList) {
                    ul.li().paired("h4").style("margin", "0").span(s, "other");
                }
            }
        }
        if (!this.mod.getMetadata().credits.isEmpty()) {
            body.h3("").paired("i", this.mod.getMetadata().credits);
        }
    }
}

