/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.proxy;

import com.github.lunatrius.schematica.command.CommandSchematicaDownload;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.handler.PlayerHandler;
import com.github.lunatrius.schematica.proxy.CommonProxy;
import com.github.lunatrius.schematica.reference.Reference;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;

public class ServerProxy
extends CommonProxy {
    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        FMLCommonHandler.instance().bus().register((Object)PlayerHandler.INSTANCE);
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        super.serverStarting(event);
        if (ConfigurationHandler.serversideSchematicsEnabled) {
            event.registerServerCommand((ICommand)new CommandSchematicaDownload());
        }
    }

    @Override
    public File getDataDirectory() {
        File file = MinecraftServer.func_71276_C().func_71209_f(".");
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            Reference.logger.info("Could not canonize path!", (Throwable)e);
            return file;
        }
    }

    @Override
    public boolean loadSchematic(EntityPlayer player, File directory, String filename) {
        return false;
    }

    @Override
    public boolean isPlayerQuotaExceeded(EntityPlayer player) {
        int spaceUsed = 0;
        File schematicDirectory = this.getPlayerSchematicDirectory(player, true);
        spaceUsed += this.getSpaceUsedByDirectory(schematicDirectory);
        schematicDirectory = this.getPlayerSchematicDirectory(player, false);
        return (spaceUsed += this.getSpaceUsedByDirectory(schematicDirectory)) / 1024 > ConfigurationHandler.playerQuotaKilobytes;
    }

    private int getSpaceUsedByDirectory(File directory) {
        int spaceUsed = 0;
        if (directory == null || !directory.exists()) {
            return 0;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        for (File path : files) {
            spaceUsed = (int)((long)spaceUsed + path.length());
        }
        return spaceUsed;
    }

    @Override
    public File getPlayerSchematicDirectory(EntityPlayer player, boolean privateDirectory) {
        UUID playerId = player.func_110124_au();
        if (playerId == null) {
            Reference.logger.warn("Unable to identify player {}", new Object[]{player.toString()});
            return null;
        }
        File playerDir = new File(ConfigurationHandler.schematicDirectory.getAbsolutePath(), playerId.toString());
        if (privateDirectory) {
            return new File(playerDir, "private");
        }
        return new File(playerDir, "public");
    }
}

