/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.proxy;

import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.command.CommandSchematicaList;
import com.github.lunatrius.schematica.command.CommandSchematicaRemove;
import com.github.lunatrius.schematica.command.CommandSchematicaSave;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.handler.DownloadHandler;
import com.github.lunatrius.schematica.handler.QueueTickHandler;
import com.github.lunatrius.schematica.nbt.ForgeMultipart;
import com.github.lunatrius.schematica.nbt.NBTConversionException;
import com.github.lunatrius.schematica.nbt.NBTHelper;
import com.github.lunatrius.schematica.network.PacketHandler;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.chunk.SchematicContainer;
import com.github.lunatrius.schematica.world.schematic.SchematicUtil;
import com.github.lunatrius.schematica.world.storage.Schematic;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class CommonProxy {
    public boolean isSaveEnabled = true;
    public boolean isLoadEnabled = true;
    public boolean GTNH = false;

    public void preInit(FMLPreInitializationEvent event) {
        this.GTNH = Loader.isModLoaded((String)"dreamcraft");
        Reference.logger = event.getModLog();
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
    }

    public void init(FMLInitializationEvent event) {
        PacketHandler.init();
        FMLCommonHandler.instance().bus().register((Object)QueueTickHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)DownloadHandler.INSTANCE);
    }

    public void postInit(FMLPostInitializationEvent event) {
        ForgeMultipart.init();
    }

    public void serverStarting(FMLServerStartingEvent event) {
        if (ConfigurationHandler.serversideSchematicsEnabled) {
            event.registerServerCommand((ICommand)new CommandSchematicaSave());
            event.registerServerCommand((ICommand)new CommandSchematicaList());
            event.registerServerCommand((ICommand)new CommandSchematicaRemove());
        }
    }

    public void createFolders() {
        if (!ConfigurationHandler.schematicDirectory.exists() && !ConfigurationHandler.schematicDirectory.mkdirs()) {
            Reference.logger.warn("Could not create schematic directory [{}]!", new Object[]{ConfigurationHandler.schematicDirectory.getAbsolutePath()});
        }
    }

    public abstract File getDataDirectory();

    public File getDirectory(String directory) {
        File dataDirectory = this.getDataDirectory();
        File subDirectory = new File(dataDirectory, directory);
        if (!subDirectory.exists() && !subDirectory.mkdirs()) {
            Reference.logger.error("Could not create directory [{}]!", new Object[]{subDirectory.getAbsolutePath()});
        }
        try {
            return subDirectory.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return subDirectory;
        }
    }

    public void resetSettings() {
        this.isSaveEnabled = true;
        this.isLoadEnabled = true;
    }

    public void unloadSchematic() {
    }

    public void copyChunkToSchematic(ISchematic schematic, World world, int chunkX, int chunkZ, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        int localMinX = minX < chunkX << 4 ? 0 : minX & 0xF;
        int localMaxX = maxX > (chunkX << 4) + 15 ? 15 : maxX & 0xF;
        int localMinZ = minZ < chunkZ << 4 ? 0 : minZ & 0xF;
        int localMaxZ = maxZ > (chunkZ << 4) + 15 ? 15 : maxZ & 0xF;
        for (int chunkLocalX = localMinX; chunkLocalX <= localMaxX; ++chunkLocalX) {
            for (int chunkLocalZ = localMinZ; chunkLocalZ <= localMaxZ; ++chunkLocalZ) {
                for (int y = minY; y <= maxY; ++y) {
                    int x = chunkLocalX | chunkX << 4;
                    int z = chunkLocalZ | chunkZ << 4;
                    int localX = x - minX;
                    int localY = y - minY;
                    int localZ = z - minZ;
                    try {
                        TileEntity tileEntity;
                        Block block = world.func_147439_a(x, y, z);
                        int metadata = world.func_72805_g(x, y, z);
                        boolean success = schematic.setBlock(localX, localY, localZ, block, metadata);
                        if (!success || !block.hasTileEntity(metadata) || (tileEntity = world.func_147438_o(x, y, z)) == null) continue;
                        try {
                            TileEntity reloadedTileEntity = NBTHelper.reloadTileEntity(tileEntity, minX, minY, minZ);
                            schematic.setTileEntity(localX, localY, localZ, reloadedTileEntity);
                        }
                        catch (NBTConversionException nce) {
                            Reference.logger.error("Error while trying to save tile entity '{}'!", new Object[]{tileEntity, nce});
                            schematic.setBlock(localX, localY, localZ, Blocks.field_150357_h);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        Reference.logger.error("Something went wrong!", (Throwable)e);
                    }
                }
            }
        }
        int minX1 = localMinX | chunkX << 4;
        int minZ1 = localMinZ | chunkZ << 4;
        int maxX1 = localMaxX | chunkX << 4;
        int maxZ1 = localMaxZ | chunkZ << 4;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)minX1, (double)minY, (double)minZ1, (double)(maxX1 + 1), (double)(maxY + 1), (double)(maxZ1 + 1));
        List entities = world.func_72872_a(Entity.class, bb);
        for (Entity entity : entities) {
            try {
                Entity reloadedEntity = NBTHelper.reloadEntity(entity, minX, minY, minZ);
                schematic.addEntity(reloadedEntity);
            }
            catch (NBTConversionException nce) {
                Reference.logger.error("Error while trying to save entity '{}'!", new Object[]{entity, nce});
            }
        }
    }

    public boolean saveSchematic(EntityPlayer player, File directory, String filename, World world, Vector3i from, Vector3i to) {
        try {
            String iconName = "";
            try {
                String[] parts = filename.split(";");
                if (parts.length == 2) {
                    iconName = parts[0];
                    filename = parts[1];
                }
            }
            catch (Exception e) {
                Reference.logger.error("Failed to parse icon data!", (Throwable)e);
            }
            int minX = Math.min(from.x, to.x);
            int maxX = Math.max(from.x, to.x);
            int minY = Math.min(from.y, to.y);
            int maxY = Math.max(from.y, to.y);
            int minZ = Math.min(from.z, to.z);
            int maxZ = Math.max(from.z, to.z);
            short width = (short)(Math.abs(maxX - minX) + 1);
            short height = (short)(Math.abs(maxY - minY) + 1);
            short length = (short)(Math.abs(maxZ - minZ) + 1);
            Schematic schematic = new Schematic(SchematicUtil.getIconFromName(iconName), width, height, length);
            SchematicContainer container = new SchematicContainer(schematic, player, world, new File(directory, filename), minX, maxX, minY, maxY, minZ, maxZ);
            QueueTickHandler.INSTANCE.queueSchematic(container);
            return true;
        }
        catch (Exception e) {
            Reference.logger.error("Failed to save schematic!", (Throwable)e);
            return false;
        }
    }

    public abstract boolean loadSchematic(EntityPlayer var1, File var2, String var3);

    public abstract boolean isPlayerQuotaExceeded(EntityPlayer var1);

    public abstract File getPlayerSchematicDirectory(EntityPlayer var1, boolean var2);
}

