/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.command;

import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.command.CommandSchematicaBase;
import com.github.lunatrius.schematica.reference.Reference;
import java.io.File;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class CommandSchematicaSave
extends CommandSchematicaBase {
    public String func_71517_b() {
        return "schematicaSave";
    }

    public String func_71518_a(ICommandSender sender) {
        return "schematica.command.save.usage";
    }

    public void func_71515_b(ICommandSender sender, String[] arguments) {
        String filename;
        String name;
        if (arguments.length < 7) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("schematica.command.save.playersOnly", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        if (Schematica.proxy.isPlayerQuotaExceeded(player)) {
            throw new CommandException("schematica.command.save.quotaExceeded", new Object[0]);
        }
        Vector3i from = new Vector3i();
        Vector3i to = new Vector3i();
        try {
            from.set(Integer.parseInt(arguments[0]), Integer.parseInt(arguments[1]), Integer.parseInt(arguments[2]));
            to.set(Integer.parseInt(arguments[3]), Integer.parseInt(arguments[4]), Integer.parseInt(arguments[5]));
            name = arguments[6];
            filename = String.format("%s.schematic", name);
        }
        catch (NumberFormatException exception) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        Reference.logger.debug("Saving schematic from {} to {} to {}", new Object[]{from, to, filename});
        File schematicDirectory = Schematica.proxy.getPlayerSchematicDirectory(player, true);
        if (schematicDirectory == null) {
            Reference.logger.warn("Unable to determine the schematic directory for player {}", new Object[]{player});
            throw new CommandException("schematica.command.save.playerSchematicDirUnavailable", new Object[0]);
        }
        if (!schematicDirectory.exists() && !schematicDirectory.mkdirs()) {
            Reference.logger.warn("Could not create player schematic directory {}", new Object[]{schematicDirectory.getAbsolutePath()});
            throw new CommandException("schematica.command.save.playerSchematicDirUnavailable", new Object[0]);
        }
        try {
            Schematica.proxy.saveSchematic(player, schematicDirectory, filename, player.func_130014_f_(), from, to);
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("schematica.command.save.saveSucceeded", new Object[]{name}));
        }
        catch (Exception e) {
            throw new CommandException("schematica.command.save.saveFailed", new Object[]{name});
        }
    }
}

