/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.VillagerRegistry;
import gcewing.sg.BaseMod;
import gcewing.sg.BaseSubsystem;
import gcewing.sg.SGCraft;
import gcewing.sg.blocks.base.BaseBlock;
import gcewing.sg.interfaces.IBlock;
import gcewing.sg.interfaces.IBlockState;
import gcewing.sg.interfaces.ICustomRenderer;
import gcewing.sg.interfaces.IItem;
import gcewing.sg.interfaces.IModel;
import gcewing.sg.interfaces.IRenderTarget;
import gcewing.sg.interfaces.ITexture;
import gcewing.sg.interfaces.ITextureConsumer;
import gcewing.sg.renderers.BaseGLRenderTarget;
import gcewing.sg.renderers.BaseModelRenderer;
import gcewing.sg.renderers.BaseWorldRenderTarget;
import gcewing.sg.textures.BaseTexture;
import gcewing.sg.textures.Sprite;
import gcewing.sg.utils.BaseBlockUtils;
import gcewing.sg.utils.EnumWorldBlockLayer;
import gcewing.sg.utils.ModelSpec;
import gcewing.sg.utils.TextureCache;
import gcewing.sg.utils.Trans3;
import gcewing.sg.utils.VSBinding;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.joml.Vector3i;
import org.lwjgl.opengl.GL11;

public class BaseModClient<MOD extends BaseMod<? extends BaseModClient>>
implements IGuiHandler {
    public boolean debugModelRegistration = false;
    MOD base;
    boolean customRenderingRequired;
    Map<Integer, Class<? extends GuiScreen>> screenClasses = new HashMap<Integer, Class<? extends GuiScreen>>();
    protected Map<IBlock, ICustomRenderer> blockRenderers = new HashMap<IBlock, ICustomRenderer>();
    protected Map<Item, ICustomRenderer> itemRenderers = new HashMap<Item, ICustomRenderer>();
    protected Map<IBlockState, ICustomRenderer> stateRendererCache = new HashMap<IBlockState, ICustomRenderer>();
    protected TextureCache[] textureCaches = new TextureCache[2];
    public static EnumWorldBlockLayer[][] passLayers = new EnumWorldBlockLayer[][]{{EnumWorldBlockLayer.SOLID, EnumWorldBlockLayer.CUTOUT_MIPPED, EnumWorldBlockLayer.CUTOUT, EnumWorldBlockLayer.TRANSLUCENT}, {EnumWorldBlockLayer.SOLID, EnumWorldBlockLayer.CUTOUT_MIPPED, EnumWorldBlockLayer.CUTOUT}, {EnumWorldBlockLayer.TRANSLUCENT}};
    protected BlockRenderDispatcher blockRenderDispatcher;
    public static boolean debugRenderBlock = false;
    public static boolean debugRenderItem = false;
    protected ItemRenderDispatcher itemRenderDispatcher;
    protected static BaseGLRenderTarget glTarget = new BaseGLRenderTarget();
    protected static Trans3 entityTrans = Trans3.blockCenter;
    protected static Trans3 equippedTrans = Trans3.blockCenter;
    protected static Trans3 firstPersonTrans = Trans3.blockCenterSideTurn(0, 3);
    protected static Trans3 inventoryTrans = Trans3.blockCenter;

    public BaseModClient(MOD mod) {
        for (int i = 0; i < 2; ++i) {
            this.textureCaches[i] = new TextureCache();
        }
        this.base = mod;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void preInit(FMLPreInitializationEvent e) {
        this.registerSavedVillagerSkins();
        for (BaseSubsystem sub : ((BaseMod)this.base).subsystems) {
            sub.registerBlockRenderers();
            sub.registerItemRenderers();
        }
        this.registerDefaultRenderers();
        this.removeUnusedDefaultTextureNames();
    }

    public void init(FMLInitializationEvent e) {
    }

    public void postInit(FMLPostInitializationEvent e) {
        for (BaseSubsystem sub : ((BaseMod)this.base).subsystems) {
            sub.registerModelLocations();
            sub.registerTileEntityRenderers();
            sub.registerEntityRenderers();
            sub.registerScreens();
            sub.registerOtherClient();
        }
    }

    void registerSavedVillagerSkins() {
        VillagerRegistry reg = VillagerRegistry.instance();
        for (VSBinding b : ((BaseMod)this.base).registeredVillagers) {
            reg.registerVillagerSkin(b.id, (ResourceLocation)b.object);
        }
    }

    void registerOther() {
    }

    void registerScreens() {
    }

    public void addScreen(Enum id, Class<? extends GuiScreen> cls) {
        this.addScreen(id.ordinal(), cls);
    }

    public void addScreen(int id, Class<? extends GuiScreen> cls) {
        if (this.screenClasses.containsKey(id)) {
            throw new RuntimeException("Duplicate screen registration with ID " + id);
        }
        this.screenClasses.put(id, cls);
    }

    protected void registerBlockRenderers() {
    }

    protected void registerItemRenderers() {
    }

    protected void registerEntityRenderers() {
    }

    protected void registerTileEntityRenderers() {
    }

    public void addTileEntityRenderer(Class<? extends TileEntity> teClass, TileEntitySpecialRenderer renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(teClass, (TileEntitySpecialRenderer)renderer);
    }

    public void addEntityRenderer(Class<? extends Entity> entityClass, Render renderer) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, (Render)renderer);
    }

    public void addEntityRenderer(Class<? extends Entity> entityClass, Class<? extends Render> rendererClass) {
        Render renderer;
        try {
            renderer = rendererClass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        this.addEntityRenderer(entityClass, renderer);
    }

    protected void registerDefaultRenderers() {
        for (Block block : ((BaseMod)this.base).registeredBlocks) {
            Item item = Item.func_150898_a((Block)block);
            if (block instanceof IBlock) {
                if (this.debugModelRegistration) {
                    SGCraft.log.debug(String.format("BaseModClient.registerDefaultRenderers: %s %s", block, block.func_149739_a()));
                }
                if (!this.blockRenderers.containsKey(block) && ((IBlock)block).getCustomRenderer() != null) {
                    this.addBlockRenderer((IBlock)block, ((IBlock)block).getCustomRenderer());
                }
                if (this.blockNeedsCustomRendering(block)) {
                    this.installCustomBlockRenderDispatcher((IBlock)block);
                    this.installCustomItemRenderDispatcher(item);
                }
            }
            if (!this.itemNeedsCustomRendering(item)) continue;
            this.installCustomItemRenderDispatcher(item);
        }
        for (Item item : ((BaseMod)this.base).registeredItems) {
            if (this.debugModelRegistration) {
                SGCraft.log.debug(String.format("BaseModClient.registerDefaultRenderers: %s %s", item, item.func_77658_a()));
            }
            if (!this.itemNeedsCustomRendering(item)) continue;
            this.installCustomItemRenderDispatcher(item);
        }
    }

    protected void installCustomBlockRenderDispatcher(IBlock block) {
        if (this.debugModelRegistration) {
            SGCraft.log.debug(String.format("BaseModClient.installCustomBlockRenderDisatcher: %s", block));
        }
        block.setRenderType(this.getCustomBlockRenderType());
    }

    protected void installCustomItemRenderDispatcher(Item item) {
        if (item == null) {
            return;
        }
        if (this.debugModelRegistration) {
            SGCraft.log.debug(String.format("BaseModClient.installCustomItemRenderDispatcher: %s", item));
        }
        MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)this.getItemRenderDispatcher());
    }

    protected void removeUnusedDefaultTextureNames() {
        for (Block block : ((BaseMod)this.base).registeredBlocks) {
            if (!this.blockNeedsCustomRendering(block)) continue;
            if (this.debugModelRegistration) {
                SGCraft.log.debug(String.format("BaseModClient: Removing default texture from block %s", block.func_149739_a()));
            }
            block.func_149658_d("minecraft:stone");
        }
        for (Item item : ((BaseMod)this.base).registeredItems) {
            if (!this.itemNeedsCustomRendering(item)) continue;
            if (this.debugModelRegistration) {
                SGCraft.log.debug(String.format("BaseModClient: Removing default texture from item %s", item.func_77658_a()));
            }
            item.func_111206_d("minecraft:apple");
        }
    }

    public ResourceLocation textureLocation(String path) {
        return ((BaseMod)this.base).resourceLocation("textures/" + path);
    }

    public static void bindTexture(ResourceLocation rsrc) {
        TextureManager tm = Minecraft.func_71410_x().func_110434_K();
        tm.func_110577_a(rsrc);
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return ((BaseMod)this.base).getServerGuiElement(id, player, world, x, y, z);
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return this.getClientGuiElement(id, player, world, new Vector3i(x, y, z));
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, Vector3i pos) {
        Class<? extends GuiScreen> scrnCls;
        int param = id >> 16;
        id &= 0xFFFF;
        Object result = null;
        if (((BaseMod)this.base).debugGui) {
            SGCraft.log.debug(String.format("BaseModClient.getClientGuiElement: for id %s", id));
        }
        if ((scrnCls = this.screenClasses.get(id)) != null) {
            block14: {
                Class<? extends Container> contCls;
                if (((BaseMod)this.base).debugGui) {
                    SGCraft.log.debug(String.format("BaseModClient.getClientGuiElement: Instantiating %s", scrnCls));
                }
                if ((contCls = ((BaseMod)this.base).containerClasses.get(id)) != null) {
                    try {
                        Object cont;
                        if (((BaseMod)this.base).debugGui) {
                            SGCraft.log.debug(String.format("BaseModClient.getClientGuiElement: Looking for constructor taking %s", contCls));
                        }
                        Constructor<? extends GuiScreen> ctor = scrnCls.getConstructor(contCls);
                        if (((BaseMod)this.base).debugGui) {
                            SGCraft.log.debug("BaseModClient.getClientGuiElement: Instantiating container");
                        }
                        if ((cont = ((BaseMod)this.base).createGuiElement(contCls, player, world, pos, param)) == null) break block14;
                        if (((BaseMod)this.base).debugGui) {
                            SGCraft.log.debug("BaseModClient.getClientGuiElement: Instantiating screen with container");
                        }
                        try {
                            result = ctor.newInstance(cont);
                        }
                        catch (Exception e) {
                            BaseMod.reportExceptionCause(e);
                            return null;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (result == null) {
                result = ((BaseMod)this.base).createGuiElement(scrnCls, player, world, pos, param);
            }
        } else {
            result = this.getGuiScreen(id, player, world, pos, param);
        }
        ((BaseMod)this.base).setModOf(result);
        if (((BaseMod)this.base).debugGui) {
            SGCraft.log.debug(String.format("BaseModClient.getClientGuiElement: returning %s", result));
        }
        return result;
    }

    GuiScreen getGuiScreen(int id, EntityPlayer player, World world, Vector3i pos, int param) {
        SGCraft.log.debug(String.format("%s: BaseModClient.getGuiScreen: No GuiScreen class found for gui id %d", this, id));
        return null;
    }

    public void addBlockRenderer(IBlock block, ICustomRenderer renderer) {
        this.blockRenderers.put(block, renderer);
        this.customRenderingRequired = true;
        Item item = Item.func_150898_a((Block)((Block)block));
        if (item != null && !this.itemRenderers.containsKey(item)) {
            this.addItemRenderer(item, renderer);
        }
    }

    public void addItemRenderer(Item item, ICustomRenderer renderer) {
        this.itemRenderers.put(item, renderer);
    }

    protected boolean blockNeedsCustomRendering(Block block) {
        return this.blockRenderers.containsKey(block) || this.specifiesTextures(block);
    }

    protected boolean itemNeedsCustomRendering(Item item) {
        return this.itemRenderers.containsKey(item) || this.specifiesTextures(item);
    }

    protected boolean specifiesTextures(Object obj) {
        return obj instanceof ITextureConsumer && ((ITextureConsumer)obj).getTextureNames() != null;
    }

    protected int getCustomBlockRenderType() {
        return this.getBlockRenderDispatcher().renderID;
    }

    protected BlockRenderDispatcher getBlockRenderDispatcher() {
        if (this.blockRenderDispatcher == null) {
            this.blockRenderDispatcher = new BlockRenderDispatcher();
        }
        return this.blockRenderDispatcher;
    }

    protected ItemRenderDispatcher getItemRenderDispatcher() {
        if (this.itemRenderDispatcher == null) {
            this.itemRenderDispatcher = new ItemRenderDispatcher();
        }
        return this.itemRenderDispatcher;
    }

    protected ICustomRenderer getCustomBlockRenderer(IBlockAccess world, Vector3i pos, IBlockState state) {
        BaseBlock block = (BaseBlock)state.getBlock();
        ICustomRenderer rend = this.blockRenderers.get(block);
        if (rend == null && block != null) {
            IBlockState astate = block.getActualState(state, world, pos);
            rend = this.getModelRendererForState(astate);
        }
        return rend;
    }

    protected ICustomRenderer getModelRendererForSpec(ModelSpec spec, int textureType) {
        IModel model = this.getModel(spec.modelName);
        ITexture[] textures = new ITexture[spec.textureNames.length];
        for (int i = 0; i < textures.length; ++i) {
            textures[i] = this.getTexture(textureType, spec.textureNames[i]);
        }
        return new BaseModelRenderer(model, spec.origin, textures);
    }

    protected ICustomRenderer getModelRendererForState(IBlockState astate) {
        ModelSpec spec;
        Block block;
        ICustomRenderer rend = this.stateRendererCache.get(astate);
        if (rend == null && (block = astate.getBlock()) instanceof IBlock && (spec = ((IBlock)block).getModelSpec(astate)) != null) {
            rend = this.getModelRendererForSpec(spec, 0);
            this.stateRendererCache.put(astate, rend);
        }
        return rend;
    }

    protected ICustomRenderer getModelRendererForItemStack(ItemStack stack) {
        ModelSpec spec;
        Item item = stack.func_77973_b();
        if (debugRenderItem) {
            SGCraft.log.debug(String.format("BaseModClient.getModelRendererForItemStack: item = %s %s", item, item.func_77658_a()));
        }
        if (item instanceof IItem && (spec = ((IItem)item).getModelSpec(stack)) != null) {
            return this.getModelRendererForSpec(spec, 1);
        }
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).field_150939_a;
            if (debugRenderItem) {
                SGCraft.log.debug(String.format("BaseModClient.getModelRendererForItemStack: block = %s %s", block, block.func_149739_a()));
            }
            if (block instanceof BaseBlock) {
                IBlockState state = BaseBlockUtils.getBlockStateFromItemStack(stack);
                ModelSpec spec2 = ((IBlock)block).getModelSpec(state);
                return this.getModelRendererForSpec(spec2, 0);
            }
        }
        return null;
    }

    public void renderBlockUsingModelSpec(IBlockAccess world, Vector3i pos, IBlockState state, IRenderTarget target, EnumWorldBlockLayer layer, Trans3 t) {
        ICustomRenderer rend = this.getModelRendererForState(state);
        if (rend != null) {
            rend.renderBlock(world, pos, state, target, layer, t);
        }
    }

    public void renderItemStackUsingModelSpec(ItemStack stack, IRenderTarget target, Trans3 t) {
        ICustomRenderer rend = this.getModelRendererForItemStack(stack);
        if (debugRenderItem) {
            SGCraft.log.debug(String.format("BaseModClient.renderItemStackUsingModelSpec: renderer = %s", rend));
        }
        if (rend != null) {
            rend.renderItemStack(stack, target, t);
        }
    }

    public IModel getModel(String name) {
        return ((BaseMod)this.base).getModel(name);
    }

    public ITexture getTexture(int type, String name) {
        ResourceLocation loc = ((BaseMod)this.base).resourceLocation(name);
        return (ITexture)this.textureCaches[type].get(loc);
    }

    @SubscribeEvent
    public void onTextureStitchEventPre(TextureStitchEvent.Pre e) {
        int type = e.map.func_130086_a();
        if (type >= 0 && type <= 1) {
            TextureCache cache = this.textureCaches[type];
            cache.clear();
            switch (type) {
                case 0: {
                    for (Block block : ((BaseMod)this.base).registeredBlocks) {
                        this.registerSprites(e.map, cache, block);
                    }
                    break;
                }
                case 1: {
                    for (Item item : ((BaseMod)this.base).registeredItems) {
                        this.registerSprites(e.map, cache, item);
                    }
                    break;
                }
            }
        }
    }

    protected void registerSprites(TextureMap reg, TextureCache cache, Object obj) {
        if (this.debugModelRegistration) {
            SGCraft.log.debug(String.format("BaseModClient.registerSprites: for %s", obj));
        }
        if (!(obj instanceof ITextureConsumer)) {
            return;
        }
        String[] names = ((ITextureConsumer)obj).getTextureNames();
        if (names == null) {
            return;
        }
        this.customRenderingRequired = true;
        for (String name : names) {
            ResourceLocation loc = ((BaseMod)this.base).resourceLocation(name);
            if (cache.get(loc) != null) continue;
            if (this.debugModelRegistration) {
                SGCraft.log.debug(String.format("BaseModClient.registerSprites: %s", loc));
            }
            IIcon icon = reg.func_94245_a(loc.toString());
            Sprite texture = BaseTexture.fromSprite(icon);
            cache.put(loc, texture);
        }
    }

    protected class ItemRenderDispatcher
    implements IItemRenderer {
        protected ItemRenderDispatcher() {
        }

        public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
            return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
        }

        public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
            return true;
        }

        public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
            Trans3 t;
            if (debugRenderItem) {
                SGCraft.log.debug(String.format("BaseModClient.ItemRenderDispatcher.renderItem: %s %s pass %s", type, stack, MinecraftForgeClient.getRenderPass()));
            }
            ICustomRenderer renderer = BaseModClient.this.itemRenderers.get(stack.func_77973_b());
            if (debugRenderItem) {
                SGCraft.log.debug(String.format("BaseModClient.ItemRenderDispatcher.renderItem: Custom renderer = %s", renderer));
            }
            if (renderer == null) {
                renderer = BaseModClient.this.getModelRendererForItemStack(stack);
                if (debugRenderItem) {
                    SGCraft.log.debug(String.format("BaseModClient.ItemRenderDispatcher.renderItem: Model renderer = %s", renderer));
                }
            }
            if (renderer == null) {
                return;
            }
            switch (type) {
                case ENTITY: {
                    t = entityTrans;
                    break;
                }
                case EQUIPPED: {
                    t = equippedTrans;
                    break;
                }
                case EQUIPPED_FIRST_PERSON: {
                    t = firstPersonTrans;
                    break;
                }
                case INVENTORY: {
                    t = inventoryTrans;
                    GL11.glEnable((int)3042);
                    GL11.glEnable((int)2884);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    break;
                }
                default: {
                    return;
                }
            }
            glTarget.start(false);
            renderer.renderItemStack(stack, glTarget, t);
            glTarget.finish();
            if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                GL11.glDisable((int)3042);
                GL11.glDisable((int)2884);
            }
        }
    }

    protected class BlockRenderDispatcher
    implements ISimpleBlockRenderingHandler {
        protected int renderID = RenderingRegistry.getNextAvailableRenderId();

        public BlockRenderDispatcher() {
            RenderingRegistry.registerBlockHandler((int)this.renderID, (ISimpleBlockRenderingHandler)this);
        }

        public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks rb) {
            ICustomRenderer renderer;
            boolean result = false;
            Vector3i pos = new Vector3i(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            BaseBlock baseBlock = (BaseBlock)block;
            IBlockState state = baseBlock.getStateFromMeta(meta);
            if (debugRenderBlock) {
                SGCraft.log.debug(String.format("BaseModClient.BlockRenderDispatcher.renderWorldBlock: %s with meta %s state %s", block, meta, state));
            }
            if ((renderer = BaseModClient.this.getCustomBlockRenderer(world, pos, state)) != null) {
                if (debugRenderBlock) {
                    SGCraft.log.debug(String.format("BaseModClient.BlockRenderDispatcher.renderWorldBlock: using %s", renderer));
                }
                int pass = ForgeHooksClient.getWorldRenderPass();
                for (EnumWorldBlockLayer layer : passLayers[pass + 1]) {
                    if (debugRenderBlock) {
                        SGCraft.log.debug(String.format("BaseModClient.BlockRenderDispatcher.renderWorldBlock: %s in layer %s", new Object[]{block, layer}));
                    }
                    if (!baseBlock.canRenderInLayer(layer)) continue;
                    BaseWorldRenderTarget target = new BaseWorldRenderTarget(world, pos, Tessellator.field_78398_a, rb.field_147840_d);
                    Trans3 t = Trans3.blockCenter(pos);
                    renderer.renderBlock(world, pos, state, target, layer, t);
                    if (!target.end()) continue;
                    result = true;
                }
            }
            return result;
        }

        public void renderInventoryBlock(Block block, int meta, int modelId, RenderBlocks renderer) {
        }

        public boolean shouldRender3DInInventory(int modelId) {
            return true;
        }

        public int getRenderId() {
            return this.renderID;
        }
    }
}

