/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.item;

import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import remoteio.common.RemoteIO;
import remoteio.common.core.TabRemoteIO;
import remoteio.common.lib.DimensionalCoords;
import remoteio.common.lib.ModInfo;
import remoteio.common.tile.TileRemoteInterface;
import remoteio.common.tile.TileRemoteInventory;

public final class ItemRemoteAccessor
extends Item {
    private final IIcon[] icons = new IIcon[2];

    public ItemRemoteAccessor() {
        this.func_77625_d(1);
        this.func_77637_a(TabRemoteIO.TAB);
    }

    public void func_94581_a(IIconRegister register) {
        this.icons[0] = register.func_94245_a(ModInfo.RESOURCE_PREFIX + "accessor_inactive");
        this.icons[1] = register.func_94245_a(ModInfo.RESOURCE_PREFIX + "accessor_active");
    }

    public IIcon func_77650_f(ItemStack stack) {
        DimensionalCoords coords = ItemRemoteAccessor.getCoordinates(stack);
        if (coords != null) {
            return this.icons[1];
        }
        return this.icons[0];
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        DimensionalCoords coords = ItemRemoteAccessor.getCoordinates(stack);
        if (coords != null) {
            return this.icons[1];
        }
        return this.icons[0];
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean debug) {
        DimensionalCoords coords = ItemRemoteAccessor.getCoordinates(stack);
        if (!player.func_70093_af()) {
            if (coords != null) {
                list.add("Dimension: " + DimensionManager.getProvider((int)coords.dimensionID).func_80007_l());
                list.add("X: " + coords.x + " Y: " + coords.y + " Z: " + coords.z);
            }
        } else if (coords != null) {
            list.add("Dimension: " + DimensionManager.getProvider((int)coords.dimensionID).func_80007_l());
            list.add("Block: " + player.field_70170_p.func_147439_a(coords.x, coords.y, coords.z).func_149732_F());
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float fx, float fy, float fz) {
        if (ItemRemoteAccessor.getCoordinates(stack) != null) {
            DimensionalCoords coords = ItemRemoteAccessor.getCoordinates(stack);
            if (coords.dimensionID == world.field_73011_w.field_76574_g) {
                RemoteIO.proxy.activateBlock(world, coords.x, coords.y, coords.z, player, side, fx, fy, fz);
                return true;
            }
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (player.func_70093_af() && !(tile instanceof TileRemoteInterface) && !(tile instanceof TileRemoteInventory)) {
                ItemRemoteAccessor.setCoordinates(stack, new DimensionalCoords(world.field_73011_w.field_76574_g, x, y, z));
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.target.save", new Object[0]));
                return true;
            }
        }
        return false;
    }

    public static void setCoordinates(ItemStack stack, DimensionalCoords coords) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        NBTTagCompound tag = new NBTTagCompound();
        coords.writeToNBT(tag);
        nbt.func_74782_a("position", (NBTBase)tag);
        stack.func_77982_d(nbt);
    }

    public static DimensionalCoords getCoordinates(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound comp = stack.func_77978_p();
        if (!comp.func_74764_b("position")) {
            return null;
        }
        return DimensionalCoords.fromNBT(comp.func_74775_l("position"));
    }
}

