/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.util.misc.Game;

public abstract class RailcraftPacket {
    public static final String CHANNEL_NAME = "RC";

    public FMLProxyPacket getPacket() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeByte(this.getID());
            this.writeData(data);
        }
        catch (IOException e) {
            Game.logThrowable("Error constructing packet: {0}", e, this.getClass());
        }
        return new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])bytes.toByteArray()), CHANNEL_NAME);
    }

    public abstract void writeData(DataOutputStream var1) throws IOException;

    public abstract void readData(DataInputStream var1) throws IOException;

    public abstract int getID();

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static enum PacketType {
        TILE_ENTITY,
        GUI_RETURN,
        TILE_EXTRA_DATA,
        TILE_REQUEST,
        GUI_INTEGER,
        GUI_STRING,
        GUI_WIDGET,
        EFFECT,
        CONTROLLER_REQUEST,
        CONTROLLER_UPDATE,
        RECEIVER_REQUEST,
        RECEIVER_UPDATE,
        SIGNAL_REQUEST,
        SIGNAL_UPDATE,
        ITEM_NBT,
        KEY_PRESS,
        GOLDEN_TICKET_GUI;

    }
}

