/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.land;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoGrass;
import rwg.deco.trees.DecoJungleFat;
import rwg.deco.trees.DecoJungleSmall;
import rwg.deco.trees.DecoJungleTall;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfaceGrassland;
import rwg.terrain.TerrainBase;
import rwg.terrain.TerrainHilly;
import rwg.util.CellNoise;
import rwg.util.NoiseGenerator;

public class RealisticBiomeRedwoodJungle
extends RealisticBiomeBase {
    private TerrainBase terrain = new TerrainHilly(230.0f, 100.0f, 0.0f);
    private SurfaceBase surface = new SurfaceGrassland((Block)Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_150347_e);

    public RealisticBiomeRedwoodJungle() {
        super(0, RWGBiomes.baseJungle);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, NoiseGenerator perlin, CellNoise cell, float strength, float river) {
        DecoJungleSmall worldgenerator;
        int k10;
        int j6;
        int k102;
        int j62;
        int z52;
        int i23 = 0;
        while ((float)i23 < 2.0f * strength) {
            int i1 = chunkX + rand.nextInt(16) + 8;
            int j1 = chunkY + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1);
            new WorldGenBlockBlob(Blocks.field_150341_Y, 0).func_76484_a(world, rand, i1, k1, j1);
            ++i23;
        }
        float l = perlin.noise2((float)chunkX / 80.0f, (float)chunkY / 80.0f) * 34.0f + 10.0f;
        if (rand.nextInt((int)(50.0f / strength)) == 0 && (z52 = world.func_72976_f(j62 = chunkX + rand.nextInt(6) + 13, k102 = chunkY + rand.nextInt(6) + 13)) < 110) {
            DecoJungleFat worldgenerator2 = new DecoJungleFat(Blocks.field_150364_r, 3, (Block)Blocks.field_150362_t, 3, 20 + rand.nextInt(8), 7 + rand.nextInt(2), 23.0f, 7, 0.22f, 0.2f);
            worldgenerator2.func_76487_a(1.0, 1.0, 1.0);
            worldgenerator2.func_76484_a(world, rand, j62, z52, k102);
        }
        int a = 0;
        while ((float)a < l * strength) {
            if (rand.nextInt(3) == 0) {
                j6 = chunkX + rand.nextInt(12) + 10;
                k10 = chunkY + rand.nextInt(12) + 10;
                int z522 = world.func_72976_f(j6, k10);
                worldgenerator = rand.nextInt(24) == 0 ? new DecoJungleFat(Blocks.field_150364_r, 3, (Block)Blocks.field_150362_t, 3, 14 + rand.nextInt(8), 5 + rand.nextInt(2), 16.0f, 5, 0.32f, 0.1f) : new DecoJungleTall(Blocks.field_150364_r, 3, (Block)Blocks.field_150362_t, 3, 3 + rand.nextInt(7), 3 + rand.nextInt(2), 9.0f, 3, 0.32f, 0.1f);
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z522, k10);
            }
            ++a;
        }
        int b33 = 0;
        while ((float)b33 < 3.0f * strength) {
            j6 = chunkX + rand.nextInt(16) + 8;
            k10 = chunkY + rand.nextInt(16) + 8;
            int z523 = world.func_72976_f(j6, k10);
            worldgenerator = rand.nextInt(10) == 0 ? new DecoJungleSmall(Blocks.field_150364_r, 3, (Block)Blocks.field_150362_t, 3, 1 + rand.nextInt(4), 0, 5.0f, 2, 0.32f, 0.14f) : new WorldGenShrub(0, 0);
            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
            worldgenerator.func_76484_a(world, rand, j6, z523, k10);
            ++b33;
        }
        int b = 0;
        while ((float)b < 2.0f * strength) {
            int i18 = chunkX + rand.nextInt(16) + 8;
            int i232 = chunkY + rand.nextInt(16) + 8;
            new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i232);
            ++b;
        }
        for (int l14 = 0; l14 < 13; ++l14) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            if (rand.nextInt(6) == 0) {
                new DecoGrass((Block)Blocks.field_150398_cm, rand.nextBoolean() ? 2 : 3).func_76484_a(world, rand, l19, k22, j24);
                continue;
            }
            new DecoGrass((Block)Blocks.field_150329_H, rand.nextBoolean() ? 1 : 2).func_76484_a(world, rand, l19, k22, j24);
        }
    }

    @Override
    public float rNoise(NoiseGenerator perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return this.terrain.generateNoise(perlin, cell, x, y, ocean, border, river);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, NoiseGenerator perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        this.surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
    }
}

