/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.org.jfree.data.xml;

import mcp.mobius.shadow.org.jfree.data.DefaultKeyedValues;
import mcp.mobius.shadow.org.jfree.data.xml.CategoryDatasetHandler;
import mcp.mobius.shadow.org.jfree.data.xml.DatasetTags;
import mcp.mobius.shadow.org.jfree.data.xml.ItemHandler;
import mcp.mobius.shadow.org.jfree.data.xml.RootHandler;
import mcp.mobius.shadow.org.xml.sax.Attributes;
import mcp.mobius.shadow.org.xml.sax.SAXException;
import mcp.mobius.shadow.org.xml.sax.helpers.DefaultHandler;

public class CategorySeriesHandler
extends DefaultHandler
implements DatasetTags {
    private RootHandler root;
    private Comparable seriesKey;
    private DefaultKeyedValues values;

    public CategorySeriesHandler(RootHandler root) {
        this.root = root;
        this.values = new DefaultKeyedValues();
    }

    public void setSeriesKey(Comparable key) {
        this.seriesKey = key;
    }

    public void addItem(Comparable key, Number value) {
        this.values.addValue(key, value);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("Series")) {
            this.setSeriesKey((Comparable)((Object)atts.getValue("name")));
            ItemHandler subhandler = new ItemHandler(this.root, this);
            this.root.pushSubHandler(subhandler);
        } else if (qName.equals("Item")) {
            ItemHandler subhandler = new ItemHandler(this.root, this);
            this.root.pushSubHandler(subhandler);
            subhandler.startElement(namespaceURI, localName, qName, atts);
        } else {
            throw new SAXException("Expecting <Series> or <Item> tag...found " + qName);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (this.root instanceof CategoryDatasetHandler) {
            CategoryDatasetHandler handler = (CategoryDatasetHandler)this.root;
            for (Comparable key : this.values.getKeys()) {
                Number value = this.values.getValue(key);
                handler.addItem(this.seriesKey, key, value);
            }
            this.root.popSubHandler();
        }
    }
}

