/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.org.jfree.chart.title;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import mcp.mobius.shadow.org.jfree.chart.block.BlockContainer;
import mcp.mobius.shadow.org.jfree.chart.block.BorderArrangement;
import mcp.mobius.shadow.org.jfree.chart.block.RectangleConstraint;
import mcp.mobius.shadow.org.jfree.chart.event.TitleChangeEvent;
import mcp.mobius.shadow.org.jfree.chart.title.Title;
import mcp.mobius.shadow.org.jfree.chart.util.ParamChecks;
import mcp.mobius.shadow.org.jfree.io.SerialUtilities;
import mcp.mobius.shadow.org.jfree.ui.Size2D;
import mcp.mobius.shadow.org.jfree.util.PaintUtilities;

public class CompositeTitle
extends Title
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6770854036232562290L;
    private transient Paint backgroundPaint;
    private BlockContainer container;

    public CompositeTitle() {
        this(new BlockContainer(new BorderArrangement()));
    }

    public CompositeTitle(BlockContainer container) {
        ParamChecks.nullNotPermitted(container, "container");
        this.container = container;
        this.backgroundPaint = null;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public BlockContainer getContainer() {
        return this.container;
    }

    public void setTitleContainer(BlockContainer container) {
        ParamChecks.nullNotPermitted(container, "container");
        this.container = container;
    }

    @Override
    public Size2D arrange(Graphics2D g2, RectangleConstraint constraint) {
        RectangleConstraint contentConstraint = this.toContentConstraint(constraint);
        Size2D contentSize = this.container.arrange(g2, contentConstraint);
        return new Size2D(this.calculateTotalWidth(contentSize.getWidth()), this.calculateTotalHeight(contentSize.getHeight()));
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D area) {
        this.draw(g2, area, null);
    }

    @Override
    public Object draw(Graphics2D g2, Rectangle2D area, Object params) {
        area = this.trimMargin(area);
        this.drawBorder(g2, area);
        area = this.trimBorder(area);
        if (this.backgroundPaint != null) {
            g2.setPaint(this.backgroundPaint);
            g2.fill(area);
        }
        area = this.trimPadding(area);
        return this.container.draw(g2, area, params);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompositeTitle)) {
            return false;
        }
        CompositeTitle that = (CompositeTitle)obj;
        if (!this.container.equals(that.container)) {
            return false;
        }
        if (!PaintUtilities.equal(this.backgroundPaint, that.backgroundPaint)) {
            return false;
        }
        return super.equals(obj);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint(this.backgroundPaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.backgroundPaint = SerialUtilities.readPaint(stream);
    }
}

