/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.org.jfree.chart.renderer.xy;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.shadow.org.jfree.chart.axis.ValueAxis;
import mcp.mobius.shadow.org.jfree.chart.plot.PlotOrientation;
import mcp.mobius.shadow.org.jfree.chart.plot.PlotRenderingInfo;
import mcp.mobius.shadow.org.jfree.chart.plot.XYPlot;
import mcp.mobius.shadow.org.jfree.chart.renderer.xy.XYItemRendererState;
import mcp.mobius.shadow.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import mcp.mobius.shadow.org.jfree.chart.util.ParamChecks;
import mcp.mobius.shadow.org.jfree.data.xy.XYDataset;
import mcp.mobius.shadow.org.jfree.ui.GradientPaintTransformer;
import mcp.mobius.shadow.org.jfree.ui.RectangleEdge;
import mcp.mobius.shadow.org.jfree.ui.StandardGradientPaintTransformer;
import mcp.mobius.shadow.org.jfree.util.ObjectUtilities;

public class XYSplineRenderer
extends XYLineAndShapeRenderer {
    private int precision;
    private FillType fillType;
    private GradientPaintTransformer gradientPaintTransformer;

    public XYSplineRenderer() {
        this(5, FillType.NONE);
    }

    public XYSplineRenderer(int precision) {
        this(precision, FillType.NONE);
    }

    public XYSplineRenderer(int precision, FillType fillType) {
        if (precision <= 0) {
            throw new IllegalArgumentException("Requires precision > 0.");
        }
        ParamChecks.nullNotPermitted((Object)fillType, "fillType");
        this.precision = precision;
        this.fillType = fillType;
        this.gradientPaintTransformer = new StandardGradientPaintTransformer();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int p) {
        if (p <= 0) {
            throw new IllegalArgumentException("Requires p > 0.");
        }
        this.precision = p;
        this.fireChangeEvent();
    }

    public FillType getFillType() {
        return this.fillType;
    }

    public void setFillType(FillType fillType) {
        this.fillType = fillType;
        this.fireChangeEvent();
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gpt) {
        this.gradientPaintTransformer = gpt;
        this.fireChangeEvent();
    }

    @Override
    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        this.setDrawSeriesLineAsPath(true);
        XYSplineState state = new XYSplineState(info);
        state.setProcessVisibleItemsOnly(false);
        return state;
    }

    @Override
    protected void drawPrimaryLineAsPath(XYItemRendererState state, Graphics2D g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis xAxis, ValueAxis yAxis, Rectangle2D dataArea) {
        XYSplineState s = (XYSplineState)state;
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        double transX1 = xAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = yAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (!Double.isNaN(transX1) && !Double.isNaN(transY1)) {
            Point2D.Float p;
            Point2D.Float float_ = p = plot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float((float)transY1, (float)transX1) : new Point2D.Float((float)transX1, (float)transY1);
            if (!s.points.contains(p)) {
                s.points.add(p);
            }
        }
        if (item == dataset.getItemCount(series) - 1) {
            if (s.points.size() > 1) {
                Point2D.Float origin;
                if (this.fillType == FillType.TO_ZERO) {
                    float xz = (float)xAxis.valueToJava2D(0.0, dataArea, yAxisLocation);
                    float yz = (float)yAxis.valueToJava2D(0.0, dataArea, yAxisLocation);
                    origin = plot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float(yz, xz) : new Point2D.Float(xz, yz);
                } else if (this.fillType == FillType.TO_LOWER_BOUND) {
                    float xlb = (float)xAxis.valueToJava2D(xAxis.getLowerBound(), dataArea, xAxisLocation);
                    float ylb = (float)yAxis.valueToJava2D(yAxis.getLowerBound(), dataArea, yAxisLocation);
                    origin = plot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float(ylb, xlb) : new Point2D.Float(xlb, ylb);
                } else {
                    float xub = (float)xAxis.valueToJava2D(xAxis.getUpperBound(), dataArea, xAxisLocation);
                    float yub = (float)yAxis.valueToJava2D(yAxis.getUpperBound(), dataArea, yAxisLocation);
                    origin = plot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float(yub, xub) : new Point2D.Float(xub, yub);
                }
                Point2D cp0 = s.points.get(0);
                s.seriesPath.moveTo(cp0.getX(), cp0.getY());
                if (this.fillType != FillType.NONE) {
                    if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                        s.fillArea.moveTo(((Point2D)origin).getX(), cp0.getY());
                    } else {
                        s.fillArea.moveTo(cp0.getX(), ((Point2D)origin).getY());
                    }
                    s.fillArea.lineTo(cp0.getX(), cp0.getY());
                }
                if (s.points.size() == 2) {
                    Point2D cp1 = s.points.get(1);
                    if (this.fillType != FillType.NONE) {
                        s.fillArea.lineTo(cp1.getX(), cp1.getY());
                        s.fillArea.lineTo(cp1.getX(), ((Point2D)origin).getY());
                        s.fillArea.closePath();
                    }
                    s.seriesPath.lineTo(cp1.getX(), cp1.getY());
                } else {
                    int i;
                    int i2;
                    int np = s.points.size();
                    float[] d = new float[np];
                    float[] x = new float[np];
                    float[] a = new float[np];
                    float[] h = new float[np];
                    for (i2 = 0; i2 < np; ++i2) {
                        Point2D.Float cpi = (Point2D.Float)s.points.get(i2);
                        x[i2] = cpi.x;
                        d[i2] = cpi.y;
                    }
                    for (i2 = 1; i2 <= np - 1; ++i2) {
                        h[i2] = x[i2] - x[i2 - 1];
                    }
                    float[] sub = new float[np - 1];
                    float[] diag = new float[np - 1];
                    float[] sup = new float[np - 1];
                    for (i = 1; i <= np - 2; ++i) {
                        diag[i] = (h[i] + h[i + 1]) / 3.0f;
                        sup[i] = h[i + 1] / 6.0f;
                        sub[i] = h[i] / 6.0f;
                        a[i] = (d[i + 1] - d[i]) / h[i + 1] - (d[i] - d[i - 1]) / h[i];
                    }
                    this.solveTridiag(sub, diag, sup, a, np - 2);
                    float oldt = x[0];
                    float oldy = d[0];
                    for (i = 1; i <= np - 1; ++i) {
                        for (int j = 1; j <= this.precision; ++j) {
                            float t1 = h[i] * (float)j / (float)this.precision;
                            float t2 = h[i] - t1;
                            float y = ((-a[i - 1] / 6.0f * (t2 + h[i]) * t1 + d[i - 1]) * t2 + (-a[i] / 6.0f * (t1 + h[i]) * t2 + d[i]) * t1) / h[i];
                            float t = x[i - 1] + t1;
                            s.seriesPath.lineTo(t, y);
                            if (this.fillType == FillType.NONE) continue;
                            s.fillArea.lineTo(t, y);
                        }
                    }
                }
                if (this.fillType != FillType.NONE) {
                    if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                        s.fillArea.lineTo(((Point2D)origin).getX(), s.points.get(s.points.size() - 1).getY());
                    } else {
                        s.fillArea.lineTo(s.points.get(s.points.size() - 1).getX(), ((Point2D)origin).getY());
                    }
                    s.fillArea.closePath();
                }
                if (this.fillType != FillType.NONE) {
                    Paint fp = this.getSeriesFillPaint(series);
                    if (this.gradientPaintTransformer != null && fp instanceof GradientPaint) {
                        GradientPaint gp = this.gradientPaintTransformer.transform((GradientPaint)fp, s.fillArea);
                        g2.setPaint(gp);
                    } else {
                        g2.setPaint(fp);
                    }
                    g2.fill(s.fillArea);
                    s.fillArea.reset();
                }
                this.drawFirstPassShape(g2, pass, series, item, s.seriesPath);
            }
            s.points = new ArrayList<Point2D>();
        }
    }

    private void solveTridiag(float[] sub, float[] diag, float[] sup, float[] b, int n) {
        int i;
        for (i = 2; i <= n; ++i) {
            int n2 = i;
            sub[n2] = sub[n2] / diag[i - 1];
            int n3 = i;
            diag[n3] = diag[n3] - sub[i] * sup[i - 1];
            int n4 = i;
            b[n4] = b[n4] - sub[i] * b[i - 1];
        }
        int n5 = n;
        b[n5] = b[n5] / diag[n];
        for (i = n - 1; i >= 1; --i) {
            b[i] = (b[i] - sup[i] * b[i + 1]) / diag[i];
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYSplineRenderer)) {
            return false;
        }
        XYSplineRenderer that = (XYSplineRenderer)obj;
        if (this.precision != that.precision) {
            return false;
        }
        if (this.fillType != that.fillType) {
            return false;
        }
        if (!ObjectUtilities.equal(this.gradientPaintTransformer, that.gradientPaintTransformer)) {
            return false;
        }
        return super.equals(obj);
    }

    public static class XYSplineState
    extends XYLineAndShapeRenderer.State {
        public GeneralPath fillArea = new GeneralPath();
        public List<Point2D> points = new ArrayList<Point2D>();

        public XYSplineState(PlotRenderingInfo info) {
            super(info);
        }
    }

    public static enum FillType {
        NONE,
        TO_ZERO,
        TO_LOWER_BOUND,
        TO_UPPER_BOUND;

    }
}

