/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.network.rcon.server;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import mcp.mobius.opis.data.holders.basetypes.SerialLong;
import mcp.mobius.opis.data.managers.StringCache;
import mcp.mobius.opis.events.PlayerTracker;
import mcp.mobius.opis.modOpis;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.PacketManager;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.network.packets.server.NetDataValue;
import mcp.mobius.opis.network.rcon.RConHandler;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelHandlerContext;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelInboundHandlerAdapter;
import mcp.mobius.shadow.io.nettyopis.util.ReferenceCountUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

class RConInboundHandler
extends ChannelInboundHandlerAdapter {
    RConInboundHandler() {
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        UUID fakeUUID = UUID.randomUUID();
        FakePlayer fakePlayer = FakePlayerFactory.get((WorldServer)DimensionManager.getWorld((int)0), (GameProfile)new GameProfile(fakeUUID, ctx.name()));
        RConHandler.fakePlayersRcon.put((Object)fakePlayer, (Object)ctx);
        PlayerTracker.INSTANCE.playersSwing.add((EntityPlayerMP)fakePlayer);
        PacketManager.validateAndSend(new NetDataValue(Message.STATUS_CURRENT_TIME, new SerialLong(System.currentTimeMillis())), (EntityPlayerMP)fakePlayer);
        StringCache.INSTANCE.syncCache((EntityPlayerMP)fakePlayer);
        modOpis.log.info(String.format("FakePlayer %s with uuid %s created.", ctx.name(), fakeUUID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            FakePlayer fakePlayer = (FakePlayer)RConHandler.fakePlayersRcon.inverse().get((Object)ctx);
            PacketBase packet = (PacketBase)msg;
            packet.actionServer(null, (EntityPlayerMP)fakePlayer);
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        RConHandler.exceptionCaught(ctx, cause);
    }
}

