/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import openmods.calc.ICallable;
import openmods.calc.NullaryFunction;
import openmods.calc.types.multi.CallableValue;
import openmods.calc.types.multi.MetaObject;
import openmods.calc.types.multi.MetaObjectUtils;
import openmods.calc.types.multi.SimpleTypedFunction;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypeUserdata;
import openmods.calc.types.multi.TypedFunction;
import openmods.calc.types.multi.TypedValue;

public class LibRandom {
    private final TypedValue typeValue;
    private final TypeDomain domain;

    public LibRandom(TypeDomain domain) {
        this.domain = domain;
        TypeUserdata type = new TypeUserdata("random", RandomValue.class);
        domain.registerType(RandomValue.class, "random");
        this.typeValue = domain.create(TypeUserdata.class, type, TypeUserdata.defaultMetaObject(domain).set(MetaObjectUtils.callableAdapter(new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            @TypedFunction.RawReturn
            public TypedValue create() {
                return LibRandom.this.domain.create(RandomValue.class, RandomValue.INSTANCE, LibRandom.this.createRandomValueMetaobject(new Random()));
            }

            @TypedFunction.Variant
            @TypedFunction.RawReturn
            public TypedValue create(@TypedFunction.DispatchArg BigInteger seed) {
                return LibRandom.this.domain.create(RandomValue.class, RandomValue.INSTANCE, LibRandom.this.createRandomValueMetaobject(new Random(seed.longValue())));
            }
        })).build());
    }

    private Map<String, TypedValue> createMembers(final Random random) {
        HashMap result = Maps.newHashMap();
        result.put("nextInt", CallableValue.wrap(this.domain, new SimpleTypedFunction(this.domain){

            @TypedFunction.Variant
            public BigInteger next(@TypedFunction.DispatchArg BigInteger range) {
                return BigInteger.valueOf(random.nextInt(range.intValue()));
            }

            @TypedFunction.Variant
            public BigInteger next() {
                return BigInteger.valueOf(random.nextInt());
            }
        }));
        result.put("nextFloat", CallableValue.wrap(this.domain, (ICallable<TypedValue>)new NullaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call() {
                return LibRandom.this.domain.create(Double.class, random.nextDouble());
            }
        }));
        result.put("nextBoolean", CallableValue.wrap(this.domain, (ICallable<TypedValue>)new NullaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call() {
                return LibRandom.this.domain.create(Boolean.class, random.nextBoolean());
            }
        }));
        result.put("nextGaussian", CallableValue.wrap(this.domain, (ICallable<TypedValue>)new NullaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call() {
                return LibRandom.this.domain.create(Double.class, random.nextGaussian());
            }
        }));
        return ImmutableMap.copyOf((Map)result);
    }

    private MetaObject createRandomValueMetaobject(Random random) {
        Map<String, TypedValue> members = this.createMembers(random);
        return MetaObject.builder().set(MetaObjectUtils.typeConst(this.typeValue)).set(MetaObjectUtils.attrFromMap(members)).set(MetaObjectUtils.dirFromIterable(members.keySet())).build();
    }

    public TypedValue type() {
        return this.typeValue;
    }

    private static class RandomValue {
        private static final RandomValue INSTANCE = new RandomValue();

        private RandomValue() {
        }
    }
}

