/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.Frame;
import openmods.calc.FrameFactory;
import openmods.calc.Operator;
import openmods.calc.SymbolMap;
import openmods.calc.UnaryOperator;
import openmods.utils.Stack;

public abstract class BinaryOperator<E>
extends Operator<E> {
    public static final Associativity DEFAULT_ASSOCIATIVITY = Associativity.LEFT;
    public final int precedence;
    public final Associativity associativity;

    private BinaryOperator(String id, int precedence, Associativity associativity) {
        super(id);
        this.precedence = precedence;
        this.associativity = associativity;
    }

    private BinaryOperator(String id, int precendence) {
        this(id, precendence, DEFAULT_ASSOCIATIVITY);
    }

    @Override
    public boolean isLessThan(Operator<E> other) {
        if (other instanceof UnaryOperator) {
            return true;
        }
        BinaryOperator o = (BinaryOperator)other;
        return this.associativity.isLessThan(this.precedence, o.precedence);
    }

    public String toString() {
        return "BinaryOperator [" + this.id + "]";
    }

    public static abstract class StackBased<E>
    extends BinaryOperator<E> {
        public StackBased(String id, int precedence, Associativity associativity) {
            super(id, precedence, associativity);
        }

        public StackBased(String id, int precendence) {
            super(id, precendence);
        }

        public abstract void executeOnStack(Frame<E> var1);

        @Override
        public final void execute(Frame<E> frame) {
            Frame<E> executionFrame = FrameFactory.newLocalFrameWithSubstack(frame, 2);
            this.executeOnStack(executionFrame);
            executionFrame.stack().checkSizeIsExactly(1);
        }
    }

    public static abstract class Scoped<E>
    extends BinaryOperator<E> {
        public Scoped(String id, int precedence, Associativity associativity) {
            super(id, precedence, associativity);
        }

        public Scoped(String id, int precendence) {
            super(id, precendence);
        }

        public abstract E execute(SymbolMap<E> var1, E var2, E var3);

        @Override
        public final void execute(Frame<E> frame) {
            Stack<E> stack = frame.stack();
            E right = stack.pop();
            E left = stack.pop();
            E result = this.execute(frame.symbols(), left, right);
            stack.push(result);
        }
    }

    public static abstract class Direct<E>
    extends BinaryOperator<E> {
        public Direct(String id, int precedence, Associativity associativity) {
            super(id, precedence, associativity);
        }

        public Direct(String id, int precendence) {
            super(id, precendence);
        }

        public abstract E execute(E var1, E var2);

        @Override
        public final void execute(Frame<E> frame) {
            Stack<E> stack = frame.stack();
            E right = stack.pop();
            E left = stack.pop();
            E result = this.execute(left, right);
            stack.push(result);
        }
    }

    public static enum Associativity {
        LEFT{

            @Override
            protected boolean isLessThan(int left, int right) {
                return left <= right;
            }
        }
        ,
        RIGHT{

            @Override
            protected boolean isLessThan(int left, int right) {
                return left < right;
            }
        };


        protected abstract boolean isLessThan(int var1, int var2);
    }
}

