/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.AutoFocusWidget;
import codechicken.nei.BookmarkPanel;
import codechicken.nei.Button;
import codechicken.nei.ButtonCycled;
import codechicken.nei.GuiExtendedCreativeInv;
import codechicken.nei.Image;
import codechicken.nei.ItemList;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.ItemZoom;
import codechicken.nei.KeyManager;
import codechicken.nei.LayoutStyleMinecraft;
import codechicken.nei.NEIActions;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.SearchField;
import codechicken.nei.SubsetWidget;
import codechicken.nei.VisiblityData;
import codechicken.nei.Widget;
import codechicken.nei.WidgetZOrder;
import codechicken.nei.api.API;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.api.LayoutStyle;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerDrawHandler;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerObjectHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.RecipeCatalysts;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class LayoutManager
implements IContainerInputHandler,
IContainerTooltipHandler,
IContainerDrawHandler,
IContainerObjectHandler,
KeyManager.IKeyStateTracker {
    private static LayoutManager instance;
    private static Widget inputFocused;
    private static TreeSet<Widget> drawWidgets;
    private static TreeSet<Widget> controlWidgets;
    private static List<IContainerTooltipHandler> tooltipWidgets;
    public static ItemPanel itemPanel;
    public static BookmarkPanel bookmarkPanel;
    public static SubsetWidget dropDown;
    public static SearchField searchField;
    public static ItemZoom itemZoom;
    public static ButtonCycled options;
    public static ButtonCycled bookmarksButton;
    @Deprecated
    public static Button more;
    @Deprecated
    public static Button less;
    @Deprecated
    public static ItemQuantityField quantity;
    public static Button delete;
    public static ButtonCycled gamemode;
    public static Button rain;
    public static Button magnet;
    public static Button[] timeButtons;
    public static Button heal;
    public static IRecipeOverlayRenderer overlayRenderer;
    public static HashMap<Integer, LayoutStyle> layoutStyles;
    public static boolean itemsLoaded;
    public static Image[] itemPresenceOverlays;

    public static void load() {
        API.addLayoutStyle(0, new LayoutStyleMinecraft());
        instance = new LayoutManager();
        KeyManager.trackers.add(instance);
        GuiContainerManager.addInputHandler(instance);
        GuiContainerManager.addTooltipHandler(instance);
        GuiContainerManager.addDrawHandler(instance);
        GuiContainerManager.addObjectHandler(instance);
        LayoutManager.init();
    }

    @Override
    public void onPreDraw(GuiContainer gui) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled() && gui instanceof InventoryEffectRenderer) {
            gui.field_147003_i = (gui.field_146294_l - gui.field_146999_f) / 2;
            gui.field_147009_r = (gui.field_146295_m - gui.field_147000_g) / 2;
            if (gui instanceof GuiContainerCreative && gui.field_146292_n.size() >= 2) {
                GuiButton button1 = (GuiButton)gui.field_146292_n.get(0);
                GuiButton button2 = (GuiButton)gui.field_146292_n.get(1);
                button1.field_146128_h = gui.field_147003_i;
                button2.field_146128_h = gui.field_147003_i + gui.field_146999_f - 20;
            }
        }
    }

    @Deprecated
    public static int getSideWidth(GuiContainer gui) {
        return gui.field_146294_l - 3;
    }

    @Deprecated
    public static int getLeftSize(GuiContainer gui) {
        return LayoutManager.getSideWidth(gui);
    }

    @Override
    public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        if (NEIClientConfig.isHidden()) {
            return;
        }
        for (Widget widget : controlWidgets) {
            widget.onGuiClick(mousex, mousey);
        }
    }

    @Override
    public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        if (NEIClientConfig.isHidden()) {
            return false;
        }
        if (!NEIClientConfig.isEnabled()) {
            return options.contains(mousex, mousey) && options.handleClick(mousex, mousey, button);
        }
        for (Widget widget : controlWidgets) {
            widget.onGuiClick(mousex, mousey);
            if (!(widget.contains(mousex, mousey) ? widget.handleClick(mousex, mousey, button) : widget.handleClickExt(mousex, mousey, button))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean objectUnderMouse(GuiContainer gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : drawWidgets) {
                if (!widget.contains(mousex, mousey)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyTyped(GuiContainer gui, char keyChar, int keyID) {
        if (NEIClientConfig.isEnabled() && !NEIClientConfig.isHidden()) {
            if (inputFocused != null) {
                return inputFocused.handleKeyPress(keyID, keyChar);
            }
            for (Widget widget : controlWidgets) {
                if (!widget.handleKeyPress(keyID, keyChar)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
    }

    @Override
    public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        if (NEIClientConfig.isKeyHashDown("gui.hide")) {
            NEIClientConfig.toggleBooleanSetting("inventory.hidden");
            return true;
        }
        if (NEIClientConfig.isKeyHashDown("gui.hide_bookmarks")) {
            NEIClientConfig.toggleBooleanSetting("inventory.bookmarks.enabled");
            return true;
        }
        if (NEIClientConfig.isKeyHashDown("gui.next_tooltip")) {
            GuiContainerManager.incrementTooltipPage();
            return true;
        }
        if (NEIClientConfig.isEnabled() && !NEIClientConfig.isHidden()) {
            for (Widget widget : controlWidgets) {
                if (inputFocused != null) continue;
                widget.lastKeyTyped(keyID, keyChar);
            }
        }
        return false;
    }

    @Override
    public void onMouseUp(GuiContainer gui, int mx, int my, int button) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : controlWidgets) {
                widget.mouseUp(mx, my, button);
            }
        }
    }

    @Override
    public void onMouseDragged(GuiContainer gui, int mx, int my, int button, long heldTime) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : controlWidgets) {
                widget.mouseDragged(mx, my, button, heldTime);
            }
        }
    }

    @Override
    public ItemStack getStackUnderMouse(GuiContainer gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : drawWidgets) {
                ItemStack stack = widget.getStackMouseOver(mousex, mousey);
                if (stack == null) continue;
                return stack;
            }
        }
        return null;
    }

    @Override
    public void renderObjects(GuiContainer gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden()) {
            LayoutManager.layout(gui);
            if (NEIClientConfig.isEnabled()) {
                LayoutManager.getLayoutStyle().drawBackground(GuiContainerManager.getManager(gui));
                for (Widget widget : drawWidgets) {
                    widget.draw(mousex, mousey);
                }
            } else {
                options.draw(mousex, mousey);
                bookmarksButton.draw(mousex, mousey);
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
    }

    @Override
    public void postRenderObjects(GuiContainer gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : drawWidgets) {
                widget.postDraw(mousex, mousey);
            }
        }
    }

    @Override
    public void postRenderTooltips(GuiContainer gui, int mousex, int mousey, List<String> tooltip) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled() && GuiContainerManager.shouldShowTooltip(gui)) {
            for (Widget widget : drawWidgets) {
                widget.postDrawTooltips(mousex, mousey, tooltip);
            }
        }
    }

    @Override
    public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled() && GuiContainerManager.shouldShowTooltip(gui)) {
            for (Widget widget : drawWidgets) {
                currenttip = widget.handleTooltip(mousex, mousey, currenttip);
            }
            for (IContainerTooltipHandler tip : tooltipWidgets) {
                currenttip = tip.handleTooltip(gui, mousex, mousey, currenttip);
            }
        }
        return currenttip;
    }

    @Override
    public List<String> handleItemDisplayName(GuiContainer gui, ItemStack stack, List<String> currenttip) {
        String overridename = ItemInfo.getNameOverride(stack);
        if (overridename != null) {
            currenttip.set(0, overridename);
        }
        String mainname = currenttip.get(0);
        if (NEIClientConfig.showIDs()) {
            mainname = mainname + " " + Item.func_150891_b((Item)stack.func_77973_b());
            if (stack.func_77960_j() != 0) {
                mainname = mainname + ":" + stack.func_77960_j();
            }
            currenttip.set(0, mainname);
        }
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled() && GuiContainerManager.shouldShowTooltip(gui)) {
            for (IContainerTooltipHandler tip : tooltipWidgets) {
                currenttip = tip.handleItemDisplayName(gui, stack, currenttip);
            }
        }
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled() && GuiContainerManager.shouldShowTooltip(gui)) {
            for (IContainerTooltipHandler tip : tooltipWidgets) {
                currenttip = tip.handleItemTooltip(gui, itemstack, mousex, mousey, currenttip);
            }
        }
        return currenttip;
    }

    @Override
    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled() && GuiContainerManager.shouldShowTooltip(gui)) {
            for (IContainerTooltipHandler tip : tooltipWidgets) {
                hotkeys = tip.handleHotkeys(gui, mousex, mousey, hotkeys);
            }
        }
        return hotkeys;
    }

    public static void layout(GuiContainer gui) {
        VisiblityData visiblity = new VisiblityData();
        if (NEIClientConfig.isHidden()) {
            visiblity.showNEI = false;
        }
        if (NEIClientConfig.isBookmarkPanelHidden()) {
            visiblity.showBookmarkPanel = false;
        }
        if (gui.field_146295_m - gui.field_147000_g <= 40 && NEIClientConfig.isSearchWidgetCentered()) {
            visiblity.showSearchSection = false;
        }
        if (visiblity.showBookmarkPanel || gui.field_147009_r <= 20) {
            visiblity.showSubsetDropdown = false;
        }
        if (gui.field_147003_i - 4 < 76) {
            visiblity.showWidgets = false;
        }
        try {
            GuiInfo.readLock.lock();
            GuiInfo.guiHandlers.forEach(handler -> handler.modifyVisiblity(gui, visiblity));
        }
        finally {
            GuiInfo.readLock.unlock();
        }
        visiblity.translateDependancies();
        LayoutManager.getLayoutStyle().layout(gui, visiblity);
        LayoutManager.updateWidgetVisiblities(gui, visiblity);
    }

    private static void init() {
        itemPanel = ItemPanels.itemPanel;
        itemPanel.init();
        bookmarkPanel = ItemPanels.bookmarkPanel;
        bookmarkPanel.init();
        itemZoom = new ItemZoom();
        dropDown = new SubsetWidget();
        searchField = new SearchField("search");
        API.addItemFilter(searchField);
        options = new ButtonCycled(3){

            @Override
            public void init() {
                this.icons[0] = new DrawableBuilder("nei:textures/nei_tabbed_sprites.png", 32, 0, 16, 16).build();
                this.icons[1] = new DrawableBuilder("nei:textures/nei_tabbed_sprites.png", 48, 0, 16, 16).build();
                this.icons[2] = new DrawableBuilder("nei:textures/nei_tabbed_sprites.png", 64, 0, 16, 16).build();
            }

            private boolean getIsAccessibleControlEventKey() {
                if (Minecraft.field_142025_a) {
                    return Keyboard.getEventKey() == 219 || Keyboard.getEventKey() == 220;
                }
                return Keyboard.getEventKey() == 29 || Keyboard.getEventKey() == 157;
            }

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    if (Keyboard.getEventKeyState() && this.getIsAccessibleControlEventKey() && NEIClientConfig.canChangeCheatMode()) {
                        NEIClientConfig.cycleSetting("inventory.cheatmode", 3);
                    } else {
                        if (Keyboard.getEventKeyState() && (Keyboard.getEventKey() == 42 || Keyboard.getEventKey() == 54)) {
                            GuiRecipeTab.loadHandlerInfo();
                            RecipeCatalysts.loadCatalystInfo();
                        }
                        NEIClientConfig.getOptionList().openGui((GuiScreen)NEIClientUtils.getGuiContainer(), false);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public void addTooltips(List<String> tooltip) {
                tooltip.add(NEIClientUtils.translate("inventory.options.tip", new Object[0]));
                String modeColor = "";
                int cheatMode = NEIClientConfig.getCheatMode();
                if (cheatMode == 1) {
                    modeColor = EnumChatFormatting.GOLD.toString();
                } else if (cheatMode == 2) {
                    modeColor = EnumChatFormatting.RED.toString();
                }
                String controlKeyLocalization = NEIClientUtils.translate(Minecraft.field_142025_a ? "key.ctrl.mac" : "key.ctrl", new Object[0]);
                tooltip.add(modeColor + NEIClientUtils.translate("inventory.options.tip.cheatmode." + cheatMode, new Object[0]));
                if (NEIClientConfig.canChangeCheatMode()) {
                    tooltip.add(modeColor + NEIClientUtils.translate("inventory.options.tip.cheatmode.disable", controlKeyLocalization));
                }
            }

            @Override
            public String getRenderLabel() {
                return NEIClientUtils.translate("inventory.options", new Object[0]);
            }
        };
        bookmarksButton = new ButtonCycled(2){

            @Override
            public void init() {
                this.icons[0] = new DrawableBuilder("nei:textures/nei_tabbed_sprites.png", 0, 0, 16, 16).build();
                this.icons[1] = new DrawableBuilder("nei:textures/nei_tabbed_sprites.png", 16, 0, 16, 16).build();
            }

            @Override
            public boolean onButtonPress(boolean rightclick) {
                NEIClientConfig.toggleBooleanSetting("inventory.bookmarks.enabled");
                return true;
            }

            @Override
            public String getButtonTip() {
                return NEIClientUtils.translate("bookmark.toggle.tip", new Object[0]);
            }

            @Override
            public String getRenderLabel() {
                return NEIClientUtils.translate("bookmark.toggle", new Object[0]);
            }
        };
        more = ItemPanels.itemPanel.more;
        less = ItemPanels.itemPanel.less;
        quantity = ItemPanels.itemPanel.quantity;
        delete = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if ((this.state & 3) == 2) {
                    return false;
                }
                ItemStack held = NEIClientUtils.getHeldItem();
                if (held != null) {
                    if (NEIClientUtils.shiftKey()) {
                        NEIClientUtils.deleteHeldItem();
                        NEIClientUtils.deleteItemsOfType(held);
                    } else if (rightclick) {
                        NEIClientUtils.decreaseSlotStack(-999);
                    } else {
                        NEIClientUtils.deleteHeldItem();
                    }
                } else if (NEIClientUtils.shiftKey()) {
                    NEIClientUtils.deleteEverything();
                } else {
                    NEIController.toggleDeleteMode();
                }
                return true;
            }

            @Override
            public String getButtonTip() {
                if ((this.state & 3) != 2) {
                    if (NEIClientUtils.shiftKey()) {
                        return NEIClientUtils.translate("inventory.delete.inv", new Object[0]);
                    }
                    if (NEIController.canUseDeleteMode()) {
                        return LayoutManager.getStateTip("delete", this.state);
                    }
                }
                return null;
            }

            @Override
            public void postDraw(int mousex, int mousey) {
                if (this.contains(mousex, mousey) && NEIClientUtils.getHeldItem() != null && (this.state & 3) != 2) {
                    GuiDraw.drawTip((int)(mousex + 9), (int)mousey, (String)NEIClientUtils.translate("inventory.delete." + (NEIClientUtils.shiftKey() ? "all" : "one"), GuiContainerManager.itemDisplayNameShort(NEIClientUtils.getHeldItem())));
                }
            }
        };
        gamemode = new ButtonCycled(3){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.cycleGamemode();
                    return true;
                }
                return false;
            }

            @Override
            public void addTooltips(List<String> tooltip) {
                tooltip.add(NEIClientUtils.translate("inventory.current.gamemode." + NEIClientUtils.getGamemode(), new Object[0]));
                tooltip.add(EnumChatFormatting.GRAY + NEIClientUtils.translate("inventory.gamemode." + NEIClientUtils.getNextGamemode(), new Object[0]));
            }
        };
        rain = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (LayoutManager.handleDisabledButtonPress("rain", rightclick)) {
                    return true;
                }
                if (!rightclick) {
                    NEIClientUtils.toggleRaining();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return LayoutManager.getStateTip("rain", this.state);
            }
        };
        magnet = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.toggleMagnetMode();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return LayoutManager.getStateTip("magnet", this.state);
            }
        };
        for (int i = 0; i < 4; ++i) {
            final int zone = i;
            LayoutManager.timeButtons[i] = new Button(){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (LayoutManager.handleDisabledButtonPress(NEIActions.timeZones[zone], rightclick)) {
                        return true;
                    }
                    if (!rightclick) {
                        NEIClientUtils.setHourForward(zone * 6);
                        return true;
                    }
                    return false;
                }

                @Override
                public void addTooltips(List<String> tooltip) {
                    LayoutManager.addTimeTip(NEIActions.timeZones[zone], this.state, tooltip);
                }
            };
        }
        heal = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.healPlayer();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return NEIClientUtils.translate("inventory.heal", new Object[0]);
            }
        };
        LayoutManager.delete.state |= 4;
        LayoutManager.gamemode.state |= 4;
        LayoutManager.rain.state |= 4;
        LayoutManager.magnet.state |= 4;
    }

    private static String getStateTip(String name, int state) {
        String sfx = (state & 3) == 2 ? "enable" : ((state & 3) == 1 ? "0" : "1");
        return NEIClientUtils.translate("inventory." + name + "." + sfx, new Object[0]);
    }

    private static void addTimeTip(String name, int state, List<String> tooltip) {
        if ((state & 3) == 2) {
            tooltip.add(NEIClientUtils.translate("inventory." + name + ".enable", new Object[0]));
        } else {
            tooltip.add(NEIClientUtils.translate("inventory." + name + ".set", new Object[0]));
            tooltip.add(EnumChatFormatting.GRAY + NEIClientUtils.translate("inventory." + name + ".disable", new Object[0]));
        }
    }

    private static boolean handleDisabledButtonPress(String ident, boolean rightclick) {
        if (!NEIActions.canDisable.contains(ident)) {
            return false;
        }
        if (rightclick != NEIClientConfig.disabledActions.contains(ident)) {
            return LayoutManager.setPropertyDisabled(ident, rightclick);
        }
        return false;
    }

    private static boolean setPropertyDisabled(String ident, boolean disable) {
        if (disable && NEIActions.base(ident).equals("time")) {
            int count = 0;
            for (int i = 0; i < 4; ++i) {
                if (!NEIClientConfig.disabledActions.contains(NEIActions.timeZones[i])) continue;
                ++count;
            }
            if (count == 3) {
                return false;
            }
        }
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendSetPropertyDisabled(ident, disable);
        }
        return true;
    }

    public static void markItemsDirty() {
        itemsLoaded = false;
    }

    @Override
    public void load(GuiContainer gui) {
        if (NEIClientConfig.isEnabled()) {
            LayoutManager.setInputFocused(null);
            if (!itemsLoaded && NEIClientConfig.isLoaded()) {
                ItemList.loadItems.restart();
            }
            overlayRenderer = null;
            LayoutManager.getLayoutStyle().init();
            LayoutManager.layout(gui);
            AutoFocusWidget.instance.load(gui);
        }
        NEIController.load(gui);
        if (this.checkCreativeInv(gui) && gui.field_146297_k.field_71462_r instanceof GuiContainerCreative) {
            gui.field_146297_k.func_147108_a(null);
        }
    }

    @Override
    public void refresh(GuiContainer gui) {
    }

    public boolean checkCreativeInv(GuiContainer gui) {
        if (gui instanceof GuiContainerCreative && NEIClientConfig.invCreativeMode()) {
            NEICPH.sendCreativeInv(true);
            return true;
        }
        if (gui instanceof GuiExtendedCreativeInv && !NEIClientConfig.invCreativeMode()) {
            NEICPH.sendCreativeInv(false);
            return true;
        }
        return false;
    }

    public static void updateWidgetVisiblities(GuiContainer gui, VisiblityData visiblity) {
        drawWidgets = new TreeSet<Widget>(new WidgetZOrder(false));
        controlWidgets = new TreeSet<Widget>(new WidgetZOrder(true));
        tooltipWidgets.clear();
        if (!visiblity.showNEI) {
            return;
        }
        LayoutManager.addWidget(options);
        LayoutManager.addWidget(bookmarksButton);
        if (visiblity.showItemPanel) {
            LayoutManager.addWidget(itemPanel);
            itemPanel.setVisible();
        }
        if (visiblity.showBookmarkPanel) {
            LayoutManager.addWidget(bookmarkPanel);
            bookmarkPanel.setVisible();
        }
        searchField.setVisible(visiblity.showSearchSection);
        if (visiblity.showSearchSection) {
            LayoutManager.addWidget(searchField);
        }
        if (visiblity.showUtilityButtons) {
            if (NEIClientConfig.canPerformAction("time")) {
                for (int i = 0; i < 4; ++i) {
                    LayoutManager.addWidget(timeButtons[i]);
                }
            }
            if (NEIClientConfig.canPerformAction("rain")) {
                LayoutManager.addWidget(rain);
            }
            if (NEIClientConfig.canPerformAction("heal")) {
                LayoutManager.addWidget(heal);
            }
            if (NEIClientConfig.canPerformAction("magnet")) {
                LayoutManager.addWidget(magnet);
            }
            if (NEIClientUtils.isValidGamemode("creative") || NEIClientUtils.isValidGamemode("creative+") || NEIClientUtils.isValidGamemode("adventure")) {
                LayoutManager.addWidget(gamemode);
            }
            if (NEIClientConfig.canPerformAction("delete")) {
                LayoutManager.addWidget(delete);
            }
        }
        LayoutManager.addWidget(itemZoom);
        if (visiblity.showSubsetDropdown) {
            LayoutManager.addWidget(dropDown);
        }
    }

    public static LayoutStyle getLayoutStyle(int id) {
        LayoutStyle style = layoutStyles.get(id);
        if (style == null) {
            style = layoutStyles.get(0);
        }
        return style;
    }

    public static LayoutStyle getLayoutStyle() {
        return LayoutManager.getLayoutStyle(0);
    }

    public static void addWidget(Widget widget) {
        drawWidgets.add(widget);
        controlWidgets.add(widget);
        if (widget instanceof IContainerTooltipHandler) {
            tooltipWidgets.add((IContainerTooltipHandler)((Object)widget));
        }
    }

    @Override
    public void guiTick(GuiContainer gui) {
        if (this.checkCreativeInv(gui)) {
            return;
        }
        if (!NEIClientConfig.isEnabled()) {
            return;
        }
        for (Widget widget : drawWidgets) {
            widget.update();
        }
    }

    @Override
    public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        if (NEIClientConfig.isHidden() || !NEIClientConfig.isEnabled()) {
            return false;
        }
        for (Widget widget : drawWidgets) {
            if (!widget.onMouseWheel(scrolled, mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
    }

    @Override
    public boolean shouldShowTooltip(GuiContainer gui) {
        return LayoutManager.itemPanel.draggedStack == null && !bookmarkPanel.inEditingState();
    }

    public static Widget getInputFocused() {
        return inputFocused;
    }

    public static void setInputFocused(Widget widget) {
        if (inputFocused != null) {
            inputFocused.loseFocus();
        }
        if ((inputFocused = widget) != null) {
            inputFocused.gainFocus();
        }
    }

    @Override
    public void renderSlotUnderlay(GuiContainer gui, Slot slot) {
        if (overlayRenderer != null) {
            overlayRenderer.renderOverlay(GuiContainerManager.getManager(gui), slot);
        }
    }

    @Override
    public void renderSlotOverlay(GuiContainer window, Slot slot) {
        ItemStack item;
        if (SearchField.searchInventories() && ((item = slot.func_75211_c()) == null ? !NEIClientConfig.getSearchExpression().equals("") : !searchField.getFilter().matches(item))) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)150.0f);
            GuiDraw.drawRect((int)slot.field_75223_e, (int)slot.field_75221_f, (int)16, (int)16, (int)Integer.MIN_VALUE);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-150.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
    }

    public static void drawIcon(int x, int y, Image image) {
        boolean isDrawableResource = image instanceof DrawableResource;
        if (!isDrawableResource) {
            GuiDraw.changeTexture((String)"nei:textures/nei_sprites.png");
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (!isDrawableResource) {
            GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)image.x, (int)image.y, (int)image.width, (int)image.height);
        } else {
            ((DrawableResource)image).draw(x, y);
        }
        GL11.glDisable((int)3042);
    }

    public static void drawButtonBackground(int x, int y, int w, int h, boolean edges, int type) {
        int wTiles = 0;
        int ew = w;
        if (w / 2 > 100) {
            wTiles = (w - 200) / 50 + 1;
            ew = 200;
        }
        int w1 = ew / 2;
        int h1 = h / 2;
        int w2 = (ew + 1) / 2;
        int h2 = (h + 1) / 2;
        int x2 = x + w - w2;
        int y2 = y + h - h2;
        int ty = 46 + type * 20;
        int te = edges ? 0 : 1;
        int ty1 = ty + te;
        int tx1 = te;
        int tx3 = 75;
        int ty2 = ty + 20 - h2 - te;
        int tx2 = 200 - w2 - te;
        GuiDraw.changeTexture((String)"textures/gui/widgets.png");
        GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)tx1, (int)ty1, (int)w1, (int)h1);
        GuiDraw.drawTexturedModalRect((int)x, (int)y2, (int)tx1, (int)ty2, (int)w1, (int)h2);
        for (int tile = 0; tile < wTiles; ++tile) {
            int tileX = x + w1 + 50 * tile;
            GuiDraw.drawTexturedModalRect((int)tileX, (int)y, (int)75, (int)ty1, (int)50, (int)h1);
            GuiDraw.drawTexturedModalRect((int)tileX, (int)y2, (int)75, (int)ty2, (int)50, (int)h2);
        }
        GuiDraw.drawTexturedModalRect((int)x2, (int)y, (int)tx2, (int)ty1, (int)w2, (int)h1);
        GuiDraw.drawTexturedModalRect((int)x2, (int)y2, (int)tx2, (int)ty2, (int)w2, (int)h2);
    }

    public static void drawItemPresenceOverlay(int slotX, int slotY, boolean isPresent, boolean slotHighlight) {
        if (slotHighlight) {
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GuiDraw.drawRect((int)slotX, (int)slotY, (int)16, (int)16, (int)(isPresent ? -2147440128 : -2136342528));
            GL11.glPopAttrib();
        } else {
            Image icon = itemPresenceOverlays[isPresent ? 1 : 0];
            LayoutManager.drawIcon(slotX + 16 - icon.width, slotY + 16 - icon.height, icon);
        }
    }

    public static LayoutManager instance() {
        return instance;
    }

    @Override
    public void tickKeyStates() {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (KeyManager.keyStates.get((Object)"world.dawn").down) {
            timeButtons[0].onButtonPress(false);
        }
        if (KeyManager.keyStates.get((Object)"world.noon").down) {
            timeButtons[1].onButtonPress(false);
        }
        if (KeyManager.keyStates.get((Object)"world.dusk").down) {
            timeButtons[2].onButtonPress(false);
        }
        if (KeyManager.keyStates.get((Object)"world.midnight").down) {
            timeButtons[3].onButtonPress(false);
        }
        if (KeyManager.keyStates.get((Object)"world.rain").down) {
            rain.onButtonPress(false);
        }
        if (KeyManager.keyStates.get((Object)"world.heal").down) {
            heal.onButtonPress(false);
        }
        if (KeyManager.keyStates.get((Object)"world.creative").down) {
            gamemode.onButtonPress(false);
        }
    }

    static {
        drawWidgets = new TreeSet<Widget>(new WidgetZOrder(false));
        controlWidgets = new TreeSet<Widget>(new WidgetZOrder(true));
        tooltipWidgets = new LinkedList<IContainerTooltipHandler>();
        timeButtons = new Button[4];
        layoutStyles = new HashMap();
        itemsLoaded = false;
        itemPresenceOverlays = new Image[2];
    }
}

