/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.ReadableNumberConverter;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class ItemsTooltipLineHandler
implements GuiDraw.ITooltipLineHandler {
    protected static int MAX_COLUMNS = 11;
    protected static int MARGIN_TOP = 2;
    protected String label;
    protected EnumChatFormatting labelColor = EnumChatFormatting.GRAY;
    protected List<ItemStack> items;
    protected Dimension size = new Dimension();
    protected boolean saveStackSize = false;
    protected int columns = 0;
    protected int count = 0;
    protected int rows = 0;
    protected int length = 0;

    public ItemsTooltipLineHandler(String label, List<ItemStack> items, boolean saveStackSize) {
        this(label, items, true, 5);
    }

    public ItemsTooltipLineHandler(String label, List<ItemStack> items, boolean saveStackSize, int maxRows) {
        this.label = label;
        this.items = this.groupingItemStacks(items);
        this.saveStackSize = saveStackSize;
        this.length = this.items.size();
        if (this.length > 0) {
            this.columns = Math.min(MAX_COLUMNS, this.length);
            this.rows = Math.min(maxRows, (int)Math.ceil((float)this.length / (float)this.columns));
            this.size.width = Math.max(this.columns * 18, GuiDraw.fontRenderer.func_78256_a(this.label) + 15);
            this.size.height = this.rows * 18 + GuiDraw.fontRenderer.field_78288_b + 2 + MARGIN_TOP;
            this.count = Math.min(this.length, Math.min(this.columns * this.rows, this.length > MAX_COLUMNS * maxRows ? MAX_COLUMNS * maxRows - 1 : Integer.MAX_VALUE));
        }
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setLabelColor(EnumChatFormatting color) {
        this.labelColor = color;
    }

    public void draw(int x, int y) {
        if (this.length == 0) {
            return;
        }
        GuiDraw.fontRenderer.func_78261_a(this.labelColor + this.label + ":", x, y += MARGIN_TOP, 0);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glScaled((double)1.0, (double)1.0, (double)3.0);
        GL11.glTranslatef((float)x, (float)(y + GuiDraw.fontRenderer.field_78288_b + 2), (float)0.0f);
        GL11.glEnable((int)32826);
        for (int i = 0; i < this.count; ++i) {
            ItemStack drawStack = this.items.get(i);
            int col = i % this.columns;
            int row = i / this.columns;
            String stackSize = !this.saveStackSize || drawStack.field_77994_a == 0 ? "" : ReadableNumberConverter.INSTANCE.toWideReadableForm(drawStack.field_77994_a);
            GuiContainerManager.drawItem(col * 18, row * 18, drawStack, true, stackSize);
        }
        if (this.count < this.items.size()) {
            GuiDraw.fontRenderer.func_78261_a("+" + (this.items.size() - this.count), (this.columns - 1) * 18, (this.rows - 1) * 18 + (18 - GuiDraw.fontRenderer.field_78288_b) / 2 - 1, -296397483);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private List<ItemStack> groupingItemStacks(List<ItemStack> items) {
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        LinkedHashMap<String, NBTTagCompound> unique = new LinkedHashMap<String, NBTTagCompound>();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : items) {
            NBTTagCompound nbTag = StackInfo.itemStackToNBT(stack, true);
            String GUID = StackInfo.getItemStackGUID(stack);
            if (!unique.containsKey(GUID)) {
                count.put(GUID, nbTag.func_74762_e("Count"));
                unique.put(GUID, nbTag);
                continue;
            }
            count.put(GUID, (Integer)count.get(GUID) + nbTag.func_74762_e("Count"));
        }
        for (String GUID : unique.keySet()) {
            ItemStack stack = StackInfo.loadFromNBT((NBTTagCompound)unique.get(GUID), ((Integer)count.get(GUID)).intValue());
            if (((NBTTagCompound)unique.get(GUID)).func_74764_b("gtFluidName")) {
                stack.field_77994_a = 0;
            }
            result.add(stack);
        }
        return result;
    }
}

