/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.thermalexpansion.util.crafting.PulverizerManager;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thermalexpansion.ThermalHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Pulverizer")
public class Pulverizer {
    public static final String name = "Thermal Expansion Pulverizer";

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack output) {
        Pulverizer.addRecipe(energy, input, output, null, 0);
    }

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack output, @Optional IItemStack secondary, @Optional int secondaryChance) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (PulverizerManager.recipeExists((ItemStack)InputHelper.toStack(input))) {
            LogHelper.logWarning(String.format("Duplicate %s Recipe found for %s. Command ignored!", name, LogHelper.getStackDescription(InputHelper.toStack(input))));
            return;
        }
        PulverizerManager.RecipePulverizer recipe = ReflectionHelper.getInstance(ThermalHelper.pulverizerRecipe, InputHelper.toStack(input), InputHelper.toStack(output), InputHelper.toStack(secondary), secondaryChance, energy);
        if (recipe != null) {
            MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
        } else {
            LogHelper.logError(String.format("Error while creating instance for %s recipe.", name));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        PulverizerManager.RecipePulverizer[] list;
        LinkedList<PulverizerManager.RecipePulverizer> recipes = new LinkedList<PulverizerManager.RecipePulverizer>();
        for (PulverizerManager.RecipePulverizer recipe : list = PulverizerManager.getRecipeList()) {
            if (recipe == null || recipe.getInput() == null || !StackHelper.matches(input, InputHelper.toIItemStack(recipe.getInput()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s.", name, input.toString()));
        }
    }

    @ZenMethod
    public static void refreshRecipes() {
        MineTweakerAPI.apply((IUndoableAction)new Refresh());
    }

    private static class Refresh
    implements IUndoableAction {
        private Refresh() {
        }

        public void apply() {
            PulverizerManager.refreshRecipes();
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Refreshing Thermal Expansion Pulverizer recipes";
        }

        public void undo() {
        }

        public String describeUndo() {
            return "Ignoring undo of Thermal Expansion Pulverizer recipe refresh";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    extends BaseListRemoval<PulverizerManager.RecipePulverizer> {
        public Remove(List<PulverizerManager.RecipePulverizer> recipes) {
            super(Pulverizer.name, null, recipes);
        }

        @Override
        public void apply() {
            for (PulverizerManager.RecipePulverizer recipe : this.recipes) {
                boolean removed = PulverizerManager.removeRecipe((ItemStack)recipe.getInput());
                if (!removed) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (PulverizerManager.RecipePulverizer recipe : this.successful) {
                PulverizerManager.addRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getInput(), (ItemStack)recipe.getPrimaryOutput(), (ItemStack)recipe.getSecondaryOutput(), (int)recipe.getSecondaryOutputChance());
            }
        }

        @Override
        protected boolean equals(PulverizerManager.RecipePulverizer recipe, PulverizerManager.RecipePulverizer otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        protected String getRecipeInfo(PulverizerManager.RecipePulverizer recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }

    private static class Add
    extends BaseListAddition<PulverizerManager.RecipePulverizer> {
        public Add(PulverizerManager.RecipePulverizer recipe) {
            super(Pulverizer.name, null);
            this.recipes.add(recipe);
        }

        @Override
        public void apply() {
            for (PulverizerManager.RecipePulverizer recipe : this.recipes) {
                boolean applied = PulverizerManager.addRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getInput(), (ItemStack)recipe.getPrimaryOutput(), (ItemStack)recipe.getSecondaryOutput(), (int)recipe.getSecondaryOutputChance());
                if (!applied) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (PulverizerManager.RecipePulverizer recipe : this.successful) {
                PulverizerManager.removeRecipe((ItemStack)recipe.getInput());
            }
        }

        @Override
        protected boolean equals(PulverizerManager.RecipePulverizer recipe, PulverizerManager.RecipePulverizer otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        protected String getRecipeInfo(PulverizerManager.RecipePulverizer recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }
}

