/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.botania.handlers;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.oredict.IOreDictEntry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;

@ZenClass(value="mods.botania.Orechid")
public class Orechid {
    @ZenMethod
    public static void addOre(IOreDictEntry oreDict, int weight) {
        MineTweakerAPI.apply((IUndoableAction)new Add(oreDict.getName(), weight));
    }

    @ZenMethod
    public static void addOre(String oreDict, int weight) {
        MineTweakerAPI.apply((IUndoableAction)new Add(oreDict, weight));
    }

    @ZenMethod
    public static void removeOre(IOreDictEntry oreDict) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(oreDict.getName()));
    }

    @ZenMethod
    public static void removeOre(String oreDict) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(oreDict));
    }

    private static class Remove
    implements IUndoableAction {
        String oreDict;
        int weight;

        public Remove(String ore) {
            this.oreDict = ore;
        }

        public void apply() {
            this.weight = BotaniaAPI.getOreWeight((String)this.oreDict);
            BotaniaAPI.oreWeights.remove(this.oreDict);
        }

        public String describe() {
            return "Removing Orechid Ore: " + this.oreDict;
        }

        public boolean canUndo() {
            return this.weight > 0;
        }

        public void undo() {
            BotaniaAPI.addOreWeight((String)this.oreDict, (int)this.weight);
        }

        public String describeUndo() {
            return "Restoring Orechid Ore Weight: " + this.oreDict + ":" + this.weight;
        }

        public String getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        String oreDict;
        int weight;

        public Add(String ore, int prop) {
            this.oreDict = ore;
            this.weight = prop;
        }

        public void apply() {
            BotaniaAPI.addOreWeight((String)this.oreDict, (int)this.weight);
        }

        public String describe() {
            return "Adding Orechid Ore Weight: " + this.oreDict + ":" + this.weight;
        }

        public boolean canUndo() {
            return this.oreDict != null;
        }

        public void undo() {
            BotaniaAPI.oreWeights.remove(this.oreDict);
        }

        public String describeUndo() {
            return "Removing Orechid Ore: " + this.oreDict;
        }

        public String getOverrideKey() {
            return null;
        }
    }
}

