/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.TileEntityIronChest;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockIronChest
extends BlockContainer {
    private final Random random;
    @SideOnly(value=Side.CLIENT)
    private IIcon[][] icons;
    private static final ForgeDirection[] validRotationAxes = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};

    public BlockIronChest() {
        super(Material.field_151573_f);
        this.func_149663_c("IronChest");
        this.func_149711_c(3.0f);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        this.random = new Random();
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public TileEntity func_149915_a(World w, int i) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 22;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return IronChestType.makeEntity(metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int i, int j) {
        if (j < IronChestType.values().length) {
            IronChestType type = IronChestType.values()[j];
            return type.getIcon(i);
        }
        return null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList items = Lists.newArrayList();
        ItemStack stack = new ItemStack((Block)this, 1, metadata);
        IronChestType.values()[IronChestType.validateMeta(metadata)].adornItemDrop(stack);
        items.add(stack);
        return items;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int i1, float f1, float f2, float f3) {
        TileEntity te = world.func_147438_o(i, j, k);
        if (!(te instanceof TileEntityIronChest)) {
            return true;
        }
        if (world.isSideSolid(i, j + 1, k, ForgeDirection.DOWN)) {
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)IronChest.instance, ((TileEntityIronChest)te).getType().ordinal(), world, i, j, k);
        return true;
    }

    public void func_149726_b(World world, int i, int j, int k) {
        super.func_149726_b(world, i, j, k);
        world.func_147471_g(i, j, k);
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack itemStack) {
        TileEntity te;
        int chestFacing = 0;
        int facing = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (facing == 0) {
            chestFacing = 2;
        }
        if (facing == 1) {
            chestFacing = 5;
        }
        if (facing == 2) {
            chestFacing = 3;
        }
        if (facing == 3) {
            chestFacing = 4;
        }
        if ((te = world.func_147438_o(i, j, k)) instanceof TileEntityIronChest) {
            TileEntityIronChest teic = (TileEntityIronChest)te;
            teic.wasPlaced(entityliving, itemStack);
            teic.setFacing(chestFacing);
            world.func_147471_g(i, j, k);
        }
    }

    public int func_149692_a(int i) {
        return i;
    }

    public void func_149749_a(World world, int i, int j, int k, Block i1, int i2) {
        TileEntityIronChest tileentitychest = (TileEntityIronChest)world.func_147438_o(i, j, k);
        if (tileentitychest != null) {
            tileentitychest.removeAdornments();
            this.dropContent(0, tileentitychest, world, tileentitychest.field_145851_c, tileentitychest.field_145848_d, tileentitychest.field_145849_e);
        }
        super.func_149749_a(world, i, j, k, i1, i2);
    }

    public void dropContent(int newSize, IInventory chest, World world, int xCoord, int yCoord, int zCoord) {
        for (int l = newSize; l < chest.func_70302_i_(); ++l) {
            ItemStack itemstack = chest.func_70301_a(l);
            if (itemstack == null) continue;
            float f = this.random.nextFloat() * 0.8f + 0.1f;
            float f1 = this.random.nextFloat() * 0.8f + 0.1f;
            float f2 = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int i1 = this.random.nextInt(21) + 10;
                if (i1 > itemstack.field_77994_a) {
                    i1 = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= i1;
                EntityItem entityitem = new EntityItem(world, (double)((float)xCoord + f), (double)((float)yCoord + (float)(newSize > 0 ? 1 : 0) + f1), (double)((float)zCoord + f2), new ItemStack(itemstack.func_77973_b(), i1, itemstack.func_77960_j()));
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (IronChestType type : IronChestType.values()) {
            if (!type.isValidForCreativeMode() || !type.isEnabled()) continue;
            par3List.add(new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TileEntityIronChest teic;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityIronChest && (teic = (TileEntityIronChest)te).getType().isExplosionResistant()) {
            return 10000.0f;
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World par1World, int par2, int par3, int par4, int par5) {
        TileEntity te = par1World.func_147438_o(par2, par3, par4);
        if (te instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)te));
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        for (IronChestType typ : IronChestType.values()) {
            typ.makeIcons(par1IconRegister);
        }
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return validRotationAxes;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        if (worldObj.field_72995_K) {
            return false;
        }
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            TileEntity tileEntity = worldObj.func_147438_o(x, y, z);
            if (tileEntity instanceof TileEntityIronChest) {
                TileEntityIronChest icte = (TileEntityIronChest)tileEntity;
                icte.rotateAround(axis);
            }
            return true;
        }
        return false;
    }
}

