/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.modifiers;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import org.apache.logging.log4j.Level;

public abstract class MobModifier {
    @Nullable
    protected final MobModifier nextMod;
    private final String modName;
    private boolean healthHacked;
    private float actualHealth;
    private String[] bufferedNames;
    private float actualMaxHealth;
    private EntityLivingBase attackTarget;
    private int bufferedSize;
    private String bufferedEntityName;

    public MobModifier(String name, @Nullable MobModifier next) {
        this.nextMod = next;
        this.healthHacked = false;
        this.actualHealth = 100.0f;
        this.actualMaxHealth = -1.0f;
        this.bufferedSize = 0;
        this.modName = name;
    }

    public String getLinkedModName() {
        return StatCollector.func_74838_a((String)("translation.infernalmobs:mod." + this.modName)) + " " + (this.nextMod != null ? this.nextMod.getLinkedModName() : "");
    }

    public String getLinkedModNameUntranslated() {
        return this.modName + " " + (this.nextMod != null ? this.nextMod.getLinkedModNameUntranslated() : "");
    }

    public String[] getDisplayNames() {
        if (this.bufferedNames == null) {
            String[] allMods = this.getLinkedModName().split(" ");
            int index = 0;
            int j = 0;
            this.bufferedNames = new String[3];
            this.bufferedNames[index] = "";
            for (String m : allMods) {
                this.bufferedNames[index] = this.bufferedNames[index] + " " + m;
                if (++j % 5 != 0 || index + 1 >= this.bufferedNames.length) continue;
                this.bufferedNames[++index] = "";
            }
        }
        return this.bufferedNames;
    }

    public boolean containsModifierClass(Class<?> checkfor) {
        if (checkfor.equals(this.getClass())) {
            return true;
        }
        if (this.nextMod != null) {
            return this.nextMod.containsModifierClass(checkfor);
        }
        return false;
    }

    public void onSpawningComplete(EntityLivingBase entity) {
        String oldTag = entity.getEntityData().func_74779_i(InfernalMobsCore.getNBTTag());
        if (!oldTag.isEmpty() && !oldTag.equals(this.getLinkedModNameUntranslated())) {
            FMLLog.log((String)"InfernalMobs", (Level)Level.DEBUG, (String)String.format("Infernal Mobs tag mismatch!! Was [%s], now trying to set [%s] \n", oldTag, this.getLinkedModNameUntranslated()), (Object[])new Object[0]);
        }
        entity.getEntityData().func_74778_a(InfernalMobsCore.getNBTTag(), this.getLinkedModNameUntranslated());
    }

    public boolean onDeath() {
        this.attackTarget = null;
        if (this.nextMod != null) {
            return this.nextMod.onDeath();
        }
        return false;
    }

    public void onDropItems(EntityLivingBase moddedMob, DamageSource killSource, ArrayList<EntityItem> drops, int lootingLevel, boolean recentlyHit, int specialDropValue) {
        if (recentlyHit) {
            InfernalMobsCore.instance().dropLootForEnt(moddedMob, this);
        }
    }

    public void onSetAttackTarget(EntityLivingBase target) {
        this.attackTarget = target;
        if (this.nextMod != null) {
            this.nextMod.onSetAttackTarget(target);
        }
    }

    public float onAttack(EntityLivingBase entity, DamageSource source, float amount) {
        if (this.nextMod != null) {
            return this.nextMod.onAttack(entity, source, amount);
        }
        return amount;
    }

    public float onHurt(EntityLivingBase mob, DamageSource source, float amount) {
        if (this.nextMod != null) {
            amount = this.nextMod.onHurt(mob, source, amount);
        } else if (source.func_76346_g() != null && source.func_76346_g().field_70170_p.field_72995_K && source.func_76346_g() instanceof EntityPlayer) {
            InfernalMobsCore.instance().sendHealthRequestPacket(mob);
        }
        return amount;
    }

    public boolean onFall(float distance) {
        if (this.nextMod != null) {
            return this.nextMod.onFall(distance);
        }
        return false;
    }

    public void onJump(EntityLivingBase entityLiving) {
        if (this.nextMod != null) {
            this.nextMod.onJump(entityLiving);
        }
    }

    public boolean onUpdate(EntityLivingBase mob) {
        if (this.nextMod != null) {
            return this.nextMod.onUpdate(mob);
        }
        if (this.attackTarget == null && mob instanceof EntityMob && ((EntityMob)mob).func_70777_m() instanceof EntityLivingBase) {
            this.attackTarget = (EntityLivingBase)((EntityMob)mob).func_70777_m();
        }
        if (this.attackTarget != null && (this.attackTarget.field_70128_L || this.attackTarget.func_70032_d((Entity)mob) > 15.0f || this.attackTarget instanceof EntityPlayer && ((EntityPlayer)this.attackTarget).field_71075_bZ.field_75102_a)) {
            this.attackTarget = null;
        }
        return false;
    }

    public float getActualHealth(EntityLivingBase mob) {
        if (!mob.field_70170_p.field_72995_K) {
            this.increaseHealthForMob(mob, this.getActualMaxHealth(mob));
        }
        return this.actualHealth;
    }

    public void setHealthAlreadyHacked(EntityLivingBase mob) {
        if (!mob.field_70170_p.field_72995_K) {
            this.actualMaxHealth = this.getActualMaxHealth(mob);
            this.healthHacked = true;
        }
    }

    private void increaseHealthForMob(EntityLivingBase mob, float baseHealth) {
        if (!this.healthHacked) {
            this.actualHealth = this.actualMaxHealth = this.getActualMaxHealth(mob);
            InfernalMobsCore.instance().setEntityHealthPastMax(mob, this.actualHealth);
            this.healthHacked = true;
        }
    }

    public float getActualMaxHealth(EntityLivingBase mob) {
        if (this.actualMaxHealth < 0.0f) {
            this.actualMaxHealth = (float)((double)(InfernalMobsCore.instance().getMobClassMaxHealth(mob) * (float)this.getModSize()) * InfernalMobsCore.instance().getMobModHealthFactor());
        }
        return this.actualMaxHealth;
    }

    public void setActualHealth(float health, float maxHealth) {
        this.actualHealth = health;
        this.actualMaxHealth = maxHealth;
    }

    protected EntityLivingBase getMobTarget() {
        return this.attackTarget;
    }

    public Class<?>[] getBlackListMobClasses() {
        return null;
    }

    public Class<?>[] getModsNotToMixWith() {
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof MobModifier && ((MobModifier)o).modName.equals(this.modName);
    }

    public int getModSize() {
        if (this.bufferedSize == 0) {
            this.bufferedSize = 1;
            MobModifier nextmod = this.nextMod;
            while (nextmod != null) {
                ++this.bufferedSize;
                nextmod = nextmod.nextMod;
            }
        }
        return this.bufferedSize;
    }

    protected String[] getModNamePrefix() {
        return null;
    }

    protected String[] getModNameSuffix() {
        return null;
    }

    public String getEntityDisplayName(EntityLivingBase target) {
        if (this.bufferedEntityName == null) {
            StringBuilder buffer = new StringBuilder();
            String mobName = target.func_70005_c_();
            if (mobName == null) {
                mobName = target.getClass().getSimpleName();
                mobName = !StringUtils.func_151246_b((String)mobName) ? mobName.replaceFirst("Entity", "") : "Monster";
            }
            int size = this.getModSize();
            MobModifier mod = this;
            for (int randomMod = target.func_70681_au().nextInt(this.getModSize()); randomMod > 0; --randomMod) {
                mod = mod.nextMod;
            }
            String modprefix = "";
            if (mod.getModNamePrefix() != null) {
                modprefix = mod.getModNamePrefix()[target.func_70681_au().nextInt(mod.getModNamePrefix().length)];
                modprefix = StatCollector.func_74838_a((String)("translation.infernalmobs:prefix." + modprefix));
            }
            if (size <= 5) {
                buffer.append(EnumChatFormatting.YELLOW).append(StatCollector.func_74838_a((String)"translation.infernalmobs:rareClass"));
            } else if (size <= 10) {
                buffer.append(EnumChatFormatting.GOLD).append(StatCollector.func_74838_a((String)"translation.infernalmobs:ultraClass"));
            } else {
                buffer.append(EnumChatFormatting.RED).append(StatCollector.func_74838_a((String)"translation.infernalmobs:infernalClass"));
            }
            buffer.append(modprefix);
            buffer.append(mobName);
            if (size > 1) {
                MobModifier mobModifier = mod = mod.nextMod != null ? mod.nextMod : this;
                if (mod.getModNameSuffix() != null) {
                    String pickedSuffix = mod.getModNameSuffix()[target.func_70681_au().nextInt(mod.getModNameSuffix().length)];
                    buffer.append(StatCollector.func_74838_a((String)("translation.infernalmobs:suffix." + pickedSuffix)));
                }
            }
            this.bufferedEntityName = buffer.toString();
        }
        return this.bufferedEntityName;
    }

    public void resetModifiedVictim(EntityPlayer victim) {
    }

    public String getModName() {
        return this.modName;
    }
}

