/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.ingameinfo.client.gui.Info;
import com.github.lunatrius.ingameinfo.client.gui.InfoIcon;
import com.github.lunatrius.ingameinfo.client.gui.InfoText;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.Collection;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;

public abstract class TagPlayerPotion
extends Tag {
    public static final int MAXIMUM_INDEX = Potion.field_76425_a.length;
    protected static PotionEffect[] potionEffects = null;
    protected final int index;

    public TagPlayerPotion(int index) {
        this.index = index;
    }

    @Override
    public String getName() {
        return super.getName() + this.index;
    }

    @Override
    public String[] getAliases() {
        String[] aliases = super.getAliases();
        String[] aliasesIndexed = new String[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            aliasesIndexed[i] = aliases[i] + this.index;
        }
        return aliasesIndexed;
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public int getMaximumIndex() {
        return MAXIMUM_INDEX - 1;
    }

    @Override
    public String getCategory() {
        return "playerpotion";
    }

    protected void updatePotionEffects() {
        if (potionEffects == null) {
            Collection potionEffectCollection = player.func_70651_bq();
            potionEffects = new PotionEffect[potionEffectCollection.size()];
            if (!potionEffectCollection.isEmpty()) {
                int index = 0;
                for (PotionEffect potionEffect : potionEffectCollection) {
                    TagPlayerPotion.potionEffects[index++] = potionEffect;
                }
            }
        }
    }

    public static void register() {
        for (int i = 0; i < MAXIMUM_INDEX; ++i) {
            TagRegistry.INSTANCE.register(new Effect(i).setName("potioneffect"));
            TagRegistry.INSTANCE.register(new Duration(i).setName("potionduration"));
            TagRegistry.INSTANCE.register(new DurationTicks(i).setName("potiondurationticks"));
            TagRegistry.INSTANCE.register(new Negative(i).setName("potionnegative"));
            TagRegistry.INSTANCE.register(new Icon(i, false).setName("potionicon"));
            TagRegistry.INSTANCE.register(new Icon(i, true).setName("potionlargeicon"));
        }
    }

    public static void releaseResources() {
        potionEffects = null;
    }

    public static class Effect
    extends TagPlayerPotion {
        public Effect(int index) {
            super(index);
        }

        @Override
        public String getValue() {
            this.updatePotionEffects();
            if (potionEffects.length > this.index) {
                String str = I18n.func_135052_a((String)potionEffects[this.index].func_76453_d(), (Object[])new Object[0]);
                switch (potionEffects[this.index].func_76458_c()) {
                    case 1: {
                        str = str + " II";
                        break;
                    }
                    case 2: {
                        str = str + " III";
                        break;
                    }
                    case 3: {
                        str = str + " IV";
                    }
                }
                return str;
            }
            return "";
        }
    }

    public static class Duration
    extends TagPlayerPotion {
        public Duration(int index) {
            super(index);
        }

        @Override
        public String getValue() {
            this.updatePotionEffects();
            if (potionEffects.length > this.index) {
                return Potion.func_76389_a((PotionEffect)potionEffects[this.index]);
            }
            return "0:00";
        }
    }

    public static class DurationTicks
    extends TagPlayerPotion {
        public DurationTicks(int index) {
            super(index);
        }

        @Override
        public String getValue() {
            this.updatePotionEffects();
            if (potionEffects.length > this.index) {
                return String.valueOf(potionEffects[this.index].func_76459_b());
            }
            return "0";
        }
    }

    public static class Negative
    extends TagPlayerPotion {
        public Negative(int index) {
            super(index);
        }

        @Override
        public String getValue() {
            this.updatePotionEffects();
            if (potionEffects.length > this.index) {
                Potion potion = Potion.field_76425_a[potionEffects[this.index].func_76456_a()];
                return String.valueOf(potion.func_76398_f());
            }
            return "false";
        }
    }

    public static class Icon
    extends TagPlayerPotion {
        private final boolean large;

        public Icon(int index, boolean large) {
            super(index);
            this.large = large;
        }

        @Override
        @NotNull
        public String getValue(@NotNull InfoText parent) {
            this.updatePotionEffects();
            if (potionEffects.length > this.index) {
                Info value = parent.getAttachedValue(this.getName());
                Potion potion = Potion.field_76425_a[potionEffects[this.index].func_76456_a()];
                if (!potion.func_76400_d()) {
                    return "";
                }
                if (this.shouldUpdate(value, potion.field_76415_H)) {
                    InfoIcon icon = value == null ? new InfoIcon("textures/gui/container/inventory.png") : (InfoIcon)value;
                    int i = potion.func_76392_e();
                    if (this.large) {
                        icon.setDisplayDimensions(1, -5, 18, 18);
                    } else {
                        icon.setDisplayDimensions(1, -1, 9, 9);
                    }
                    icon.setIdentifier(String.valueOf(potion.field_76415_H));
                    icon.setTextureData(i % 8 * 18, 198 + i / 8 * 18, 18, 18, 256, 256);
                    if (value != null) {
                        return value.getIconSpacing();
                    }
                    parent.attachValue(this.getName(), icon);
                    return Icon.getIconTag(icon);
                }
                return value.getIconSpacing();
            }
            return "";
        }

        @Override
        public String getValue() {
            return "";
        }

        private boolean shouldUpdate(Info value, int potionId) {
            return value == null || !value.getIdentifier().equals(String.valueOf(potionId));
        }
    }
}

