/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.command;

import com.github.lunatrius.core.handler.DelayedGuiDisplayTicker;
import com.github.lunatrius.ingameinfo.InGameInfoCore;
import com.github.lunatrius.ingameinfo.client.gui.GuiModConfig;
import com.github.lunatrius.ingameinfo.client.gui.GuiTags;
import com.github.lunatrius.ingameinfo.handler.ConfigurationHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class InGameInfoCommand
extends CommandBase {
    public static final InGameInfoCommand INSTANCE = new InGameInfoCommand();
    private final InGameInfoCore core = InGameInfoCore.INSTANCE;

    private InGameInfoCommand() {
    }

    public String func_71517_b() {
        return "igi";
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "commands.ingameinfoxml.usage";
    }

    public boolean func_71519_b(ICommandSender par1ICommandSender) {
        return true;
    }

    public List<String> func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return InGameInfoCommand.func_71530_a((String[])args, (String[])new String[]{"reload", "load", "save", "enable", "disable", "taglist", "config"});
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("load")) {
                return InGameInfoCommand.func_71531_a((String[])args, this.getFilenames());
            }
            if (args[0].equalsIgnoreCase("save")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"InGameInfo.xml", "InGameInfo.json", "InGameInfo.txt"});
            }
        }
        return null;
    }

    private List<String> getFilenames() {
        File[] files = this.core.getConfigDirectory().listFiles((dir, name) -> name.startsWith("InGameInfo") && (name.endsWith(".xml") || name.endsWith(".json") || name.endsWith(".txt")));
        ArrayList<String> filenames = new ArrayList<String>();
        if (files == null) {
            return filenames;
        }
        for (File file : files) {
            filenames.add(file.getName());
        }
        return filenames;
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("reload")) {
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.ingameinfoxml.reload", new Object[0]));
                ConfigurationHandler.reload();
                boolean success = this.core.reloadConfig();
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation(success ? "commands.ingameinfoxml.success" : "commands.ingameinfoxml.failure", new Object[0]));
                return;
            }
            if (args[0].equalsIgnoreCase("load")) {
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.ingameinfoxml.load", new Object[]{args[1]}));
                boolean success = this.core.loadConfig(args[1]);
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation(success ? "commands.ingameinfoxml.success" : "commands.ingameinfoxml.failure", new Object[0]));
                if (success) {
                    ConfigurationHandler.setConfigName(args[1]);
                    ConfigurationHandler.save();
                }
                return;
            }
            if (args[0].equalsIgnoreCase("save")) {
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.ingameinfoxml.save", new Object[]{args[1]}));
                boolean success = this.core.saveConfig(args[1]);
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation(success ? "commands.ingameinfoxml.success" : "commands.ingameinfoxml.failure", new Object[0]));
                return;
            }
            if (args[0].equalsIgnoreCase("enable")) {
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.ingameinfoxml.enable", new Object[0]));
                ConfigurationHandler.showHUD = true;
                ConfigurationHandler.saveHUDsettingToFile();
                return;
            }
            if (args[0].equalsIgnoreCase("disable")) {
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.ingameinfoxml.disable", new Object[0]));
                ConfigurationHandler.showHUD = false;
                ConfigurationHandler.saveHUDsettingToFile();
                return;
            }
            if (args[0].equalsIgnoreCase("taglist")) {
                DelayedGuiDisplayTicker.create((GuiScreen)new GuiTags(), (int)10);
                return;
            }
            if (args[0].equalsIgnoreCase("config")) {
                DelayedGuiDisplayTicker.create((GuiScreen)new GuiModConfig(null), (int)0);
                return;
            }
        }
        throw new WrongUsageException(this.func_71518_a(commandSender), new Object[0]);
    }

    public int compareTo(Object obj) {
        return super.compareTo(obj);
    }
}

