/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.panel;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.api.IRemoteSensor;
import shedar.mods.ic2.nuclearcontrol.utils.ItemStackUtils;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearNetworkHelper;

public class CardWrapperImpl
implements ICardWrapper {
    private ItemStack card;
    private Map<String, Object> updateSet;
    private byte slot;

    public CardWrapperImpl(ItemStack card, int slot) {
        if (!(card.func_77973_b() instanceof IPanelDataSource)) {
            IC2NuclearControl.logger.error("CardHelper should be used for IPanelDataSource items.");
        }
        this.card = card;
        this.slot = (byte)slot;
        this.updateSet = new HashMap<String, Object>();
    }

    @Override
    public void setTarget(int x, int y, int z) {
        if (!(this.card.func_77973_b() instanceof IRemoteSensor)) {
            IC2NuclearControl.logger.warn("Trying to set coordinates [%d, %d, %d] for item which is not RemoteSensor.", new Object[]{x, y, z});
            return;
        }
        NBTTagCompound nbtTagCompound = ItemStackUtils.getTagCompound(this.card);
        nbtTagCompound.func_74768_a("x", x);
        nbtTagCompound.func_74768_a("y", y);
        nbtTagCompound.func_74768_a("z", z);
    }

    @Override
    public ChunkCoordinates getTarget() {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return null;
        }
        ChunkCoordinates coordinates = new ChunkCoordinates();
        coordinates.field_71574_a = nbtTagCompound.func_74762_e("x");
        coordinates.field_71572_b = nbtTagCompound.func_74762_e("y");
        coordinates.field_71573_c = nbtTagCompound.func_74762_e("z");
        return coordinates;
    }

    @Override
    public void setInt(String name, Integer value) {
        NBTTagCompound nbtTagCompound = ItemStackUtils.getTagCompound(this.card);
        if (nbtTagCompound.func_74764_b(name)) {
            Integer prevValue = nbtTagCompound.func_74762_e(name);
            if (prevValue == null || !prevValue.equals(value)) {
                this.updateSet.put(name, value);
            }
        } else {
            this.updateSet.put(name, value);
        }
        nbtTagCompound.func_74768_a(name, value.intValue());
    }

    @Override
    public Integer getInt(String name) {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return 0;
        }
        return nbtTagCompound.func_74762_e(name);
    }

    @Override
    public void setLong(String name, Long value) {
        NBTTagCompound nbtTagCompound = ItemStackUtils.getTagCompound(this.card);
        if (nbtTagCompound.func_74764_b(name)) {
            Long prevValue = nbtTagCompound.func_74763_f(name);
            if (prevValue == null || !prevValue.equals(value)) {
                this.updateSet.put(name, value);
            }
        } else {
            this.updateSet.put(name, value);
        }
        nbtTagCompound.func_74772_a(name, value.longValue());
    }

    @Override
    public Long getLong(String name) {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return 0L;
        }
        return nbtTagCompound.func_74763_f(name);
    }

    @Override
    public void setDouble(String name, Double value) {
        NBTTagCompound nbtTagCompound = ItemStackUtils.getTagCompound(this.card);
        if (nbtTagCompound.func_74764_b(name)) {
            Double prevValue = nbtTagCompound.func_74769_h(name);
            if (prevValue == null || prevValue != value) {
                this.updateSet.put(name, value);
            }
        } else {
            this.updateSet.put(name, value);
        }
        nbtTagCompound.func_74780_a(name, value.doubleValue());
    }

    @Override
    public Double getDouble(String name) {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return 0.0;
        }
        return nbtTagCompound.func_74769_h(name);
    }

    @Override
    public void setString(String name, String value) {
        if (name == null) {
            return;
        }
        NBTTagCompound nbtTagCompound = ItemStackUtils.getTagCompound(this.card);
        if (nbtTagCompound.func_74764_b(name)) {
            String prevValue = nbtTagCompound.func_74779_i(name);
            if (prevValue == null || !prevValue.equals(value)) {
                this.updateSet.put(name, value);
            }
        } else {
            this.updateSet.put(name, value);
        }
        nbtTagCompound.func_74778_a(name, value);
    }

    @Override
    public String getString(String name) {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return "";
        }
        return nbtTagCompound.func_74779_i(name);
    }

    @Override
    public void setBoolean(String name, Boolean value) {
        NBTTagCompound nbtTagCompound = ItemStackUtils.getTagCompound(this.card);
        if (nbtTagCompound.func_74764_b(name)) {
            Boolean prevValue = nbtTagCompound.func_74767_n(name);
            if (prevValue == null || !prevValue.equals(value)) {
                this.updateSet.put(name, value);
            }
        } else {
            this.updateSet.put(name, value);
        }
        nbtTagCompound.func_74757_a(name, value.booleanValue());
    }

    @Override
    public Boolean getBoolean(String name) {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return false;
        }
        return nbtTagCompound.func_74767_n(name);
    }

    @Override
    public void setTitle(String title) {
        this.setString("title", title);
    }

    @Override
    public String getTitle() {
        return this.getString("title");
    }

    @Override
    public CardState getState() {
        return CardState.fromInteger(this.getInt("state"));
    }

    @Override
    public void setState(CardState state) {
        this.setInt("state", state.getIndex());
    }

    @Override
    public ItemStack getItemStack() {
        return this.card;
    }

    @Override
    public boolean hasField(String field) {
        return ItemStackUtils.getTagCompound(this.card).func_74764_b(field);
    }

    @Override
    public void commit(TileEntity panel) {
        if (!this.updateSet.isEmpty()) {
            NuclearNetworkHelper.setSensorCardField(panel, this.slot, this.updateSet);
        }
    }

    @Override
    public void setTag(String name, NBTTagCompound value) {
        NBTTagCompound nbtTagCompound = ItemStackUtils.getTagCompound(this.card);
        if (nbtTagCompound.func_74764_b(name)) {
            NBTBase prevValue = nbtTagCompound.func_74781_a(name);
            if (prevValue == null || !prevValue.equals((Object)value)) {
                this.updateSet.put(name, value);
            }
        } else {
            this.updateSet.put(name, value);
        }
        if (value == null) {
            nbtTagCompound.func_82580_o(name);
        } else {
            nbtTagCompound.func_74782_a(name, (NBTBase)value);
        }
    }

    @Override
    public NBTTagCompound getTag(String name) {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return null;
        }
        return (NBTTagCompound)nbtTagCompound.func_74781_a(name);
    }

    public void clearField(String name) {
        NBTTagCompound nbtTagCompound = ItemStackUtils.getTagCompound(this.card);
        nbtTagCompound.func_82580_o(name);
    }

    public Map<String, Object> getUpdateSet() {
        return this.updateSet;
    }
}

