/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.achievements;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.mechanics.causatum.CausatumUtils;
import chylex.hee.mechanics.essence.EssenceType;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.DragonSavefile;
import chylex.hee.system.savedata.types.QuickSavefile;
import chylex.hee.system.util.BlockPosM;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public final class AchievementEvents
implements QuickSavefile.IQuickSavefile {
    private static AchievementEvents instance;
    private ArrayListMultimap<UUID, Achievement> delayedAchievements = ArrayListMultimap.create();

    public static void register() {
        instance = new AchievementEvents();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        FMLCommonHandler.instance().bus().register((Object)instance);
        QuickSavefile.addHandler(instance);
    }

    public static void addDelayedAchievement(UUID id, Achievement achievement) {
        AchievementEvents.instance.delayedAchievements.put((Object)id, (Object)achievement);
        ((QuickSavefile)WorldDataHandler.get(QuickSavefile.class)).setModified();
    }

    private AchievementEvents() {
    }

    @Override
    public void onSave(NBTTagCompound nbt) {
        for (UUID id : this.delayedAchievements.keySet()) {
            ArrayList<String> achievements = new ArrayList<String>();
            for (Achievement achievement : this.delayedAchievements.get((Object)id)) {
                achievements.add(achievement.field_75975_e);
            }
            nbt.func_74778_a(id.toString(), Joiner.on((char)'|').join(achievements));
        }
    }

    @Override
    public void onLoad(NBTTagCompound nbt) {
        this.delayedAchievements.clear();
        for (String key : nbt.func_150296_c()) {
            block1: for (String achievementId : nbt.func_74779_i(key).split("\\|")) {
                for (Achievement achievement : AchievementList.field_76007_e) {
                    if (!achievement.field_75975_e.equals(achievementId)) continue;
                    this.delayedAchievements.put((Object)UUID.fromString(key), (Object)achievement);
                    continue block1;
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player.field_71093_bK == 1 && ((DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).isDragonDead()) {
            e.player.func_71064_a((StatBase)AchievementManager.GO_INTO_THE_END, 1);
        }
        QuickSavefile file = (QuickSavefile)WorldDataHandler.get(QuickSavefile.class);
        if (!this.delayedAchievements.isEmpty() && this.delayedAchievements.containsKey((Object)e.player.func_110124_au())) {
            for (Achievement achievement : this.delayedAchievements.removeAll((Object)e.player.func_110124_au())) {
                e.player.func_71064_a((StatBase)achievement, 1);
            }
            file.setModified();
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        if (e.toDim == 1) {
            if (((DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).isDragonDead()) {
                e.player.func_71064_a((StatBase)AchievementManager.GO_INTO_THE_END, 1);
            }
            CausatumUtils.increase(e.player, CausatumMeters.OVERWORLD_PORTAL, 100.0f);
        }
    }

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent e) {
        ItemStack is = e.pickedUp.func_92059_d();
        Item item = is.func_77973_b();
        if (item == ItemList.end_powder) {
            e.player.func_71064_a((StatBase)AchievementManager.END_POWDER, 1);
        } else if (item == ItemList.stardust) {
            e.player.func_71064_a((StatBase)AchievementManager.STARDUST, 1);
        } else if (item == ItemList.endium_ingot) {
            e.player.func_71064_a((StatBase)AchievementManager.ENDIUM_INGOT, 1);
        } else if (item == ItemList.essence && is.func_77960_j() == EssenceType.FIERY.getItemDamage()) {
            e.player.func_71064_a((StatBase)AchievementManager.FIERY_ESSSENCE, 1);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent e) {
        if (e.crafting.func_77973_b() == Item.func_150898_a((Block)BlockList.void_chest)) {
            e.player.func_71064_a((StatBase)AchievementManager.VOID_CHEST, 1);
        }
    }

    @SubscribeEvent
    public void onItemSmelted(PlayerEvent.ItemSmeltedEvent e) {
        if (e.smelting.func_77973_b() == ItemList.endium_ingot) {
            e.player.func_71064_a((StatBase)AchievementManager.ENDIUM_INGOT, 1);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent e) {
        if (!e.entity.field_70170_p.field_72995_K && e.entity.field_71093_bK == 1 && e.entity.field_70170_p.func_82737_E() - EntityBossDragon.lastUpdate < 20L && e.entity instanceof EntityPlayer) {
            for (Object o : e.entity.field_70170_p.field_72996_f) {
                if (!(o instanceof EntityBossDragon)) continue;
                ((EntityBossDragon)o).achievements.onPlayerDied((EntityPlayer)e.entity);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent e) {
        World world = e.entityPlayer.field_70170_p;
        BlockPosM tmpPos = BlockPosM.tmp(e.x, e.y, e.z);
        if (e.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK || world.field_72995_K || e.entityPlayer.field_71093_bK != 1 || tmpPos.getBlock((IBlockAccess)world) != Blocks.field_150324_C) {
            return;
        }
        EntityBossDragon dragon = this.getDragon(world);
        if (dragon == null || dragon.func_110143_aJ() <= 0.0f) {
            return;
        }
        e.useBlock = Event.Result.DENY;
        double dX = (double)e.x + 0.5;
        double dY = (double)e.y + 0.5;
        double dZ = (double)e.z + 0.5;
        tmpPos.setAir(world);
        int dir = tmpPos.getMetadata((IBlockAccess)world) & 3;
        if (tmpPos.move(BlockBed.field_149981_a[dir][0], 0, BlockBed.field_149981_a[dir][1]).getBlock((IBlockAccess)world) == Blocks.field_150324_C) {
            tmpPos.setAir(world);
            dX = (dX + (double)tmpPos.x + 0.5) / 2.0;
            dY = (dY + (double)tmpPos.y + 0.5) / 2.0;
            dZ = (dZ + (double)tmpPos.z + 0.5) / 2.0;
        }
        world.func_72885_a(null, dX, dY, dZ, 5.0f, true, true);
        if (dragon.func_110143_aJ() <= 0.0f) {
            e.entityPlayer.func_71064_a((StatBase)AchievementManager.CHALLENGE_BEDEXPLODE, 1);
        }
    }

    private EntityBossDragon getDragon(World world) {
        for (Object o : world.field_72996_f) {
            if (!(o instanceof EntityBossDragon)) continue;
            return (EntityBossDragon)o;
        }
        return null;
    }
}

