/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.enhancements;

import chylex.hee.system.logging.Log;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;

public final class EnhancementEnumHelper {
    public static String getName(Enum enhancementEnum, EnumChatFormatting color) {
        return EnumChatFormatting.RESET + color + enhancementEnum.name().substring(0, 1).toUpperCase() + enhancementEnum.name().substring(1).toLowerCase().replace('_', ' ');
    }

    public static String serialize(List<Enum> list) {
        StringBuilder build = new StringBuilder();
        for (Enum enhancement : list) {
            build.append(enhancement.name()).append(',');
        }
        return (build.length() > 0 ? build.deleteCharAt(build.length() - 1) : build).toString();
    }

    public static List<Enum> deserialize(String str, Class<? extends Enum> enumClass) {
        ArrayList<Enum> types = new ArrayList<Enum>();
        if (str.isEmpty()) {
            return types;
        }
        for (String s : str.split(",")) {
            try {
                types.add(Enum.valueOf(enumClass, s));
            }
            catch (IllegalArgumentException e) {
                Log.error("Unknown enhancement (" + enumClass.getSimpleName() + ") entry: " + s + " (saved data: " + str + ")", new Object[0]);
            }
        }
        return types;
    }

    private EnhancementEnumHelper() {
    }
}

