/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.GalaxySpace;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.item.block.GSItemBlockDesc;
import galaxyspace.core.tile.machine.TileEntitySolarPanel;
import java.util.List;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSolarPanel
extends BlockTileGC
implements GSItemBlockDesc.IBlockShiftDesc,
IPartialSealableBlock {
    public static final int HYBRID_METADATA = 0;
    public static final int ULTRA_METADATA = 4;
    public static String[] names = new String[]{"hybrid", "ultra"};
    private IIcon[] icons = new IIcon[6];

    public BlockSolarPanel(String assetName) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName + 1);
        this.func_149663_c(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.icons[0] = par1IconRegister.func_94245_a("galaxyspace:overworld/solar_hybrid_0");
        this.icons[1] = par1IconRegister.func_94245_a("galaxyspace:overworld/solar_hybrid_1");
        this.icons[2] = par1IconRegister.func_94245_a("galaxyspace:overworld/solar_ultra_0");
        this.icons[3] = par1IconRegister.func_94245_a("galaxyspace:overworld/solar_ultra_1");
        this.icons[4] = par1IconRegister.func_94245_a("galaxyspace:overworld/machine");
        this.icons[5] = par1IconRegister.func_94245_a("galaxyspace:overworld/machine_output");
        this.field_149761_L = this.icons[0];
    }

    public CreativeTabs func_149708_J() {
        return GalaxySpace.tabBlocks;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta >= 4) {
            int shiftedMeta = meta -= 4;
            if (side == ForgeDirection.getOrientation((int)(shiftedMeta + 2)).getOpposite().ordinal()) {
                return this.icons[5];
            }
            if (side == ForgeDirection.UP.ordinal()) {
                return this.icons[2];
            }
            if (side == ForgeDirection.DOWN.ordinal()) {
                return this.icons[4];
            }
            return this.icons[3];
        }
        if (meta < 0) {
            return this.field_149761_L;
        }
        int shiftedMeta = meta += 0;
        if (side == ForgeDirection.getOrientation((int)(shiftedMeta + 2)).getOpposite().ordinal()) {
            return this.icons[5];
        }
        if (side == ForgeDirection.UP.ordinal()) {
            return this.icons[0];
        }
        if (side == ForgeDirection.DOWN.ordinal()) {
            return this.icons[4];
        }
        return this.icons[1];
    }

    public boolean func_149707_d(World world, int x1, int y1, int z1, int side) {
        for (int y2 = 1; y2 <= 2; ++y2) {
            for (int x2 = -1; x2 <= 1; ++x2) {
                for (int z2 = -1; z2 <= 1; ++z2) {
                    Block block = world.func_147439_a(x1 + (y2 == 2 ? x2 : 0), y1 + y2, z1 + (y2 == 2 ? z2 : 0));
                    if (block.func_149688_o() == Material.field_151579_a || block.isReplaceable((IBlockAccess)world, x1 + x2, y1 + y2, z1 + z2)) continue;
                    return false;
                }
            }
        }
        return new BlockVec3(x1, y1, z1).newVecSide(side ^ 1).getBlock((IBlockAccess)world) != GCBlocks.fakeBlock;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
                break;
            }
            case 3: {
                change = 3;
            }
        }
        if (metadata >= 4) {
            world.func_72921_c(x, y, z, 4 + change, 3);
        } else {
            world.func_72921_c(x, y, z, 0 + change, 3);
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntitySolarPanel) {
            ((TileEntitySolarPanel)tile).onCreate(new BlockVec3(x, y, z));
        }
    }

    public void func_149749_a(World var1, int var2, int var3, int var4, Block var5, int var6) {
        TileEntity var7 = var1.func_147438_o(var2, var3, var4);
        if (var7 instanceof TileEntitySolarPanel) {
            ((TileEntitySolarPanel)var7).onDestroy(var7);
        }
        super.func_149749_a(var1, var2, var3, var4, var5, var6);
    }

    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        int original;
        int metadata = original = par1World.func_72805_g(x, y, z);
        int change = 0;
        if (metadata >= 4) {
            original -= 4;
        }
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        if (metadata >= 4) {
            change += 4;
        }
        if ((te = par1World.func_147438_o(x, y, z)) instanceof TileBaseUniversalElectrical) {
            ((TileBaseUniversalElectrical)te).updateFacing();
        }
        par1World.func_72921_c(x, y, z, change, 3);
        return true;
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)GalaxySpace.instance, -1, world, x, y, z);
        return true;
    }

    public int func_149692_a(int metadata) {
        if (metadata >= 4) {
            return 4;
        }
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = this.func_149643_k(world, x, y, z);
        return new ItemStack((Block)this, 1, metadata);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= 4) {
            return new TileEntitySolarPanel(2);
        }
        return new TileEntitySolarPanel(1);
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public String getShiftDescription(int meta) {
        String string;
        switch (meta) {
            case 0: {
                string = GCCoreUtil.translate((String)"tile.SolarHybrid.desc");
                break;
            }
            case 4: {
                string = GCCoreUtil.translate((String)"tile.solarUltra.desc");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isSealed(World world, int x, int y, int z, ForgeDirection direction) {
        return true;
    }

    @Override
    public String getDescription(int meta) {
        return GCCoreUtil.translate((String)"tile.coefficient.desc") + ": x" + GSConfigCore.coefficientSolarPanel;
    }
}

