/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gttweaker.mods.AddMultipleRecipeAction;
import gttweaker.util.ArrayHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.CuttingSaw")
@ModOnly(value={"gregtech"})
public class CuttingSaw {
    @ZenMethod
    public static void addRecipe(IItemStack output1, IItemStack output2, IIngredient input, ILiquidStack lubricant, int durationTicks, int euPerTick) {
        if (lubricant == null) {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Cutting Saw recipe for " + input, new Object[]{input, output1, output2, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{i.nextItem()}).itemOutputs(new ItemStack[]{i.nextItem(), i.nextItem()}).duration(i.nextInt()).eut(i.nextInt()).addTo((IRecipeMap)RecipeMaps.cutterRecipes);
                }
            });
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Cutting Saw recipe for " + input, new Object[]{input, lubricant, output1, output2, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{i.nextItem()}).fluidInputs(new FluidStack[]{i.nextFluid()}).itemOutputs(new ItemStack[]{i.nextItem(), i.nextItem()}).duration(i.nextInt()).eut(i.nextInt()).addTo((IRecipeMap)RecipeMaps.cutterRecipes);
                }
            });
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] output, IIngredient input, ILiquidStack lubricant, int durationTicks, int euPerTick) {
        if (output.length == 0) {
            MineTweakerAPI.logError((String)"canner requires at least 1 output");
        } else {
            CuttingSaw.addRecipe(output[0], ArrayHelper.itemOrNull(output, 1), input, lubricant, durationTicks, euPerTick);
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack output1, IItemStack output2, IIngredient input, IItemStack circuit, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Cutting Saw recipe for " + input, new Object[]{input, circuit, output1, output2, durationTicks, euPerTick}){

            @Override
            protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{i.nextItem(), i.nextItem()}).itemOutputs(new ItemStack[]{i.nextItem(), i.nextItem()}).duration(i.nextInt()).eut(i.nextInt()).addTo((IRecipeMap)RecipeMaps.cutterRecipes);
            }
        });
    }
}

