/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.scripts;

import com.dreammaster.main.MainRegistry;
import com.dreammaster.recipes.ShapedUniversalRecipe;
import com.dreammaster.recipes.ShapelessUniversalRecipe;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.util.GTModHandler;
import gregtech.common.items.MetaGeneratedItem01;
import gregtech.common.items.MetaGeneratedItem02;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;

public interface IScriptLoader {
    public static final int wildcard = Short.MAX_VALUE;
    public static final ItemStack missing = new ItemStack((Block)Blocks.field_150480_ab);

    public String getScriptName();

    public List<String> getDependencies();

    public void loadRecipes();

    default public boolean addShapedRecipe(ItemStack aOutput, Object ... inputs) {
        try {
            GameRegistry.addRecipe((IRecipe)new ShapedUniversalRecipe(aOutput, inputs));
        }
        catch (Exception e) {
            MainRegistry.Logger.error((Object)"a recipe went wrong:");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    default public boolean addShapelessRecipe(ItemStack aOutput, Object ... inputs) {
        try {
            GameRegistry.addRecipe((IRecipe)new ShapelessUniversalRecipe(aOutput, inputs));
        }
        catch (Exception e) {
            MainRegistry.Logger.error((Object)"a recipe went wrong:");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Object[] removeNulls(Object[] v) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(v));
        list.removeAll(Collections.singleton(null));
        return list.toArray(new Object[0]);
    }

    default public ItemStack getMeta02(int meta) {
        return new ItemStack((Item)MetaGeneratedItem02.INSTANCE, 1, meta);
    }

    default public ItemStack getMeta01(int meta) {
        return new ItemStack((Item)MetaGeneratedItem01.INSTANCE, 1, meta);
    }

    default public ItemStack createItemStack(String aModID, String aItem, long aAmount, int aMeta, String aNBTString, ItemStack aReplacement) {
        ItemStack s = GTModHandler.getModItem((String)aModID, (String)aItem, (long)aAmount, (int)aMeta);
        if (s == null) {
            return aReplacement;
        }
        try {
            s.field_77990_d = (NBTTagCompound)JsonToNBT.func_150315_a((String)aNBTString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return s;
    }

    default public boolean isScriptLoadable() {
        for (String dep : this.getDependencies()) {
            if (Loader.isModLoaded((String)dep)) continue;
            return false;
        }
        return true;
    }
}

