/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.recipes;

import com.dreammaster.recipes.IngredientsFlattener;
import com.dreammaster.recipes.Recipe;
import com.dreammaster.recipes.ResolvedIngredientsFlattener;
import com.dreammaster.recipes.ShapedIngredientsResolver;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

class RecipeArgs
implements Recipe {
    private final UnaryOperator<Object[]> defaultIngredientsResolver = new ShapedIngredientsResolver();
    private final IngredientsFlattener ingredientsFlattener = new ResolvedIngredientsFlattener();
    protected final ItemStack result;
    protected final Object[] ingredients;
    private Object[] resolvedIngredients;

    RecipeArgs(ItemStack result, Object ... ingredients) {
        if (Objects.isNull(result)) {
            throw new NullPointerException("Craft created with null result!");
        }
        if (Objects.isNull(ingredients)) {
            throw new NullPointerException("Craft created with null ingredients!");
        }
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Craft created with no ingredients!");
        }
        this.result = result.func_77946_l();
        this.ingredients = Arrays.copyOf(ingredients, ingredients.length);
    }

    @Override
    @Nonnull
    public ItemStack[] flatten() {
        return this.ingredientsFlattener.flatten(this.getResolvedIngredients());
    }

    @Override
    @Nonnull
    public ItemStack[] flattenWith(@Nonnull UnaryOperator<Object[]> ingredientsResolver) {
        return this.ingredientsFlattener.flatten((Object[])ingredientsResolver.apply(this.ingredients));
    }

    private Object[] getResolvedIngredients() {
        if (this.resolvedIngredients == null) {
            this.resolvedIngredients = (Object[])this.defaultIngredientsResolver.apply(this.ingredients);
        }
        return this.resolvedIngredients;
    }

    @Override
    @Nonnull
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    @Nonnull
    public Object[] getIngredients() {
        return this.ingredients;
    }

    @Override
    @Nonnull
    public Recipe provideTo(@Nonnull Consumer<Recipe> recipeUser) {
        recipeUser.accept(this);
        return this;
    }

    public String toString() {
        return "Recipe{result=" + this.result + ", ingredients=" + Arrays.toString(this.ingredients) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipeArgs that = (RecipeArgs)o;
        return this.result.func_77969_a(that.result) && Arrays.equals(this.ingredients, that.ingredients);
    }

    public int hashCode() {
        int result1 = Objects.hash(this.result);
        result1 = 31 * result1 + Arrays.hashCode(this.ingredients);
        return result1;
    }
}

