/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.mantle;

import com.dreammaster.mantle.MantleManualRecipeRegistry;
import com.dreammaster.recipes.Recipe;
import com.dreammaster.recipes.ShapedIngredientsResolver;
import com.dreammaster.recipes.ShapelessIngredientsResolver;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import mantle.lib.client.MantleClientRegistry;
import net.minecraft.item.ItemStack;

class MantleClientRegistryProxy
implements MantleManualRecipeRegistry {
    private static final UnaryOperator<Object[]> SHAPED_INGREDIENTS_RESOLVER = new ShapedIngredientsResolver();
    private static final UnaryOperator<Object[]> SHAPELESS_INGREDIENTS_RESOLVER = new ShapelessIngredientsResolver();

    MantleClientRegistryProxy() {
    }

    @Override
    @Nonnull
    public Consumer<Recipe> manualShapedCraftingRecipeNamed(String manualRecipeName) {
        Objects.requireNonNull(manualRecipeName);
        return recipe -> this.setTicoManualRecipe(manualRecipeName, recipe.getResult(), recipe.flattenWith(SHAPED_INGREDIENTS_RESOLVER));
    }

    @Override
    @Nonnull
    public Consumer<Recipe> manualShapelessCraftingRecipeNamed(String manualRecipeName) {
        Objects.requireNonNull(manualRecipeName);
        return recipe -> this.setTicoManualRecipe(manualRecipeName, recipe.getResult(), recipe.flattenWith(SHAPELESS_INGREDIENTS_RESOLVER));
    }

    private void setTicoManualRecipe(String name, ItemStack result, ItemStack[] recipe) {
        if (recipe.length <= 4) {
            MantleClientRegistry.registerManualSmallRecipe((String)name, (ItemStack)result, (ItemStack[])Arrays.copyOf(recipe, 4));
        } else if (recipe.length <= 9) {
            MantleClientRegistry.registerManualLargeRecipe((String)name, (ItemStack)result, (ItemStack[])Arrays.copyOf(recipe, 9));
        } else {
            throw new IllegalArgumentException("Recipe has too many ingredients: " + Arrays.toString(recipe));
        }
    }

    @Override
    @Nonnull
    public Consumer<Recipe> manualSmeltingRecipeNamed(String manualRecipeName) {
        Objects.requireNonNull(manualRecipeName);
        return recipe -> MantleClientRegistry.registerManualFurnaceRecipe((String)manualRecipeName, (ItemStack)recipe.getResult(), (ItemStack)recipe.flatten()[0]);
    }
}

